/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.BranchOptions;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.CreateOrReplaceBranchExec$;
import org.apache.spark.sql.execution.datasources.v2.LeafV2CommandExec;
import org.apache.spark.sql.execution.datasources.v2.V2CommandExec;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple7;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001\u0002\u0015*\u0001bB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t%\u0002\u0011\t\u0012)A\u0005\u0017\"A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003V\u0011!I\u0006A!f\u0001\n\u0003Q\u0006\u0002\u00034\u0001\u0005#\u0005\u000b\u0011B.\t\u0011\u001d\u0004!Q3A\u0005\u0002!D\u0001b\u001d\u0001\u0003\u0012\u0003\u0006I!\u001b\u0005\ti\u0002\u0011)\u001a!C\u0001k\"A\u0011\u0010\u0001B\tB\u0003%a\u000f\u0003\u0005{\u0001\tU\r\u0011\"\u0001v\u0011!Y\bA!E!\u0002\u00131\b\u0002\u0003?\u0001\u0005+\u0007I\u0011A;\t\u0011u\u0004!\u0011#Q\u0001\nYDQA \u0001\u0005\u0002}D!\"!\u0005\u0001\u0011\u000b\u0007I\u0011IA\n\u0011\u001d\t\u0019\u0004\u0001C)\u0003kAq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R!I\u0011\u0011\r\u0001\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wB\u0011\"a \u0001#\u0003%\t!!!\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005\u001d\u0005\"CAF\u0001E\u0005I\u0011AAG\u0011%\t\t\nAI\u0001\n\u0003\ti\tC\u0005\u0002\u0014\u0002\t\n\u0011\"\u0001\u0002\u000e\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u0003O\u0003\u0011\u0011!C\u0001\u0003SC\u0011\"a+\u0001\u0003\u0003%\t!!,\t\u0013\u0005e\u0006!!A\u0005B\u0005m\u0006\"CAe\u0001\u0005\u0005I\u0011AAf\u0011%\ty\rAA\u0001\n\u0003\n\tnB\u0005\u0002V&\n\t\u0011#\u0001\u0002X\u001aA\u0001&KA\u0001\u0012\u0003\tI\u000e\u0003\u0004\u007fE\u0011\u0005\u0011q\u001d\u0005\n\u0003S\u0014\u0013\u0011!C#\u0003WD\u0011\"!<#\u0003\u0003%\t)a<\t\u0013\u0005}(%!A\u0005\u0002\n\u0005\u0001\"\u0003B\nE\u0005\u0005I\u0011\u0002B\u000b\u0005e\u0019%/Z1uK>\u0013(+\u001a9mC\u000e,'I]1oG\",\u00050Z2\u000b\u0005)Z\u0013A\u0001<3\u0015\taS&A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u00180\u0003%)\u00070Z2vi&|gN\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001su\u0002e\t\u0005\u0002;w5\t\u0011&\u0003\u0002=S\tiaKM\"p[6\fg\u000eZ#yK\u000e\u0004\"A\u000f \n\u0005}J#!\u0005'fC\u001a4&gQ8n[\u0006tG-\u0012=fGB\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n9\u0001K]8ek\u000e$\bCA!H\u0013\tA%I\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004dCR\fGn\\4\u0016\u0003-\u0003\"\u0001\u0014)\u000e\u00035S!!\u0013(\u000b\u0005={\u0013!C2p]:,7\r^8s\u0013\t\tVJ\u0001\u0007UC\ndWmQ1uC2|w-\u0001\u0005dCR\fGn\\4!\u0003\u0015IG-\u001a8u+\u0005)\u0006C\u0001'W\u0013\t9VJ\u0001\u0006JI\u0016tG/\u001b4jKJ\fa!\u001b3f]R\u0004\u0013A\u00022sC:\u001c\u0007.F\u0001\\!\ta6M\u0004\u0002^CB\u0011aLQ\u0007\u0002?*\u0011\u0001mN\u0001\u0007yI|w\u000e\u001e \n\u0005\t\u0014\u0015A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!A\u0019\"\u0002\u000f\t\u0014\u0018M\\2iA\u0005i!M]1oG\"|\u0005\u000f^5p]N,\u0012!\u001b\t\u0003UFl\u0011a\u001b\u0006\u0003Y6\fq\u0001\\8hS\u000e\fGN\u0003\u0002o_\u0006)\u0001\u000f\\1og*\u0011\u0001oL\u0001\tG\u0006$\u0018\r\\=ti&\u0011!o\u001b\u0002\u000e\u0005J\fgn\u00195PaRLwN\\:\u0002\u001d\t\u0014\u0018M\\2i\u001fB$\u0018n\u001c8tA\u000511M]3bi\u0016,\u0012A\u001e\t\u0003\u0003^L!\u0001\u001f\"\u0003\u000f\t{w\u000e\\3b]\u000691M]3bi\u0016\u0004\u0013a\u0002:fa2\f7-Z\u0001\te\u0016\u0004H.Y2fA\u0005Y\u0011N\u001a(pi\u0016C\u0018n\u001d;t\u00031IgMT8u\u000bbL7\u000f^:!\u0003\u0019a\u0014N\\5u}Q\u0001\u0012\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\f\u00055\u0011q\u0002\t\u0003u\u0001AQ!S\bA\u0002-CQaU\bA\u0002UCQ!W\bA\u0002mCQaZ\bA\u0002%DQ\u0001^\bA\u0002YDQA_\bA\u0002YDQ\u0001`\bA\u0002Y\faa\\;uaV$XCAA\u000b!\u0019\t9\"!\t\u0002(9!\u0011\u0011DA\u000f\u001d\rq\u00161D\u0005\u0002\u0007&\u0019\u0011q\u0004\"\u0002\u000fA\f7m[1hK&!\u00111EA\u0013\u0005\r\u0019V-\u001d\u0006\u0004\u0003?\u0011\u0005\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055r.A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA\u0019\u0003W\u0011\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u0007I,h\u000e\u0006\u0002\u00028A1\u0011qCA\u0011\u0003s\u0001B!a\u000f\u0002>5\tq.C\u0002\u0002@=\u00141\"\u00138uKJt\u0017\r\u001c*po\u0006a1/[7qY\u0016\u001cFO]5oOR\u00191,!\u0012\t\u000f\u0005\u001d#\u00031\u0001\u0002J\u0005IQ.\u0019=GS\u0016dGm\u001d\t\u0004\u0003\u0006-\u0013bAA'\u0005\n\u0019\u0011J\u001c;\u0002\t\r|\u0007/\u001f\u000b\u0011\u0003\u0003\t\u0019&!\u0016\u0002X\u0005e\u00131LA/\u0003?Bq!S\n\u0011\u0002\u0003\u00071\nC\u0004T'A\u0005\t\u0019A+\t\u000fe\u001b\u0002\u0013!a\u00017\"9qm\u0005I\u0001\u0002\u0004I\u0007b\u0002;\u0014!\u0003\u0005\rA\u001e\u0005\buN\u0001\n\u00111\u0001w\u0011\u001da8\u0003%AA\u0002Y\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002f)\u001a1*a\u001a,\u0005\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001dC\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\niGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002~)\u001aQ+a\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0011\u0016\u00047\u0006\u001d\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0013S3![A4\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!a$+\u0007Y\f9'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%o\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!'\u0011\t\u0005m\u0015QU\u0007\u0003\u0003;SA!a(\u0002\"\u0006!A.\u00198h\u0015\t\t\u0019+\u0001\u0003kCZ\f\u0017b\u00013\u0002\u001e\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011J\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty+!.\u0011\u0007\u0005\u000b\t,C\u0002\u00024\n\u00131!\u00118z\u0011%\t9,HA\u0001\u0002\u0004\tI%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003{\u0003b!a0\u0002F\u0006=VBAAa\u0015\r\t\u0019MQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAd\u0003\u0003\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019a/!4\t\u0013\u0005]v$!AA\u0002\u0005=\u0016AB3rk\u0006d7\u000fF\u0002w\u0003'D\u0011\"a.!\u0003\u0003\u0005\r!a,\u00023\r\u0013X-\u0019;f\u001fJ\u0014V\r\u001d7bG\u0016\u0014%/\u00198dQ\u0016CXm\u0019\t\u0003u\t\u001aBAIAn\rBi\u0011Q\\Ar\u0017V[\u0016N\u001e<w\u0003\u0003i!!a8\u000b\u0007\u0005\u0005()A\u0004sk:$\u0018.\\3\n\t\u0005\u0015\u0018q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:<DCAAl\u0003!!xn\u0015;sS:<GCAAM\u0003\u0015\t\u0007\u000f\u001d7z)A\t\t!!=\u0002t\u0006U\u0018q_A}\u0003w\fi\u0010C\u0003JK\u0001\u00071\nC\u0003TK\u0001\u0007Q\u000bC\u0003ZK\u0001\u00071\fC\u0003hK\u0001\u0007\u0011\u000eC\u0003uK\u0001\u0007a\u000fC\u0003{K\u0001\u0007a\u000fC\u0003}K\u0001\u0007a/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r!q\u0002\t\u0006\u0003\n\u0015!\u0011B\u0005\u0004\u0005\u000f\u0011%AB(qi&|g\u000e\u0005\u0006B\u0005\u0017YUkW5wmZL1A!\u0004C\u0005\u0019!V\u000f\u001d7fo!I!\u0011\u0003\u0014\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0006\u0011\t\u0005m%\u0011D\u0005\u0005\u00057\tiJ\u0001\u0004PE*,7\r\u001e")
public class CreateOrReplaceBranchExec
extends V2CommandExec
implements LeafV2CommandExec {
    private Seq<Attribute> output;
    private final TableCatalog catalog;
    private final Identifier ident;
    private final String branch;
    private final BranchOptions branchOptions;
    private final boolean create;
    private final boolean replace;
    private final boolean ifNotExists;
    private volatile boolean bitmap$0;

    public static Option<Tuple7<TableCatalog, Identifier, String, BranchOptions, Object, Object, Object>> unapply(CreateOrReplaceBranchExec createOrReplaceBranchExec) {
        return CreateOrReplaceBranchExec$.MODULE$.unapply(createOrReplaceBranchExec);
    }

    public static Function1<Tuple7<TableCatalog, Identifier, String, BranchOptions, Object, Object, Object>, CreateOrReplaceBranchExec> tupled() {
        return CreateOrReplaceBranchExec$.MODULE$.tupled();
    }

    public static Function1<TableCatalog, Function1<Identifier, Function1<String, Function1<BranchOptions, Function1<Object, Function1<Object, Function1<Object, CreateOrReplaceBranchExec>>>>>>> curried() {
        return CreateOrReplaceBranchExec$.MODULE$.curried();
    }

    public final Seq<SparkPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public TableCatalog catalog() {
        return this.catalog;
    }

    public Identifier ident() {
        return this.ident;
    }

    public String branch() {
        return this.branch;
    }

    public BranchOptions branchOptions() {
        return this.branchOptions;
    }

    public boolean create() {
        return this.create;
    }

    public boolean replace() {
        return this.replace;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    private Seq<Attribute> output$lzycompute() {
        CreateOrReplaceBranchExec createOrReplaceBranchExec = this;
        synchronized (createOrReplaceBranchExec) {
            if (!this.bitmap$0) {
                this.output = Nil$.MODULE$;
                this.bitmap$0 = true;
            }
        }
        return this.output;
    }

    public Seq<Attribute> output() {
        if (!this.bitmap$0) {
            return this.output$lzycompute();
        }
        return this.output;
    }

    public Seq<InternalRow> run() {
        ManageSnapshots manageSnapshots;
        Table table = this.catalog().loadTable(this.ident());
        if (table instanceof SparkTable) {
            BoxedUnit boxedUnit;
            boolean refExists;
            SparkTable sparkTable = (SparkTable)table;
            Long snapshotId = (Long)this.branchOptions().snapshotId().orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)sparkTable.table().currentSnapshot()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.snapshotId()))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1)).orNull(Predef$.MODULE$.$conforms());
            manageSnapshots = sparkTable.table().manageSnapshots();
            boolean bl = refExists = sparkTable.table().refs().get(this.branch()) != null;
            if (this.create() && this.replace() && !refExists) {
                this.safeCreateBranch$1(snapshotId, manageSnapshots);
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.replace()) {
                Preconditions.checkArgument((snapshotId != null ? 1 : 0) != 0, (String)"Cannot complete replace branch operation on %s, main has no snapshot", (Object[])new Object[]{this.ident()});
                boxedUnit = manageSnapshots.replaceBranch(this.branch(), Predef$.MODULE$.Long2long(snapshotId));
            } else {
                if (refExists && this.ifNotExists()) {
                    return Nil$.MODULE$;
                }
                this.safeCreateBranch$1(snapshotId, manageSnapshots);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new UnsupportedOperationException(new StringBuilder(54).append("Cannot create or replace branch on non-Iceberg table: ").append(table).toString());
        }
        Object object = this.branchOptions().numSnapshots().nonEmpty() ? manageSnapshots.setMinSnapshotsToKeep(this.branch(), (int)BoxesRunTime.unboxToLong((Object)this.branchOptions().numSnapshots().get())) : BoxedUnit.UNIT;
        Object object2 = this.branchOptions().snapshotRetain().nonEmpty() ? manageSnapshots.setMaxSnapshotAgeMs(this.branch(), BoxesRunTime.unboxToLong((Object)this.branchOptions().snapshotRetain().get())) : BoxedUnit.UNIT;
        Object object3 = this.branchOptions().snapshotRefRetain().nonEmpty() ? manageSnapshots.setMaxRefAgeMs(this.branch(), BoxesRunTime.unboxToLong((Object)this.branchOptions().snapshotRefRetain().get())) : BoxedUnit.UNIT;
        manageSnapshots.commit();
        return Nil$.MODULE$;
    }

    public String simpleString(int maxFields) {
        return new StringBuilder(36).append("CreateOrReplace branch: ").append(this.branch()).append(" for table: ").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(this.ident()).quoted()).toString();
    }

    public CreateOrReplaceBranchExec copy(TableCatalog catalog, Identifier ident, String branch, BranchOptions branchOptions, boolean create, boolean replace, boolean ifNotExists) {
        return new CreateOrReplaceBranchExec(catalog, ident, branch, branchOptions, create, replace, ifNotExists);
    }

    public TableCatalog copy$default$1() {
        return this.catalog();
    }

    public Identifier copy$default$2() {
        return this.ident();
    }

    public String copy$default$3() {
        return this.branch();
    }

    public BranchOptions copy$default$4() {
        return this.branchOptions();
    }

    public boolean copy$default$5() {
        return this.create();
    }

    public boolean copy$default$6() {
        return this.replace();
    }

    public boolean copy$default$7() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "CreateOrReplaceBranchExec";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.catalog();
            }
            case 1: {
                return this.ident();
            }
            case 2: {
                return this.branch();
            }
            case 3: {
                return this.branchOptions();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this.create());
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this.replace());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateOrReplaceBranchExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateOrReplaceBranchExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateOrReplaceBranchExec createOrReplaceBranchExec = (CreateOrReplaceBranchExec)((Object)x$1);
        TableCatalog tableCatalog = this.catalog();
        TableCatalog tableCatalog2 = createOrReplaceBranchExec.catalog();
        if (tableCatalog == null) {
            if (tableCatalog2 != null) {
                return false;
            }
        } else if (!tableCatalog.equals(tableCatalog2)) return false;
        Identifier identifier = this.ident();
        Identifier identifier2 = createOrReplaceBranchExec.ident();
        if (identifier == null) {
            if (identifier2 != null) {
                return false;
            }
        } else if (!identifier.equals(identifier2)) return false;
        String string = this.branch();
        String string2 = createOrReplaceBranchExec.branch();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        BranchOptions branchOptions = this.branchOptions();
        BranchOptions branchOptions2 = createOrReplaceBranchExec.branchOptions();
        if (branchOptions == null) {
            if (branchOptions2 != null) {
                return false;
            }
        } else if (!((Object)branchOptions).equals(branchOptions2)) return false;
        if (this.create() != createOrReplaceBranchExec.create()) return false;
        if (this.replace() != createOrReplaceBranchExec.replace()) return false;
        if (this.ifNotExists() != createOrReplaceBranchExec.ifNotExists()) return false;
        if (!createOrReplaceBranchExec.canEqual((Object)this)) return false;
        return true;
    }

    private final void safeCreateBranch$1(Long snapshotId$1, ManageSnapshots manageSnapshots$1) {
        if (snapshotId$1 == null) {
            manageSnapshots$1.createBranch(this.branch());
            return;
        }
        manageSnapshots$1.createBranch(this.branch(), Predef$.MODULE$.Long2long(snapshotId$1));
    }

    public CreateOrReplaceBranchExec(TableCatalog catalog, Identifier ident, String branch, BranchOptions branchOptions, boolean create, boolean replace, boolean ifNotExists) {
        this.catalog = catalog;
        this.ident = ident;
        this.branch = branch;
        this.branchOptions = branchOptions;
        this.create = create;
        this.replace = replace;
        this.ifNotExists = ifNotExists;
        LeafLike.$init$((LeafLike)this);
    }
}

