/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.TopicDeletionManager$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.AbstractResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0007fm\u0016tG/T1oC\u001e,'\u000f\u0005\u0002\u00179%\u0011QD\u0001\u0002\u0017\u0007>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0005{W\u000ec\u0017.\u001a8u!\t\tC%D\u0001#\u0015\t\u0019C!\u0001\u0002{W&\u0011QE\t\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\u0011I#f\u000b\u0017\u0011\u0005Y\u0001\u0001\"B\u0002'\u0001\u0004)\u0002\"\u0002\u000e'\u0001\u0004Y\u0002\"B\u0010'\u0001\u0004\u0001\u0003b\u0002\u0018\u0001\u0005\u0004%\taL\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u0019\u0011\u0005Y\t\u0014B\u0001\u001a\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0019\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003QI7\u000fR3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fIV\t\u0001\b\u0005\u0002\ns%\u0011!H\u0003\u0002\b\u0005>|G.Z1o\u0011\u0019a\u0004\u0001)A\u0005q\u0005)\u0012n\u001d#fY\u0016$X\rV8qS\u000e,e.\u00192mK\u0012\u0004\u0003b\u0002 \u0001\u0005\u0004%\taP\u0001\u0012i>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$W#\u0001!\u0011\u0007\u00053\u0005*D\u0001C\u0015\t\u0019E)A\u0004nkR\f'\r\\3\u000b\u0005\u0015S\u0011AC2pY2,7\r^5p]&\u0011qI\u0011\u0002\u0004'\u0016$\bCA%M\u001d\tI!*\u0003\u0002L\u0015\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tY%\u0002\u0003\u0004Q\u0001\u0001\u0006I\u0001Q\u0001\u0013i>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007\u0005C\u0004S\u0001\t\u0007I\u0011A*\u0002+A\f'\u000f^5uS>t7\u000fV8CK\u0012+G.\u001a;fIV\tA\u000bE\u0002B\rV\u0003\"A\u00160\u000e\u0003]S!\u0001W-\u0002\r\r|W.\\8o\u0015\t)!L\u0003\u0002\\9\u00061\u0011\r]1dQ\u0016T\u0011!X\u0001\u0004_J<\u0017BA0X\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Da!\u0019\u0001!\u0002\u0013!\u0016A\u00069beRLG/[8ogR{')\u001a#fY\u0016$X\r\u001a\u0011\t\u000f\r\u0004!\u0019!C\u0001\u007f\u0005YBo\u001c9jGNLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:Da!\u001a\u0001!\u0002\u0013\u0001\u0015\u0001\b;pa&\u001c7/\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000e\t\u0005\u0006O\u0002!\t\u0001[\u0001\u0005S:LG\u000fF\u0002jYF\u0004\"!\u00036\n\u0005-T!\u0001B+oSRDQ!\u001c4A\u00029\f\u0001$\u001b8ji&\fG\u000eV8qS\u000e\u001cHk\u001c\"f\t\u0016dW\r^3e!\ry\u0007\u000fS\u0007\u0002\t&\u0011q\t\u0012\u0005\u0006e\u001a\u0004\rA\\\u0001#S:LG/[1m)>\u0004\u0018nY:J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\t\u000bQ\u0004A\u0011A;\u0002!Q\u0014\u0018\u0010V8qS\u000e$U\r\\3uS>tG#A5\t\u000b]\u0004A\u0011A;\u0002\u000bI,7/\u001a;\t\u000be\u0004A\u0011\u0001>\u00021\u0015t\u0017/^3vKR{\u0007/[2t\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0002jw\")A\u0010\u001fa\u0001]\u00061Ao\u001c9jGNDQA \u0001\u0005\u0002}\fqC]3tk6,G)\u001a7fi&|gNR8s)>\u0004\u0018nY:\u0015\u0007%\f\t\u0001C\u0004}{B\u0005\t\u0019\u00018\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b\u0005\u0019b-Y5m%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019\u0011.!\u0003\t\u0011\u0005-\u00111\u0001a\u0001\u0003\u001b\t\u0001B]3qY&\u001c\u0017m\u001d\t\u0005_B\fy\u0001E\u0002\u0017\u0003#I1!a\u0005\u0003\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b\u0011\u001d\t9\u0002\u0001C\u0001\u00033\ta$\\1sWR{\u0007/[2J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007%\fY\u0002\u0003\u0004}\u0003+\u0001\rA\u001c\u0005\b\u0003?\u0001A\u0011BA\u0011\u0003qI7\u000fV8qS\u000eLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$2\u0001OA\u0012\u0011\u001d\t)#!\bA\u0002!\u000bQ\u0001^8qS\u000eDq!!\u000b\u0001\t\u0013\tY#A\rjgR{\u0007/[2EK2,G/[8o\u0013:\u0004&o\\4sKN\u001cHc\u0001\u001d\u0002.!9\u0011QEA\u0014\u0001\u0004A\u0005bBA\u0019\u0001\u0011\u0005\u00111G\u0001\u0017SN\u0004\u0016M\u001d;ji&|g\u000eV8CK\u0012+G.\u001a;fIR\u0019\u0001(!\u000e\t\u000f\u0005]\u0012q\u0006a\u0001+\u0006\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u0005Q\u0012n\u001d+pa&\u001c\u0017+^3vK\u0012,\u0006OR8s\t\u0016dW\r^5p]R\u0019\u0001(a\u0010\t\u000f\u0005\u0015\u0012\u0011\ba\u0001\u0011\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013aF2p[BdW\r^3SKBd\u0017nY1EK2,G/[8o)\rI\u0017q\t\u0005\t\u0003\u0017\t\t\u00051\u0001\u0002\u000e!9\u00111\n\u0001\u0005\n\u00055\u0013AG5t)>\u0004\u0018nY#mS\u001eL'\r\\3G_J$U\r\\3uS>tGc\u0001\u001d\u0002P!9\u0011QEA%\u0001\u0004A\u0005bBA*\u0001\u0011%\u0011QK\u0001\u001a[\u0006\u00148\u000eV8qS\u000e4uN\u001d#fY\u0016$\u0018n\u001c8SKR\u0014\u0018\u0010F\u0002j\u0003/Bq!!\n\u0002R\u0001\u0007\u0001\nC\u0004\u0002\\\u0001!I!!\u0018\u0002'\r|W\u000e\u001d7fi\u0016$U\r\\3uKR{\u0007/[2\u0015\u0007%\fy\u0006C\u0004\u0002&\u0005e\u0003\u0019\u0001%\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f\u0005yqN\u001c+pa&\u001cG)\u001a7fi&|g\u000eF\u0002j\u0003OBa\u0001`A1\u0001\u0004q\u0007bBA6\u0001\u0011%\u0011QN\u0001\u0015gR\f'\u000f\u001e*fa2L7-\u0019#fY\u0016$\u0018n\u001c8\u0015\u0007%\fy\u0007\u0003\u0005\u0002r\u0005%\u0004\u0019AA\u0007\u0003q\u0011X\r\u001d7jG\u0006\u001chi\u001c:U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012Dq!!\u001e\u0001\t\u0013\t9(A\np]B\u000b'\u000f^5uS>tG)\u001a7fi&|g\u000eF\u0002j\u0003sBqAUA:\u0001\u0004\tY\bE\u0002paVCa!a \u0001\t\u0013)\u0018a\u0004:fgVlW\rR3mKRLwN\\:\t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005\u0015\u0015!\t:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2tI\u0011,g-Y;mi\u0012\nTCAADU\rq\u0017\u0011R\u0016\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0013\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0006=%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    public final ControllerEventManager kafka$controller$TopicDeletionManager$$eventManager;
    private final KafkaZkClient zkClient;
    private final ControllerContext controllerContext;
    private final boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicPartition> partitionsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        if (this.isDeleteTopicEnabled()) {
            this.topicsToBeDeleted().$plus$plus$eq(initialTopicsToBeDeleted);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)this.topicsToBeDeleted().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom()));
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        } else {
            this.info((Function0<String>)new Serializable(this, initialTopicsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Set initialTopicsToBeDeleted$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " since delete topic is disabled"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initialTopicsToBeDeleted$1}));
                }
                {
                    this.initialTopicsToBeDeleted$1 = initialTopicsToBeDeleted$1;
                }
            });
            this.zkClient.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq());
        }
    }

    public void tryTopicDeletion() {
        if (this.isDeleteTopicEnabled()) {
            this.resumeDeletions();
        }
    }

    public void reset() {
        if (this.isDeleteTopicEnabled()) {
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom()));
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (this.isDeleteTopicEnabled() && (topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) {
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (this.isDeleteTopicEnabled() && (replicasThatFailedToDelete = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).nonEmpty()) {
            Set topics = (Set)replicasThatFailedToDelete.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$1) {
                    return x$1.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion failed for replicas ", ". Halting deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            });
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)new Serializable(this, newTopicsToHaltDeletion){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Halted deletion of topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                    }
                    {
                        this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                    }
                });
            }
        }
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicPartition topicAndPartition) {
        return this.isDeleteTopicEnabled() ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion successfully completed for replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeDeletions();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        scala.collection.immutable.Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)new Serializable(this, topic, failedReplicas){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final scala.collection.immutable.Set failedReplicas$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying delete topic for topic ", " since replicas ", " were not successfully deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.failedReplicas$1.mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.failedReplicas$1 = failedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.kafka$controller$TopicDeletionManager$$controller.unregisterPartitionModificationsHandlers((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        scala.collection.immutable.Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.kafka$controller$TopicDeletionManager$$controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)partitionsForDeletedTopic.toSeq(), OfflinePartition$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.partitionStateMachine().handleStateChanges$default$3());
        this.kafka$controller$TopicDeletionManager$$controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)partitionsForDeletedTopic.toSeq(), NonExistentPartition$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.partitionStateMachine().handleStateChanges$default$3());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.partitionsToBeDeleted().retain((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final boolean apply(TopicPartition x$2) {
                String string = x$2.topic();
                String string2 = this.topic$2;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.topic$2 = topic$2;
            }
        });
        this.zkClient.deleteTopicZNode(topic);
        this.zkClient.deleteTopicConfigs((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        this.zkClient.deleteTopicDeletions((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)new Serializable(this, topics){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic deletion callback for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
            }
        });
        Set partitions = (Set)topics.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicPartition> apply(String topic) {
                return this.$outer.controllerContext().partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicPartition, Seq<Object>> p) {
                return ((TopicPartition)p._1()).topic();
            }
        });
        topics.foreach((Function1)new Serializable(this, partitionReplicaAssignmentByTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Map partitionReplicaAssignmentByTopic$1;

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion((Set<TopicPartition>)((MapLike)this.partitionReplicaAssignmentByTopic$1.apply((Object)topic)).keySet());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionReplicaAssignmentByTopic$1 = partitionReplicaAssignmentByTopic$1;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PartitionAndReplica x$3) {
                return x$3.topic();
            }
        }).keys().foreach((Function1)new Serializable(this, replicasForTopicsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            public final void apply(String topic) {
                Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$3;

                    public final boolean apply(PartitionAndReplica p) {
                        String string = p.topic();
                        String string2 = this.topic$3;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.topic$3 = topic$3;
                    }
                });
                Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
                scala.collection.immutable.Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)deadReplicasForTopic.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), OfflineReplica$.MODULE$, this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
                this.$outer.debug((Function0<String>)new Serializable(this, replicasForDeletionRetry){
                    public static final long serialVersionUID = 0L;
                    private final Set replicasForDeletionRetry$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion started for replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                    }
                    {
                        this.replicasForDeletionRetry$1 = replicasForDeletionRetry$1;
                    }
                });
                this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), ReplicaDeletionStarted$.MODULE$, new Callbacks((Function2<AbstractResponse, Object, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$startReplicaDeletion$2 $outer;

                    public final void apply(AbstractResponse stopReplicaResponseObj, int replicaId) {
                        this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$eventManager.put(new KafkaController.TopicDeletionStopReplicaResponseReceived(this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$controller, stopReplicaResponseObj, replicaId));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                if (deadReplicasForTopic.nonEmpty()) {
                    this.$outer.debug((Function0<String>)new Serializable(this, deadReplicasForTopic, topic){
                        public static final long serialVersionUID = 0L;
                        private final Set deadReplicasForTopic$1;
                        private final String topic$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dead Replicas (", ") found for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deadReplicasForTopic$1.mkString(","), this.topic$3}));
                        }
                        {
                            this.deadReplicasForTopic$1 = deadReplicasForTopic$1;
                            this.topic$3 = topic$3;
                        }
                    });
                    this.$outer.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                }
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = replicasForTopicsToBeDeleted$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)new Serializable(this, partitionsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Set partitionsToBeDeleted$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition deletion callback for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = partitionsToBeDeleted$1;
            }
        });
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)new Serializable(this, topicsQueuedForDeletion){
                public static final long serialVersionUID = 0L;
                private final Set topicsQueuedForDeletion$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Handling deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicsQueuedForDeletion$1.mkString(",")}));
                }
                {
                    this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                }
            });
        }
        topicsQueuedForDeletion.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply(String topic) {
                if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " successfully completed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                    scala.collection.immutable.Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                    scala.collection.immutable.Set replicaIds = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(PartitionAndReplica x$4) {
                            return x$4.replica();
                        }
                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final TopicPartition apply(PartitionAndReplica x$5) {
                            return x$5.topicPartition();
                        }
                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    this.$outer.info((Function0<String>)new Serializable(this, replicaIds, partitions, topic){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.immutable.Set replicaIds$1;
                        private final scala.collection.immutable.Set partitions$1;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion for replicas ", " for partition ", " of topic ", " in progress"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$4}));
                        }
                        {
                            this.replicaIds$1 = replicaIds$1;
                            this.partitions$1 = partitions$1;
                            this.topic$4 = topic$4;
                        }
                    });
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                }
                if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " (re)started"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                    this.$outer.kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                } else if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicIneligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not retrying deletion of topic ", " at this time since it is marked ineligible for deletion"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public TopicDeletionManager(KafkaController controller, ControllerEventManager eventManager, KafkaZkClient zkClient) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        this.kafka$controller$TopicDeletionManager$$eventManager = eventManager;
        this.zkClient = zkClient;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Topic Deletion Manager ", "], "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controller.config().brokerId())})));
        this.controllerContext = controller.controllerContext();
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.partitionsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
    }
}

