/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.StateChangeLogMerger;
import kafka.tools.StateChangeLogMerger$dateBasedOrdering$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.PriorityQueue;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class StateChangeLogMerger$
implements Logging {
    public static StateChangeLogMerger$ MODULE$;
    private final String dateFormatString;
    private final Regex topicPartitionRegex;
    private final Regex dateRegex;
    private final SimpleDateFormat dateFormat;
    private List<String> files;
    private String topic;
    private List<Object> partitions;
    private Date startDate;
    private Date endDate;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new StateChangeLogMerger$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public Regex topicPartitionRegex() {
        return this.topicPartitionRegex;
    }

    public Regex dateRegex() {
        return this.dateRegex;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public List<String> files() {
        return this.files;
    }

    public void files_$eq(List<String> x$1) {
        this.files = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String x$1) {
        this.topic = x$1;
    }

    public List<Object> partitions() {
        return this.partitions;
    }

    public void partitions_$eq(List<Object> x$1) {
        this.partitions = x$1;
    }

    public Date startDate() {
        return this.startDate;
    }

    public void startDate_$eq(Date x$1) {
        this.startDate = x$1;
    }

    public Date endDate() {
        return this.endDate;
    }

    public void endDate_$eq(Date x$1) {
        this.endDate = x$1;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("logs", "Comma separated list of state change logs or a regex for the log file names").withRequiredArg().describedAs("file1,file2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec regexOpt = parser.accepts("logs-regex", "Regex to match the state change log files to be merged").withRequiredArg().describedAs("for example: /tmp/state-change.log*").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "The topic whose state change logs should be merged").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionsOpt = parser.accepts("partitions", "Comma separated list of partition ids whose state change logs should be merged").withRequiredArg().describedAs("0,1,2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec startTimeOpt = parser.accepts("start-time", "The earliest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder(30).append("start timestamp in the format ").append(this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"0000-00-00 00:00:00,000", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec endTimeOpt = parser.accepts("end-time", "The latest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder(28).append("end timestamp in the format ").append(this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"9999-12-31 23:59:59,999", (Object[])new String[0]);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).isEmpty()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "A tool for merging the log files from several brokers to reconnstruct a unified history of what happened.");
        }
        OptionSet options = parser.parse(args);
        if (!options.has((OptionSpec)filesOpt) && !options.has((OptionSpec)regexOpt) || options.has((OptionSpec)filesOpt) && options.has((OptionSpec)regexOpt)) {
            System.err.println(new StringBuilder(60).append("Provide arguments to exactly one of the two options \"").append(filesOpt).append("\" or \"").append(regexOpt).append("\"").toString());
            parser.printHelpOn((OutputStream)System.err);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (options.has((OptionSpec)partitionsOpt) && !options.has((OptionSpec)topicOpt)) {
            System.err.println(new StringBuilder(76).append("The option \"").append(topicOpt).append("\" needs to be provided an argument when specifying partition ids").toString());
            parser.printHelpOn((OutputStream)System.err);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        if (options.has((OptionSpec)filesOpt)) {
            this.files_$eq((List<String>)this.files().$colon$colon$colon(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)options.valueOf((OptionSpec)filesOpt)).split(","))).toList()));
        } else if (options.has((OptionSpec)regexOpt)) {
            String regex = (String)options.valueOf((OptionSpec)regexOpt);
            int fileNameIndex = regex.lastIndexOf(47) + 1;
            String dirName = fileNameIndex == 0 ? "." : regex.substring(0, fileNameIndex - 1);
            Regex fileNameRegex = new Regex(regex.substring(fileNameIndex), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.files_$eq((List<String>)this.files().$colon$colon$colon(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(dirName).listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)StateChangeLogMerger$.$anonfun$main$1(fileNameRegex, f))))).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append(dirName).append("/").append(x$1.getName()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList()));
        }
        if (options.has((OptionSpec)topicOpt)) {
            this.topic_$eq((String)options.valueOf((OptionSpec)topicOpt));
        }
        if (options.has((OptionSpec)partitionsOpt)) {
            this.partitions_$eq((List<Object>)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)options.valueOf((OptionSpec)partitionsOpt)).split(","))).toList().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StateChangeLogMerger$.$anonfun$main$3(x$2)), List$.MODULE$.canBuildFrom())));
            Iterable<Object> duplicatePartitions = CoreUtils$.MODULE$.duplicates(this.partitions());
            if (duplicatePartitions.nonEmpty()) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("The list of partitions contains repeated entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
        }
        this.startDate_$eq(this.dateFormat().parse(((String)options.valueOf((OptionSpec)startTimeOpt)).replace('\"', ' ').trim()));
        this.endDate_$eq(this.dateFormat().parse(((String)options.valueOf((OptionSpec)endTimeOpt)).replace('\"', ' ').trim()));
        PriorityQueue pqueue = new PriorityQueue((Ordering)StateChangeLogMerger$dateBasedOrdering$.MODULE$);
        BufferedOutputStream output = new BufferedOutputStream(System.out, 0x100000);
        List lineIterators = (List)this.files().map((Function1 & Serializable & scala.Serializable)x$3 -> Source$.MODULE$.fromFile(x$3, Codec$.MODULE$.fallbackSystemCodec()).getLines(), List$.MODULE$.canBuildFrom());
        ObjectRef lines = ObjectRef.create((Object)Nil$.MODULE$);
        lineIterators.foreach((Function1 & Serializable & scala.Serializable)itr -> {
            StateChangeLogMerger$.$anonfun$main$5(lines, itr);
            return BoxedUnit.UNIT;
        });
        if (((List)lines.elem).nonEmpty()) {
            pqueue.enqueue((Seq)((List)lines.elem));
        }
        while (pqueue.nonEmpty()) {
            StateChangeLogMerger.LineIterator lineItr = (StateChangeLogMerger.LineIterator)pqueue.dequeue();
            ((OutputStream)output).write(new StringBuilder(1).append(lineItr.line()).append("\n").toString().getBytes(StandardCharsets.UTF_8));
            StateChangeLogMerger.LineIterator nextLineItr = this.getNextLine(lineItr.itr());
            if (nextLineItr.isEmpty()) continue;
            pqueue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StateChangeLogMerger.LineIterator[]{nextLineItr}));
        }
        ((OutputStream)output).flush();
    }

    public StateChangeLogMerger.LineIterator getNextLine(Iterator<String> itr) {
        Object object = new Object();
        try {
            while (itr != null && itr.hasNext()) {
                String nextLine = (String)itr.next();
                this.dateRegex().findFirstIn((CharSequence)nextLine).foreach((Function1 & Serializable & scala.Serializable)d -> {
                    StateChangeLogMerger$.$anonfun$getNextLine$1(nextLine, object, itr, d);
                    return BoxedUnit.UNIT;
                });
            }
            return new StateChangeLogMerger.LineIterator();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (StateChangeLogMerger.LineIterator)ex.value();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ boolean $anonfun$main$1(Regex fileNameRegex$1, File f) {
        return fileNameRegex$1.findFirstIn((CharSequence)f.getName()).isDefined();
    }

    public static final /* synthetic */ int $anonfun$main$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ void $anonfun$main$5(ObjectRef lines$1, Iterator itr) {
        StateChangeLogMerger.LineIterator lineItr = MODULE$.getNextLine((Iterator<String>)itr);
        if (!lineItr.isEmpty()) {
            lines$1.elem = ((List)lines$1.elem).$colon$colon((Object)lineItr);
        }
    }

    public static final /* synthetic */ void $anonfun$getNextLine$2(Object nonLocalReturnKey1$1, String nextLine$1, Iterator itr$1, Regex.Match matcher) {
        block8: {
            block6: {
                String string;
                String string2;
                block7: {
                    if (MODULE$.topic() == null) break block6;
                    string2 = MODULE$.topic();
                    string = matcher.group(1);
                    if (string2 != null) break block7;
                    if (string != null) {
                        return;
                    }
                    break block6;
                }
                if (!string2.equals(string)) break block8;
            }
            if (MODULE$.partitions().isEmpty() || MODULE$.partitions().contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(matcher.group(3))).toInt()))) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new StateChangeLogMerger.LineIterator(nextLine$1, (Iterator<String>)itr$1));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getNextLine$1(String nextLine$1, Object nonLocalReturnKey1$1, Iterator itr$1, String d) {
        Date date = MODULE$.dateFormat().parse(d);
        if ((date.equals(MODULE$.startDate()) || date.after(MODULE$.startDate())) && (date.equals(MODULE$.endDate()) || date.before(MODULE$.endDate()))) {
            MODULE$.topicPartitionRegex().findFirstMatchIn((CharSequence)nextLine$1).foreach((Function1 & Serializable & scala.Serializable)matcher -> {
                StateChangeLogMerger$.$anonfun$getNextLine$2(nonLocalReturnKey1$1, nextLine$1, itr$1, matcher);
                return BoxedUnit.UNIT;
            });
        }
    }

    private StateChangeLogMerger$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.topicPartitionRegex = new Regex("\\[([a-zA-Z0-9._-]+),( )*([0-9]+)\\]", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateRegex = new Regex("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
        this.files = Nil$.MODULE$;
        this.partitions = Nil$.MODULE$;
    }
}

