/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client.internals;

import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import org.apache.kudu.client.internals.ReflectiveStrategy;
import org.apache.kudu.client.internals.SecurityManagerCompatibility;

class ModernStrategy
implements SecurityManagerCompatibility {
    private final Method current;
    private final Method callAs;

    ModernStrategy(ReflectiveStrategy.Loader loader) throws NoSuchMethodException, ClassNotFoundException {
        Class<?> subject = loader.loadClass(Subject.class.getName());
        this.current = subject.getDeclaredMethod("current", new Class[0]);
        this.callAs = subject.getDeclaredMethod("callAs", Subject.class, Callable.class);
    }

    @Override
    public <T> T doPrivileged(PrivilegedAction<T> action) {
        return action.run();
    }

    @Override
    public Subject current() {
        return (Subject)ReflectiveStrategy.invoke(this.current, null, new Object[0]);
    }

    @Override
    public <T> T callAs(Subject subject, Callable<T> action) throws CompletionException {
        return (T)ReflectiveStrategy.invokeChecked(this.callAs, CompletionException.class, null, subject, action);
    }
}

