/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Collection;
import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.CreateTableResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class CreateTableRequest
extends KuduRpc<CreateTableResponse> {
    static final String CREATE_TABLE = "CreateTable";
    private final Schema schema;
    private final String name;
    private final Master.CreateTableRequestPB.Builder builder;
    private final List<Integer> featureFlags;

    CreateTableRequest(KuduTable masterTable, String name, Schema schema2, CreateTableOptions builder) {
        super(masterTable);
        this.schema = schema2;
        this.name = name;
        this.builder = builder.getBuilder();
        this.featureFlags = builder.getRequiredFeatureFlags();
    }

    @Override
    Message createRequestPB() {
        this.builder.setName(this.name);
        this.builder.setSchema(ProtobufHelper.schemaToPb(this.schema));
        return this.builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return CREATE_TABLE;
    }

    @Override
    Pair<CreateTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.CreateTableResponsePB.Builder builder = Master.CreateTableResponsePB.newBuilder();
        CreateTableRequest.readProtobuf(callResponse.getPBMessage(), builder);
        CreateTableResponse response = new CreateTableResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, builder.getTableId().toStringUtf8());
        return new Pair<CreateTableResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return this.featureFlags;
    }
}

