/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.cli.MavenCli;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.slf4j.Logger;

public final class CLIReportingUtils {
    public static final long MB = 0x100000L;
    public static final int MS_PER_SEC = 1000;
    public static final int SEC_PER_MIN = 60;
    public static final String BUILD_VERSION_PROPERTY = "version";

    public static String showVersion() {
        String LS = System.getProperty("line.separator");
        Properties properties = CLIReportingUtils.getBuildProperties();
        StringBuffer version = new StringBuffer();
        version.append(CLIReportingUtils.createMavenVersionString(properties)).append(LS);
        version.append(CLIReportingUtils.reduce(properties.getProperty("distributionShortName") + " home: " + System.getProperty("maven.home", "<unknown maven home>"))).append(LS);
        version.append("Java version: " + System.getProperty("java.version", "<unknown java version>") + ", vendor: " + System.getProperty("java.vendor", "<unknown vendor>")).append(LS);
        version.append("Java home: " + System.getProperty("java.home", "<unknown java home>")).append(LS);
        version.append("Default locale: " + Locale.getDefault() + ", platform encoding: " + System.getProperty("file.encoding", "<unknown encoding>")).append(LS);
        version.append("OS name: \"" + Os.OS_NAME + "\", version: \"" + Os.OS_VERSION + "\", arch: \"" + Os.OS_ARCH + "\", family: \"" + Os.OS_FAMILY + "\"");
        return version.toString();
    }

    static String createMavenVersionString(Properties buildProperties) {
        String timestamp = CLIReportingUtils.reduce(buildProperties.getProperty("timestamp"));
        String version = CLIReportingUtils.reduce(buildProperties.getProperty(BUILD_VERSION_PROPERTY));
        String rev = CLIReportingUtils.reduce(buildProperties.getProperty("buildNumber"));
        String distributionName = CLIReportingUtils.reduce(buildProperties.getProperty("distributionName"));
        String msg = distributionName + " ";
        msg = msg + (version != null ? version : "<version unknown>");
        if (rev != null || timestamp != null) {
            msg = msg + " (";
            msg = msg + (rev != null ? rev : "");
            if (timestamp != null) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
                String ts = fmt.format(new Date(Long.valueOf(timestamp)));
                msg = msg + (rev != null ? "; " : "") + ts;
            }
            msg = msg + ")";
        }
        return msg;
    }

    private static String reduce(String s) {
        return s != null ? (s.startsWith("${") && s.endsWith("}") ? null : s) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getBuildProperties() {
        Properties properties = new Properties();
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = MavenCli.class.getResourceAsStream("/org/apache/maven/messages/build.properties");
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
        finally {
            IOUtil.close((InputStream)resourceAsStream);
        }
        return properties;
    }

    public static void showError(Logger logger, String message, Throwable e, boolean showStackTrace) {
        if (showStackTrace) {
            logger.error(message, e);
        } else {
            logger.error(message);
            if (e != null) {
                logger.error(e.getMessage());
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    logger.error("Caused by: " + cause.getMessage());
                }
            }
        }
    }
}

