/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter
    protected String goalPrefix;
    @Parameter(defaultValue="false", property="maven.plugin.skip")
    private boolean skip;
    @Parameter
    private List<String> packagingTypes = Collections.singletonList("maven-plugin");
    protected static final String LS = System.lineSeparator();

    protected abstract void generate() throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        if (!this.packagingTypes.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Unsupported packaging type " + this.project.getPackaging() + ", execution skipped"));
            return;
        }
        if (this.skip) {
            this.getLog().warn((CharSequence)"Execution skipped");
            return;
        }
        if (this.goalPrefix == null || this.goalPrefix.isEmpty()) {
            this.goalPrefix = AbstractGeneratorMojo.getDefaultGoalPrefix(this.project);
        }
        if (this.goalPrefix == null || this.goalPrefix.isEmpty()) {
            throw new MojoExecutionException("You need to specify a goalPrefix as it can not be correctly computed");
        }
        this.generate();
    }

    static String getDefaultGoalPrefix(MavenProject project) {
        String artifactId = project.getArtifactId();
        if (artifactId.endsWith("-maven-plugin")) {
            return artifactId.substring(0, artifactId.length() - "-maven-plugin".length());
        }
        if (artifactId.startsWith("maven-") && artifactId.endsWith("-plugin")) {
            return artifactId.substring("maven-".length(), artifactId.length() - "-plugin".length());
        }
        return null;
    }
}

