/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.metadata;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.metadata.LegacySupport;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionScheme;

@Mojo(name="addPluginArtifactMetadata", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class AddPluginArtifactMetadataMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter
    private String goalPrefix;
    @Parameter(defaultValue="false", property="maven.plugin.skip")
    private boolean skip;
    @Component
    private RuntimeInformation runtimeInformation;
    private final VersionScheme versionScheme = new GenericVersionScheme();

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().warn((CharSequence)"Execution skipped");
            return;
        }
        try {
            if (this.versionScheme.parseVersion("3.9.0").compareTo((Object)this.versionScheme.parseVersion(this.runtimeInformation.getMavenVersion())) < 1) {
                this.getLog().info((CharSequence)"This Mojo is not used in Maven version 3.9.0 and above");
                return;
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        LegacySupport.execute(this.project, this.getGoalPrefix());
    }

    private String getGoalPrefix() {
        if (this.goalPrefix == null) {
            this.goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        }
        return this.goalPrefix;
    }
}

