/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.report.ConsoleOutputFileReporter;
import org.apache.maven.plugin.surefire.report.DirectConsoleOutput;
import org.apache.maven.plugin.surefire.report.FileReporter;
import org.apache.maven.plugin.surefire.report.StatelessXmlReporter;
import org.apache.maven.plugin.surefire.report.TestcycleConsoleOutputReceiver;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;

public final class StartupReportConfiguration {
    public static final String BRIEF_REPORT_FORMAT = "brief";
    public static final String PLAIN_REPORT_FORMAT = "plain";
    private final PrintStream originalSystemOut;
    private final PrintStream originalSystemErr;
    private final boolean useFile;
    private final boolean printSummary;
    private final String reportFormat;
    private final String reportNameSuffix;
    private final File statisticsFile;
    private final boolean requiresRunHistory;
    private final boolean redirectTestOutputToFile;
    private final boolean disableXmlReport;
    private final File reportsDirectory;
    private final boolean trimStackTrace;
    private final int rerunFailingTestsCount;
    private final String xsdSchemaLocation;
    private final Properties testVmSystemProperties = new Properties();
    private final Map<String, Map<String, List<WrappedReportEntry>>> testClassMethodRunHistory = new ConcurrentHashMap<String, Map<String, List<WrappedReportEntry>>>();
    private StatisticsReporter statisticsReporter;

    public StartupReportConfiguration(boolean useFile, boolean printSummary, String reportFormat, boolean redirectTestOutputToFile, boolean disableXmlReport, @Nonnull File reportsDirectory, boolean trimStackTrace, String reportNameSuffix, File statisticsFile, boolean requiresRunHistory, int rerunFailingTestsCount, String xsdSchemaLocation) {
        this.useFile = useFile;
        this.printSummary = printSummary;
        this.reportFormat = reportFormat;
        this.redirectTestOutputToFile = redirectTestOutputToFile;
        this.disableXmlReport = disableXmlReport;
        this.reportsDirectory = reportsDirectory;
        this.trimStackTrace = trimStackTrace;
        this.reportNameSuffix = reportNameSuffix;
        this.statisticsFile = statisticsFile;
        this.requiresRunHistory = requiresRunHistory;
        this.originalSystemOut = System.out;
        this.originalSystemErr = System.err;
        this.rerunFailingTestsCount = rerunFailingTestsCount;
        this.xsdSchemaLocation = xsdSchemaLocation;
    }

    public static StartupReportConfiguration defaultValue() {
        File target = new File("./target");
        File statisticsFile = new File(target, "TESTHASH");
        return new StartupReportConfiguration(true, true, "PLAIN", false, false, target, false, null, statisticsFile, false, 0, null);
    }

    public static StartupReportConfiguration defaultNoXml() {
        File target = new File("./target");
        File statisticsFile = new File(target, "TESTHASHxXML");
        return new StartupReportConfiguration(true, true, "PLAIN", false, true, target, false, null, statisticsFile, false, 0, null);
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public String getReportNameSuffix() {
        return this.reportNameSuffix;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public boolean isDisableXmlReport() {
        return this.disableXmlReport;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    public StatelessXmlReporter instantiateStatelessXmlReporter() {
        return this.isDisableXmlReport() ? null : new StatelessXmlReporter(this.reportsDirectory, this.reportNameSuffix, this.trimStackTrace, this.rerunFailingTestsCount, this.testClassMethodRunHistory, this.xsdSchemaLocation);
    }

    public FileReporter instantiateFileReporter() {
        return this.isUseFile() && this.isBriefOrPlainFormat() ? new FileReporter(this.reportsDirectory, this.getReportNameSuffix()) : null;
    }

    public boolean isBriefOrPlainFormat() {
        String fmt = this.getReportFormat();
        return BRIEF_REPORT_FORMAT.equals(fmt) || PLAIN_REPORT_FORMAT.equals(fmt);
    }

    public TestcycleConsoleOutputReceiver instantiateConsoleOutputFileReporter() {
        return this.isRedirectTestOutputToFile() ? new ConsoleOutputFileReporter(this.reportsDirectory, this.getReportNameSuffix()) : new DirectConsoleOutput(this.originalSystemOut, this.originalSystemErr);
    }

    public synchronized StatisticsReporter getStatisticsReporter() {
        if (this.statisticsReporter == null) {
            this.statisticsReporter = this.requiresRunHistory ? new StatisticsReporter(this.getStatisticsFile()) : null;
        }
        return this.statisticsReporter;
    }

    public File getStatisticsFile() {
        return this.statisticsFile;
    }

    public Properties getTestVmSystemProperties() {
        return this.testVmSystemProperties;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public boolean isRequiresRunHistory() {
        return this.requiresRunHistory;
    }

    public PrintStream getOriginalSystemOut() {
        return this.originalSystemOut;
    }

    public String getXsdSchemaLocation() {
        return this.xsdSchemaLocation;
    }
}

