/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.tools.maven;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Entity;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.MappingTool;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.meta.ClassArgParser;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.tools.maven.AbstractOpenJpaMojo;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractOpenJpaMappingToolMojo
extends AbstractOpenJpaMojo {
    @Parameter
    protected String action;
    protected static final String OPTION_ACTION = "action";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipMojo()) {
            return;
        }
        if (!this.getEntityClasses().exists()) {
            FileUtils.mkdir((String)this.getEntityClasses().getAbsolutePath());
        }
        List<File> entities = this.findEntityClassFiles();
        this.mappingTool(entities);
    }

    private void mappingTool(List<File> files) throws MojoExecutionException {
        this.extendRealmClasspath();
        Options opts = this.getOptions();
        this.filterPersistenceCapable(files, opts);
        final String[] args = this.getFilePaths(files);
        boolean ok = Configurations.runAgainstAllAnchors((Options)opts, (Configurations.Runnable)new Configurations.Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(Options opts) throws IOException, SQLException {
                try (JDBCConfigurationImpl conf = new JDBCConfigurationImpl();){
                    boolean bl = MappingTool.run((JDBCConfiguration)conf, (String[])args, (Options)opts, (ClassLoader)Thread.currentThread().getContextClassLoader());
                    return bl;
                }
            }
        });
        if (!ok) {
            throw new MojoExecutionException("The OpenJPA MappingTool detected an error!");
        }
    }

    private void filterPersistenceCapable(List<File> files, Options opts) {
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
        Configurations.populateConfiguration((Configuration)conf, (Options)opts);
        MetaDataRepository repo = conf.newMetaDataRepositoryInstance();
        ClassArgParser cap = repo.getMetaDataFactory().newClassArgParser();
        Iterator<File> fileIt = files.iterator();
        while (fileIt.hasNext()) {
            File classPath = fileIt.next();
            Class[] classes = cap.parseTypes(classPath.getAbsolutePath());
            if (classes == null) {
                this.getLog().info((CharSequence)("Found no classes for " + classPath.getAbsolutePath()));
                continue;
            }
            for (Class cls : classes) {
                if (cls.getAnnotation(Entity.class) != null) {
                    this.getLog().debug((CharSequence)("Found @Entity in class " + classPath));
                    continue;
                }
                if (this.implementsPersistenceCapable(cls)) {
                    this.getLog().debug((CharSequence)("Found class " + classPath + " that implements interface " + PersistenceCapable.class.getName()));
                    continue;
                }
                this.getLog().debug((CharSequence)("Removing non-entity class " + classPath));
                fileIt.remove();
            }
        }
    }

    private boolean implementsPersistenceCapable(Class<?> cls) {
        Class<?>[] interfaces;
        boolean isPersistenceCapable = false;
        for (Class<?> anInterface : interfaces = cls.getInterfaces()) {
            if (!anInterface.getName().equals(PersistenceCapable.class.getName())) continue;
            isPersistenceCapable = true;
            break;
        }
        return isPersistenceCapable;
    }
}

