/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DataChangeNotification
extends ExtensionObjectDefinition
implements Message {
    protected final int noOfMonitoredItems;
    protected final List<ExtensionObjectDefinition> monitoredItems;
    protected final int noOfDiagnosticInfos;
    protected final List<DiagnosticInfo> diagnosticInfos;

    @Override
    public String getIdentifier() {
        return "811";
    }

    public DataChangeNotification(int noOfMonitoredItems, List<ExtensionObjectDefinition> monitoredItems, int noOfDiagnosticInfos, List<DiagnosticInfo> diagnosticInfos) {
        this.noOfMonitoredItems = noOfMonitoredItems;
        this.monitoredItems = monitoredItems;
        this.noOfDiagnosticInfos = noOfDiagnosticInfos;
        this.diagnosticInfos = diagnosticInfos;
    }

    public int getNoOfMonitoredItems() {
        return this.noOfMonitoredItems;
    }

    public List<ExtensionObjectDefinition> getMonitoredItems() {
        return this.monitoredItems;
    }

    public int getNoOfDiagnosticInfos() {
        return this.noOfDiagnosticInfos;
    }

    public List<DiagnosticInfo> getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("DataChangeNotification", new WithWriterArgs[0]);
        int notificationLength = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"notificationLength", (Object)notificationLength, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfMonitoredItems", (Object)this.noOfMonitoredItems, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"monitoredItems", this.monitoredItems, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfDiagnosticInfos", (Object)this.noOfDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"diagnosticInfos", this.diagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DataChangeNotification", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        boolean last;
        int i;
        int lengthInBits = super.getLengthInBits();
        DataChangeNotification _value = this;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.monitoredItems != null) {
            i = 0;
            for (ExtensionObjectDefinition extensionObjectDefinition : this.monitoredItems) {
                last = ++i >= this.monitoredItems.size();
                lengthInBits += extensionObjectDefinition.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.diagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.diagnosticInfos) {
                last = ++i >= this.diagnosticInfos.size();
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static DataChangeNotificationBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("DataChangeNotification", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int notificationLength = (Integer)FieldReaderFactory.readImplicitField((String)"notificationLength", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfMonitoredItems = (Integer)FieldReaderFactory.readSimpleField((String)"noOfMonitoredItems", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List monitoredItems = FieldReaderFactory.readCountArrayField((String)"monitoredItems", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "808"), readBuffer), (long)noOfMonitoredItems, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDiagnosticInfos = (Integer)FieldReaderFactory.readSimpleField((String)"noOfDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List diagnosticInfos = FieldReaderFactory.readCountArrayField((String)"diagnosticInfos", (DataReader)new DataReaderComplexDefault(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer), (long)noOfDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DataChangeNotification", new WithReaderArgs[0]);
        return new DataChangeNotificationBuilder(noOfMonitoredItems, monitoredItems, noOfDiagnosticInfos, diagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataChangeNotification)) {
            return false;
        }
        DataChangeNotification that = (DataChangeNotification)o;
        return this.getNoOfMonitoredItems() == that.getNoOfMonitoredItems() && this.getMonitoredItems() == that.getMonitoredItems() && this.getNoOfDiagnosticInfos() == that.getNoOfDiagnosticInfos() && this.getDiagnosticInfos() == that.getDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoOfMonitoredItems(), this.getMonitoredItems(), this.getNoOfDiagnosticInfos(), this.getDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DataChangeNotificationBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final int noOfMonitoredItems;
        private final List<ExtensionObjectDefinition> monitoredItems;
        private final int noOfDiagnosticInfos;
        private final List<DiagnosticInfo> diagnosticInfos;

        public DataChangeNotificationBuilder(int noOfMonitoredItems, List<ExtensionObjectDefinition> monitoredItems, int noOfDiagnosticInfos, List<DiagnosticInfo> diagnosticInfos) {
            this.noOfMonitoredItems = noOfMonitoredItems;
            this.monitoredItems = monitoredItems;
            this.noOfDiagnosticInfos = noOfDiagnosticInfos;
            this.diagnosticInfos = diagnosticInfos;
        }

        @Override
        public DataChangeNotification build() {
            DataChangeNotification dataChangeNotification = new DataChangeNotification(this.noOfMonitoredItems, this.monitoredItems, this.noOfDiagnosticInfos, this.diagnosticInfos);
            return dataChangeNotification;
        }
    }
}

