/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NetworkGroupDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString serverUri;
    protected final int noOfNetworkPaths;
    protected final List<ExtensionObjectDefinition> networkPaths;

    @Override
    public String getIdentifier() {
        return "11946";
    }

    public NetworkGroupDataType(PascalString serverUri, int noOfNetworkPaths, List<ExtensionObjectDefinition> networkPaths) {
        this.serverUri = serverUri;
        this.noOfNetworkPaths = noOfNetworkPaths;
        this.networkPaths = networkPaths;
    }

    public PascalString getServerUri() {
        return this.serverUri;
    }

    public int getNoOfNetworkPaths() {
        return this.noOfNetworkPaths;
    }

    public List<ExtensionObjectDefinition> getNetworkPaths() {
        return this.networkPaths;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("NetworkGroupDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serverUri", (Object)this.serverUri, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfNetworkPaths", (Object)this.noOfNetworkPaths, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"networkPaths", this.networkPaths, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NetworkGroupDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NetworkGroupDataType _value = this;
        lengthInBits += this.serverUri.getLengthInBits();
        lengthInBits += 32;
        if (this.networkPaths != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.networkPaths) {
                boolean last = ++i >= this.networkPaths.size();
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static NetworkGroupDataTypeBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("NetworkGroupDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        PascalString serverUri = (PascalString)FieldReaderFactory.readSimpleField((String)"serverUri", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNetworkPaths = (Integer)FieldReaderFactory.readSimpleField((String)"noOfNetworkPaths", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List networkPaths = FieldReaderFactory.readCountArrayField((String)"networkPaths", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "11945"), readBuffer), (long)noOfNetworkPaths, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("NetworkGroupDataType", new WithReaderArgs[0]);
        return new NetworkGroupDataTypeBuilder(serverUri, noOfNetworkPaths, networkPaths);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkGroupDataType)) {
            return false;
        }
        NetworkGroupDataType that = (NetworkGroupDataType)o;
        return this.getServerUri() == that.getServerUri() && this.getNoOfNetworkPaths() == that.getNoOfNetworkPaths() && this.getNetworkPaths() == that.getNetworkPaths() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getServerUri(), this.getNoOfNetworkPaths(), this.getNetworkPaths());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NetworkGroupDataTypeBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString serverUri;
        private final int noOfNetworkPaths;
        private final List<ExtensionObjectDefinition> networkPaths;

        public NetworkGroupDataTypeBuilder(PascalString serverUri, int noOfNetworkPaths, List<ExtensionObjectDefinition> networkPaths) {
            this.serverUri = serverUri;
            this.noOfNetworkPaths = noOfNetworkPaths;
            this.networkPaths = networkPaths;
        }

        @Override
        public NetworkGroupDataType build() {
            NetworkGroupDataType networkGroupDataType = new NetworkGroupDataType(this.serverUri, this.noOfNetworkPaths, this.networkPaths);
            return networkGroupDataType;
        }
    }
}

