/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.NodeIdType;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTypeDefinition;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NodeIdGuid
extends NodeIdTypeDefinition
implements Message {
    protected final int namespaceIndex;
    protected final byte[] id;

    @Override
    public NodeIdType getNodeType() {
        return NodeIdType.nodeIdTypeGuid;
    }

    public NodeIdGuid(int namespaceIndex, byte[] id) {
        this.namespaceIndex = namespaceIndex;
        this.id = id;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public byte[] getId() {
        return this.id;
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.getId());
    }

    @Override
    protected void serializeNodeIdTypeDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("NodeIdGuid", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"namespaceIndex", (Object)this.namespaceIndex, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"id", (byte[])this.id, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        String identifier = this.getIdentifier();
        writeBuffer.writeVirtual("identifier", (Object)identifier, new WithWriterArgs[0]);
        writeBuffer.popContext("NodeIdGuid", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NodeIdGuid _value = this;
        lengthInBits += 16;
        if (this.id != null) {
            lengthInBits += 8 * this.id.length;
        }
        return lengthInBits;
    }

    public static NodeIdGuidBuilder staticParseBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("NodeIdGuid", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int namespaceIndex = (Integer)FieldReaderFactory.readSimpleField((String)"namespaceIndex", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] id = readBuffer.readByteArray("id", Math.toIntExact(16L), new WithReaderArgs[0]);
        String identifier = (String)FieldReaderFactory.readVirtualField((String)"identifier", String.class, (Object)id, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("NodeIdGuid", new WithReaderArgs[0]);
        return new NodeIdGuidBuilder(namespaceIndex, id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeIdGuid)) {
            return false;
        }
        NodeIdGuid that = (NodeIdGuid)o;
        return this.getNamespaceIndex() == that.getNamespaceIndex() && this.getId() == that.getId() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNamespaceIndex(), this.getId());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NodeIdGuidBuilder
    implements NodeIdTypeDefinition.NodeIdTypeDefinitionBuilder {
        private final int namespaceIndex;
        private final byte[] id;

        public NodeIdGuidBuilder(int namespaceIndex, byte[] id) {
            this.namespaceIndex = namespaceIndex;
            this.id = id;
        }

        @Override
        public NodeIdGuid build() {
            NodeIdGuid nodeIdGuid = new NodeIdGuid(this.namespaceIndex, this.id);
            return nodeIdGuid;
        }
    }
}

