/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NotificationMessage
extends ExtensionObjectDefinition
implements Message {
    protected final long sequenceNumber;
    protected final long publishTime;
    protected final int noOfNotificationData;
    protected final List<ExtensionObject> notificationData;

    @Override
    public String getIdentifier() {
        return "805";
    }

    public NotificationMessage(long sequenceNumber, long publishTime, int noOfNotificationData, List<ExtensionObject> notificationData) {
        this.sequenceNumber = sequenceNumber;
        this.publishTime = publishTime;
        this.noOfNotificationData = noOfNotificationData;
        this.notificationData = notificationData;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getPublishTime() {
        return this.publishTime;
    }

    public int getNoOfNotificationData() {
        return this.noOfNotificationData;
    }

    public List<ExtensionObject> getNotificationData() {
        return this.notificationData;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("NotificationMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sequenceNumber", (Object)this.sequenceNumber, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"publishTime", (Object)this.publishTime, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfNotificationData", (Object)this.noOfNotificationData, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"notificationData", this.notificationData, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NotificationMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NotificationMessage _value = this;
        lengthInBits += 32;
        lengthInBits += 64;
        lengthInBits += 32;
        if (this.notificationData != null) {
            int i = 0;
            for (ExtensionObject element : this.notificationData) {
                boolean last = ++i >= this.notificationData.size();
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static NotificationMessageBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("NotificationMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        long sequenceNumber = (Long)FieldReaderFactory.readSimpleField((String)"sequenceNumber", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long publishTime = (Long)FieldReaderFactory.readSimpleField((String)"publishTime", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNotificationData = (Integer)FieldReaderFactory.readSimpleField((String)"noOfNotificationData", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List notificationData = FieldReaderFactory.readCountArrayField((String)"notificationData", (DataReader)new DataReaderComplexDefault(() -> ExtensionObject.staticParse(readBuffer, true), readBuffer), (long)noOfNotificationData, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("NotificationMessage", new WithReaderArgs[0]);
        return new NotificationMessageBuilder(sequenceNumber, publishTime, noOfNotificationData, notificationData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationMessage)) {
            return false;
        }
        NotificationMessage that = (NotificationMessage)o;
        return this.getSequenceNumber() == that.getSequenceNumber() && this.getPublishTime() == that.getPublishTime() && this.getNoOfNotificationData() == that.getNoOfNotificationData() && this.getNotificationData() == that.getNotificationData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSequenceNumber(), this.getPublishTime(), this.getNoOfNotificationData(), this.getNotificationData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NotificationMessageBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long sequenceNumber;
        private final long publishTime;
        private final int noOfNotificationData;
        private final List<ExtensionObject> notificationData;

        public NotificationMessageBuilder(long sequenceNumber, long publishTime, int noOfNotificationData, List<ExtensionObject> notificationData) {
            this.sequenceNumber = sequenceNumber;
            this.publishTime = publishTime;
            this.noOfNotificationData = noOfNotificationData;
            this.notificationData = notificationData;
        }

        @Override
        public NotificationMessage build() {
            NotificationMessage notificationMessage = new NotificationMessage(this.sequenceNumber, this.publishTime, this.noOfNotificationData, this.notificationData);
            return notificationMessage;
        }
    }
}

