/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaCloseRequest
extends MessagePDU
implements Message {
    protected final String chunk;
    protected final int secureChannelId;
    protected final int secureTokenId;
    protected final int sequenceNumber;
    protected final int requestId;
    protected final ExtensionObject message;

    @Override
    public String getMessageType() {
        return "CLO";
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public OpcuaCloseRequest(String chunk, int secureChannelId, int secureTokenId, int sequenceNumber, int requestId, ExtensionObject message) {
        this.chunk = chunk;
        this.secureChannelId = secureChannelId;
        this.secureTokenId = secureTokenId;
        this.sequenceNumber = sequenceNumber;
        this.requestId = requestId;
        this.message = message;
    }

    public String getChunk() {
        return this.chunk;
    }

    public int getSecureChannelId() {
        return this.secureChannelId;
    }

    public int getSecureTokenId() {
        return this.secureTokenId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public ExtensionObject getMessage() {
        return this.message;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("OpcuaCloseRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"chunk", (Object)this.chunk, (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        int messageSize = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"messageSize", (Object)messageSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"secureChannelId", (Object)this.secureChannelId, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"secureTokenId", (Object)this.secureTokenId, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sequenceNumber", (Object)this.sequenceNumber, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestId", (Object)this.requestId, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"message", (Object)this.message, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaCloseRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaCloseRequest _value = this;
        lengthInBits += 8;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        return lengthInBits += this.message.getLengthInBits();
    }

    public static OpcuaCloseRequestBuilder staticParseBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaCloseRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        String chunk = (String)FieldReaderFactory.readSimpleField((String)"chunk", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        int messageSize = (Integer)FieldReaderFactory.readImplicitField((String)"messageSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int secureChannelId = (Integer)FieldReaderFactory.readSimpleField((String)"secureChannelId", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int secureTokenId = (Integer)FieldReaderFactory.readSimpleField((String)"secureTokenId", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int sequenceNumber = (Integer)FieldReaderFactory.readSimpleField((String)"sequenceNumber", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int requestId = (Integer)FieldReaderFactory.readSimpleField((String)"requestId", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject message = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"message", (DataReader)new DataReaderComplexDefault(() -> ExtensionObject.staticParse(readBuffer, false), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaCloseRequest", new WithReaderArgs[0]);
        return new OpcuaCloseRequestBuilder(chunk, secureChannelId, secureTokenId, sequenceNumber, requestId, message);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaCloseRequest)) {
            return false;
        }
        OpcuaCloseRequest that = (OpcuaCloseRequest)o;
        return this.getChunk() == that.getChunk() && this.getSecureChannelId() == that.getSecureChannelId() && this.getSecureTokenId() == that.getSecureTokenId() && this.getSequenceNumber() == that.getSequenceNumber() && this.getRequestId() == that.getRequestId() && this.getMessage() == that.getMessage() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getChunk(), this.getSecureChannelId(), this.getSecureTokenId(), this.getSequenceNumber(), this.getRequestId(), this.getMessage());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaCloseRequestBuilder
    implements MessagePDU.MessagePDUBuilder {
        private final String chunk;
        private final int secureChannelId;
        private final int secureTokenId;
        private final int sequenceNumber;
        private final int requestId;
        private final ExtensionObject message;

        public OpcuaCloseRequestBuilder(String chunk, int secureChannelId, int secureTokenId, int sequenceNumber, int requestId, ExtensionObject message) {
            this.chunk = chunk;
            this.secureChannelId = secureChannelId;
            this.secureTokenId = secureTokenId;
            this.sequenceNumber = sequenceNumber;
            this.requestId = requestId;
            this.message = message;
        }

        @Override
        public OpcuaCloseRequest build() {
            OpcuaCloseRequest opcuaCloseRequest = new OpcuaCloseRequest(this.chunk, this.secureChannelId, this.secureTokenId, this.sequenceNumber, this.requestId, this.message);
            return opcuaCloseRequest;
        }
    }
}

