/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaMessageRequest
extends MessagePDU
implements Message {
    protected final String chunk;
    protected final int secureChannelId;
    protected final int secureTokenId;
    protected final int sequenceNumber;
    protected final int requestId;
    protected final byte[] message;

    @Override
    public String getMessageType() {
        return "MSG";
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public OpcuaMessageRequest(String chunk, int secureChannelId, int secureTokenId, int sequenceNumber, int requestId, byte[] message) {
        this.chunk = chunk;
        this.secureChannelId = secureChannelId;
        this.secureTokenId = secureTokenId;
        this.sequenceNumber = sequenceNumber;
        this.requestId = requestId;
        this.message = message;
    }

    public String getChunk() {
        return this.chunk;
    }

    public int getSecureChannelId() {
        return this.secureChannelId;
    }

    public int getSecureTokenId() {
        return this.secureTokenId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public byte[] getMessage() {
        return this.message;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("OpcuaMessageRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"chunk", (Object)this.chunk, (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        int messageSize = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"messageSize", (Object)messageSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"secureChannelId", (Object)this.secureChannelId, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"secureTokenId", (Object)this.secureTokenId, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sequenceNumber", (Object)this.sequenceNumber, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestId", (Object)this.requestId, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"message", (byte[])this.message, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaMessageRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaMessageRequest _value = this;
        lengthInBits += 8;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.message != null) {
            lengthInBits += 8 * this.message.length;
        }
        return lengthInBits;
    }

    public static OpcuaMessageRequestBuilder staticParseBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaMessageRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        String chunk = (String)FieldReaderFactory.readSimpleField((String)"chunk", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        int messageSize = (Integer)FieldReaderFactory.readImplicitField((String)"messageSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int secureChannelId = (Integer)FieldReaderFactory.readSimpleField((String)"secureChannelId", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int secureTokenId = (Integer)FieldReaderFactory.readSimpleField((String)"secureTokenId", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int sequenceNumber = (Integer)FieldReaderFactory.readSimpleField((String)"sequenceNumber", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int requestId = (Integer)FieldReaderFactory.readSimpleField((String)"requestId", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] message = readBuffer.readByteArray("message", Math.toIntExact(messageSize - 24), new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaMessageRequest", new WithReaderArgs[0]);
        return new OpcuaMessageRequestBuilder(chunk, secureChannelId, secureTokenId, sequenceNumber, requestId, message);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaMessageRequest)) {
            return false;
        }
        OpcuaMessageRequest that = (OpcuaMessageRequest)o;
        return this.getChunk() == that.getChunk() && this.getSecureChannelId() == that.getSecureChannelId() && this.getSecureTokenId() == that.getSecureTokenId() && this.getSequenceNumber() == that.getSequenceNumber() && this.getRequestId() == that.getRequestId() && this.getMessage() == that.getMessage() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getChunk(), this.getSecureChannelId(), this.getSecureTokenId(), this.getSequenceNumber(), this.getRequestId(), this.getMessage());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaMessageRequestBuilder
    implements MessagePDU.MessagePDUBuilder {
        private final String chunk;
        private final int secureChannelId;
        private final int secureTokenId;
        private final int sequenceNumber;
        private final int requestId;
        private final byte[] message;

        public OpcuaMessageRequestBuilder(String chunk, int secureChannelId, int secureTokenId, int sequenceNumber, int requestId, byte[] message) {
            this.chunk = chunk;
            this.secureChannelId = secureChannelId;
            this.secureTokenId = secureTokenId;
            this.sequenceNumber = sequenceNumber;
            this.requestId = requestId;
            this.message = message;
        }

        @Override
        public OpcuaMessageRequest build() {
            OpcuaMessageRequest opcuaMessageRequest = new OpcuaMessageRequest(this.chunk, this.secureChannelId, this.secureTokenId, this.sequenceNumber, this.requestId, this.message);
            return opcuaMessageRequest;
        }
    }
}

