/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaOpenRequest
extends MessagePDU
implements Message {
    protected final String chunk;
    protected final int secureChannelId;
    protected final PascalString endpoint;
    protected final PascalByteString senderCertificate;
    protected final PascalByteString receiverCertificateThumbprint;
    protected final int sequenceNumber;
    protected final int requestId;
    protected final byte[] message;

    @Override
    public String getMessageType() {
        return "OPN";
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public OpcuaOpenRequest(String chunk, int secureChannelId, PascalString endpoint, PascalByteString senderCertificate, PascalByteString receiverCertificateThumbprint, int sequenceNumber, int requestId, byte[] message) {
        this.chunk = chunk;
        this.secureChannelId = secureChannelId;
        this.endpoint = endpoint;
        this.senderCertificate = senderCertificate;
        this.receiverCertificateThumbprint = receiverCertificateThumbprint;
        this.sequenceNumber = sequenceNumber;
        this.requestId = requestId;
        this.message = message;
    }

    public String getChunk() {
        return this.chunk;
    }

    public int getSecureChannelId() {
        return this.secureChannelId;
    }

    public PascalString getEndpoint() {
        return this.endpoint;
    }

    public PascalByteString getSenderCertificate() {
        return this.senderCertificate;
    }

    public PascalByteString getReceiverCertificateThumbprint() {
        return this.receiverCertificateThumbprint;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public byte[] getMessage() {
        return this.message;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("OpcuaOpenRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"chunk", (Object)this.chunk, (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        int messageSize = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"messageSize", (Object)messageSize, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"secureChannelId", (Object)this.secureChannelId, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"endpoint", (Object)this.endpoint, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"senderCertificate", (Object)this.senderCertificate, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"receiverCertificateThumbprint", (Object)this.receiverCertificateThumbprint, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sequenceNumber", (Object)this.sequenceNumber, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestId", (Object)this.requestId, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"message", (byte[])this.message, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaOpenRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaOpenRequest _value = this;
        lengthInBits += 8;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += this.endpoint.getLengthInBits();
        lengthInBits += this.senderCertificate.getLengthInBits();
        lengthInBits += this.receiverCertificateThumbprint.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.message != null) {
            lengthInBits += 8 * this.message.length;
        }
        return lengthInBits;
    }

    public static OpcuaOpenRequestBuilder staticParseBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaOpenRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        String chunk = (String)FieldReaderFactory.readSimpleField((String)"chunk", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        int messageSize = (Integer)FieldReaderFactory.readImplicitField((String)"messageSize", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int secureChannelId = (Integer)FieldReaderFactory.readSimpleField((String)"secureChannelId", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString endpoint = (PascalString)FieldReaderFactory.readSimpleField((String)"endpoint", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalByteString senderCertificate = (PascalByteString)FieldReaderFactory.readSimpleField((String)"senderCertificate", (DataReader)new DataReaderComplexDefault(() -> PascalByteString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalByteString receiverCertificateThumbprint = (PascalByteString)FieldReaderFactory.readSimpleField((String)"receiverCertificateThumbprint", (DataReader)new DataReaderComplexDefault(() -> PascalByteString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int sequenceNumber = (Integer)FieldReaderFactory.readSimpleField((String)"sequenceNumber", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int requestId = (Integer)FieldReaderFactory.readSimpleField((String)"requestId", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] message = readBuffer.readByteArray("message", Math.toIntExact(messageSize - (endpoint.getStringLength() == -1 ? 0 : endpoint.getStringLength()) - (senderCertificate.getStringLength() == -1 ? 0 : senderCertificate.getStringLength()) - (receiverCertificateThumbprint.getStringLength() == -1 ? 0 : receiverCertificateThumbprint.getStringLength()) - 32), new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaOpenRequest", new WithReaderArgs[0]);
        return new OpcuaOpenRequestBuilder(chunk, secureChannelId, endpoint, senderCertificate, receiverCertificateThumbprint, sequenceNumber, requestId, message);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaOpenRequest)) {
            return false;
        }
        OpcuaOpenRequest that = (OpcuaOpenRequest)o;
        return this.getChunk() == that.getChunk() && this.getSecureChannelId() == that.getSecureChannelId() && this.getEndpoint() == that.getEndpoint() && this.getSenderCertificate() == that.getSenderCertificate() && this.getReceiverCertificateThumbprint() == that.getReceiverCertificateThumbprint() && this.getSequenceNumber() == that.getSequenceNumber() && this.getRequestId() == that.getRequestId() && this.getMessage() == that.getMessage() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getChunk(), this.getSecureChannelId(), this.getEndpoint(), this.getSenderCertificate(), this.getReceiverCertificateThumbprint(), this.getSequenceNumber(), this.getRequestId(), this.getMessage());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaOpenRequestBuilder
    implements MessagePDU.MessagePDUBuilder {
        private final String chunk;
        private final int secureChannelId;
        private final PascalString endpoint;
        private final PascalByteString senderCertificate;
        private final PascalByteString receiverCertificateThumbprint;
        private final int sequenceNumber;
        private final int requestId;
        private final byte[] message;

        public OpcuaOpenRequestBuilder(String chunk, int secureChannelId, PascalString endpoint, PascalByteString senderCertificate, PascalByteString receiverCertificateThumbprint, int sequenceNumber, int requestId, byte[] message) {
            this.chunk = chunk;
            this.secureChannelId = secureChannelId;
            this.endpoint = endpoint;
            this.senderCertificate = senderCertificate;
            this.receiverCertificateThumbprint = receiverCertificateThumbprint;
            this.sequenceNumber = sequenceNumber;
            this.requestId = requestId;
            this.message = message;
        }

        @Override
        public OpcuaOpenRequest build() {
            OpcuaOpenRequest opcuaOpenRequest = new OpcuaOpenRequest(this.chunk, this.secureChannelId, this.endpoint, this.senderCertificate, this.receiverCertificateThumbprint, this.sequenceNumber, this.requestId, this.message);
            return opcuaOpenRequest;
        }
    }
}

