/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class StructureField
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final LocalizedText description;
    protected final NodeId dataType;
    protected final int valueRank;
    protected final int noOfArrayDimensions;
    protected final List<Long> arrayDimensions;
    protected final long maxStringLength;
    protected final boolean isOptional;
    private Short reservedField0;

    @Override
    public String getIdentifier() {
        return "103";
    }

    public StructureField(PascalString name, LocalizedText description, NodeId dataType, int valueRank, int noOfArrayDimensions, List<Long> arrayDimensions, long maxStringLength, boolean isOptional) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.noOfArrayDimensions = noOfArrayDimensions;
        this.arrayDimensions = arrayDimensions;
        this.maxStringLength = maxStringLength;
        this.isOptional = isOptional;
    }

    public PascalString getName() {
        return this.name;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public int getValueRank() {
        return this.valueRank;
    }

    public int getNoOfArrayDimensions() {
        return this.noOfArrayDimensions;
    }

    public List<Long> getArrayDimensions() {
        return this.arrayDimensions;
    }

    public long getMaxStringLength() {
        return this.maxStringLength;
    }

    public boolean getIsOptional() {
        return this.isOptional;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("StructureField", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"description", (Object)this.description, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataType", (Object)this.dataType, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"valueRank", (Object)this.valueRank, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfArrayDimensions", (Object)this.noOfArrayDimensions, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"arrayDimensions", this.arrayDimensions, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxStringLength", (Object)this.maxStringLength, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (short)0), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"isOptional", (Object)this.isOptional, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("StructureField", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        StructureField _value = this;
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += this.description.getLengthInBits();
        lengthInBits += this.dataType.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.arrayDimensions != null) {
            lengthInBits += 32 * this.arrayDimensions.size();
        }
        lengthInBits += 32;
        lengthInBits += 7;
        return ++lengthInBits;
    }

    public static StructureFieldBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("StructureField", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText description = (LocalizedText)FieldReaderFactory.readSimpleField((String)"description", (DataReader)new DataReaderComplexDefault(() -> LocalizedText.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId dataType = (NodeId)FieldReaderFactory.readSimpleField((String)"dataType", (DataReader)new DataReaderComplexDefault(() -> NodeId.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int valueRank = (Integer)FieldReaderFactory.readSimpleField((String)"valueRank", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfArrayDimensions = (Integer)FieldReaderFactory.readSimpleField((String)"noOfArrayDimensions", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List arrayDimensions = FieldReaderFactory.readCountArrayField((String)"arrayDimensions", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (long)noOfArrayDimensions, (WithReaderArgs[])new WithReaderArgs[0]);
        long maxStringLength = (Long)FieldReaderFactory.readSimpleField((String)"maxStringLength", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        Short reservedField0 = (Short)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isOptional = (Boolean)FieldReaderFactory.readSimpleField((String)"isOptional", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("StructureField", new WithReaderArgs[0]);
        return new StructureFieldBuilder(name, description, dataType, valueRank, noOfArrayDimensions, arrayDimensions, maxStringLength, isOptional, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructureField)) {
            return false;
        }
        StructureField that = (StructureField)o;
        return this.getName() == that.getName() && this.getDescription() == that.getDescription() && this.getDataType() == that.getDataType() && this.getValueRank() == that.getValueRank() && this.getNoOfArrayDimensions() == that.getNoOfArrayDimensions() && this.getArrayDimensions() == that.getArrayDimensions() && this.getMaxStringLength() == that.getMaxStringLength() && this.getIsOptional() == that.getIsOptional() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getDescription(), this.getDataType(), this.getValueRank(), this.getNoOfArrayDimensions(), this.getArrayDimensions(), this.getMaxStringLength(), this.getIsOptional());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class StructureFieldBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final LocalizedText description;
        private final NodeId dataType;
        private final int valueRank;
        private final int noOfArrayDimensions;
        private final List<Long> arrayDimensions;
        private final long maxStringLength;
        private final boolean isOptional;
        private final Short reservedField0;

        public StructureFieldBuilder(PascalString name, LocalizedText description, NodeId dataType, int valueRank, int noOfArrayDimensions, List<Long> arrayDimensions, long maxStringLength, boolean isOptional, Short reservedField0) {
            this.name = name;
            this.description = description;
            this.dataType = dataType;
            this.valueRank = valueRank;
            this.noOfArrayDimensions = noOfArrayDimensions;
            this.arrayDimensions = arrayDimensions;
            this.maxStringLength = maxStringLength;
            this.isOptional = isOptional;
            this.reservedField0 = reservedField0;
        }

        @Override
        public StructureField build() {
            StructureField structureField = new StructureField(this.name, this.description, this.dataType, this.valueRank, this.noOfArrayDimensions, this.arrayDimensions, this.maxStringLength, this.isOptional);
            structureField.reservedField0 = this.reservedField0;
            return structureField;
        }
    }
}

