/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.VariantBoolean;
import org.apache.plc4x.java.opcua.readwrite.VariantByte;
import org.apache.plc4x.java.opcua.readwrite.VariantByteString;
import org.apache.plc4x.java.opcua.readwrite.VariantDataValue;
import org.apache.plc4x.java.opcua.readwrite.VariantDateTime;
import org.apache.plc4x.java.opcua.readwrite.VariantDiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.VariantDouble;
import org.apache.plc4x.java.opcua.readwrite.VariantExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.VariantExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.VariantFloat;
import org.apache.plc4x.java.opcua.readwrite.VariantGuid;
import org.apache.plc4x.java.opcua.readwrite.VariantInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantLocalizedText;
import org.apache.plc4x.java.opcua.readwrite.VariantNodeId;
import org.apache.plc4x.java.opcua.readwrite.VariantQualifiedName;
import org.apache.plc4x.java.opcua.readwrite.VariantSByte;
import org.apache.plc4x.java.opcua.readwrite.VariantStatusCode;
import org.apache.plc4x.java.opcua.readwrite.VariantString;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantVariant;
import org.apache.plc4x.java.opcua.readwrite.VariantXmlElement;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class Variant
implements Message {
    protected final boolean arrayLengthSpecified;
    protected final boolean arrayDimensionsSpecified;
    protected final Integer noOfArrayDimensions;
    protected final List<Boolean> arrayDimensions;

    public abstract Short getVariantType();

    public Variant(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions) {
        this.arrayLengthSpecified = arrayLengthSpecified;
        this.arrayDimensionsSpecified = arrayDimensionsSpecified;
        this.noOfArrayDimensions = noOfArrayDimensions;
        this.arrayDimensions = arrayDimensions;
    }

    public boolean getArrayLengthSpecified() {
        return this.arrayLengthSpecified;
    }

    public boolean getArrayDimensionsSpecified() {
        return this.arrayDimensionsSpecified;
    }

    public Integer getNoOfArrayDimensions() {
        return this.noOfArrayDimensions;
    }

    public List<Boolean> getArrayDimensions() {
        return this.arrayDimensions;
    }

    protected abstract void serializeVariantChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("Variant", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"arrayLengthSpecified", (Object)this.arrayLengthSpecified, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"arrayDimensionsSpecified", (Object)this.arrayDimensionsSpecified, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"VariantType", (Object)this.getVariantType(), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)6), (WithWriterArgs[])new WithWriterArgs[0]);
        this.serializeVariantChild(writeBuffer);
        FieldWriterFactory.writeOptionalField((String)"noOfArrayDimensions", (Object)this.noOfArrayDimensions, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (boolean)this.getArrayDimensionsSpecified(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"arrayDimensions", this.arrayDimensions, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("Variant", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        Variant _value = this;
        ++lengthInBits;
        ++lengthInBits;
        lengthInBits += 6;
        if (this.noOfArrayDimensions != null) {
            lengthInBits += 32;
        }
        if (this.arrayDimensions != null) {
            lengthInBits += 1 * this.arrayDimensions.size();
        }
        return lengthInBits;
    }

    public static Variant staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return Variant.staticParse(readBuffer);
    }

    public static Variant staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("Variant", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        boolean arrayLengthSpecified = (Boolean)FieldReaderFactory.readSimpleField((String)"arrayLengthSpecified", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean arrayDimensionsSpecified = (Boolean)FieldReaderFactory.readSimpleField((String)"arrayDimensionsSpecified", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short VariantType = (Short)FieldReaderFactory.readDiscriminatorField((String)"VariantType", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)6), (WithReaderArgs[])new WithReaderArgs[0]);
        VariantBuilder builder = null;
        if (EvaluationHelper.equals((Object)VariantType, (Object)1)) {
            builder = VariantBoolean.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)2)) {
            builder = VariantSByte.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)3)) {
            builder = VariantByte.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)4)) {
            builder = VariantInt16.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)5)) {
            builder = VariantUInt16.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)6)) {
            builder = VariantInt32.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)7)) {
            builder = VariantUInt32.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)8)) {
            builder = VariantInt64.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)9)) {
            builder = VariantUInt64.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)10)) {
            builder = VariantFloat.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)11)) {
            builder = VariantDouble.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)12)) {
            builder = VariantString.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)13)) {
            builder = VariantDateTime.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)14)) {
            builder = VariantGuid.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)15)) {
            builder = VariantByteString.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)16)) {
            builder = VariantXmlElement.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)17)) {
            builder = VariantNodeId.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)18)) {
            builder = VariantExpandedNodeId.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)19)) {
            builder = VariantStatusCode.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)20)) {
            builder = VariantQualifiedName.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)21)) {
            builder = VariantLocalizedText.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)22)) {
            builder = VariantExtensionObject.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)23)) {
            builder = VariantDataValue.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)24)) {
            builder = VariantVariant.staticParseBuilder(readBuffer, arrayLengthSpecified);
        } else if (EvaluationHelper.equals((Object)VariantType, (Object)25)) {
            builder = VariantDiagnosticInfo.staticParseBuilder(readBuffer, arrayLengthSpecified);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [VariantType=" + VariantType + " arrayLengthSpecified=" + arrayLengthSpecified + "]");
        }
        Integer noOfArrayDimensions = (Integer)FieldReaderFactory.readOptionalField((String)"noOfArrayDimensions", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (boolean)arrayDimensionsSpecified, (WithReaderArgs[])new WithReaderArgs[0]);
        List arrayDimensions = FieldReaderFactory.readCountArrayField((String)"arrayDimensions", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (long)(noOfArrayDimensions == null ? 0 : noOfArrayDimensions), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("Variant", new WithReaderArgs[0]);
        Variant _variant = builder.build(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions);
        return _variant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variant)) {
            return false;
        }
        Variant that = (Variant)o;
        return this.getArrayLengthSpecified() == that.getArrayLengthSpecified() && this.getArrayDimensionsSpecified() == that.getArrayDimensionsSpecified() && this.getNoOfArrayDimensions() == that.getNoOfArrayDimensions() && this.getArrayDimensions() == that.getArrayDimensions();
    }

    public int hashCode() {
        return Objects.hash(this.getArrayLengthSpecified(), this.getArrayDimensionsSpecified(), this.getNoOfArrayDimensions(), this.getArrayDimensions());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface VariantBuilder {
        public Variant build(boolean var1, boolean var2, Integer var3, List<Boolean> var4);
    }
}

