/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class VariantUInt64
extends Variant
implements Message {
    protected final Integer arrayLength;
    protected final List<BigInteger> value;

    @Override
    public Short getVariantType() {
        return (short)9;
    }

    public VariantUInt64(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions, Integer arrayLength, List<BigInteger> value) {
        super(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions);
        this.arrayLength = arrayLength;
        this.value = value;
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    public List<BigInteger> getValue() {
        return this.value;
    }

    @Override
    protected void serializeVariantChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("VariantUInt64", new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"arrayLength", (Object)this.arrayLength, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (boolean)this.arrayLengthSpecified, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"value", this.value, (DataWriter)DataWriterFactory.writeUnsignedBigInteger((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("VariantUInt64", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        VariantUInt64 _value = this;
        if (this.arrayLength != null) {
            lengthInBits += 32;
        }
        if (this.value != null) {
            lengthInBits += 64 * this.value.size();
        }
        return lengthInBits;
    }

    public static VariantUInt64Builder staticParseBuilder(ReadBuffer readBuffer, Boolean arrayLengthSpecified) throws ParseException {
        readBuffer.pullContext("VariantUInt64", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        Integer arrayLength = (Integer)FieldReaderFactory.readOptionalField((String)"arrayLength", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (boolean)arrayLengthSpecified, (WithReaderArgs[])new WithReaderArgs[0]);
        List value = FieldReaderFactory.readCountArrayField((String)"value", (DataReader)DataReaderFactory.readUnsignedBigInteger((ReadBuffer)readBuffer, (int)64), (long)(arrayLength == null ? 1 : arrayLength), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("VariantUInt64", new WithReaderArgs[0]);
        return new VariantUInt64Builder(arrayLength, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariantUInt64)) {
            return false;
        }
        VariantUInt64 that = (VariantUInt64)o;
        return this.getArrayLength() == that.getArrayLength() && this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getArrayLength(), this.getValue());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class VariantUInt64Builder
    implements Variant.VariantBuilder {
        private final Integer arrayLength;
        private final List<BigInteger> value;

        public VariantUInt64Builder(Integer arrayLength, List<BigInteger> value) {
            this.arrayLength = arrayLength;
            this.value = value;
        }

        @Override
        public VariantUInt64 build(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions) {
            VariantUInt64 variantUInt64 = new VariantUInt64(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions, this.arrayLength, this.value);
            return variantUInt64;
        }
    }
}

