/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.InvalidOperationException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagingURIHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class OpenXMLDocument {
    public static final int READ_WRITE_FILE_BUFFER_SIZE = 8192;
    protected static Logger logger = Logger.getLogger((String)"org.openxml4j.document");
    protected Package container;

    protected OpenXMLDocument(Package container) {
        this.container = container;
    }

    public void extractFiles(String contentType, File destFolder) {
        if (!destFolder.isDirectory()) {
            throw new IllegalArgumentException("parameter desFolder should be a directory !");
        }
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        for (PackagePart part : this.container.getPartsByContentType(contentType)) {
            parts.add(part);
        }
        this.extractParts(parts, destFolder);
    }

    public boolean extractParts(ArrayList<PackagePart> parts, File destFolder) {
        boolean result = true;
        for (PackagePart part : parts) {
            String filename = PackagingURIHelper.getFilename(part.getPartName().getURI());
            try {
                int resultRead;
                InputStream ins = part.getInputStream();
                FileOutputStream fw = new FileOutputStream(destFolder.getAbsolutePath() + File.separator + filename);
                byte[] buff = new byte[8192];
                while (ins.available() > 0 && (resultRead = ins.read(buff)) != -1) {
                    fw.write(buff, 0, resultRead);
                }
                fw.close();
            }
            catch (IOException e) {
                logger.error((Object)("cannot generate file " + filename), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public ArrayList<PackagePart> getThumbnails() {
        return this.container.getPartsByRelationshipType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail");
    }

    public static OpenXMLDocument open(String path, PackageAccess access) throws InvalidFormatException {
        return null;
    }

    public void save() throws IOException {
        this.container.close();
    }

    public void save(File file) throws IOException {
        throw new InvalidOperationException("Method not implemented !");
    }

    public Package getPackage() {
        return this.container;
    }
}

