package org.apache.pulsar.common.api.proto;
public final class CommandWatchTopicList {
	private long requestId;
	private static final int _REQUEST_ID_FIELD_NUMBER = 1;
	private static final int _REQUEST_ID_TAG = (_REQUEST_ID_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(_REQUEST_ID_TAG);
	private static final int _REQUEST_ID_MASK = 1 << (0 % 32);
	public boolean hasRequestId() {
		return (_bitField0 & _REQUEST_ID_MASK) != 0;
	}
	public long getRequestId() {
		if (!hasRequestId()) {
			throw new IllegalStateException("Field 'request_id' is not set");
		}
		return requestId;
	}
	public CommandWatchTopicList setRequestId(long requestId) {
		this.requestId = requestId;
		_bitField0 |= _REQUEST_ID_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicList clearRequestId() {
		_bitField0 &= ~_REQUEST_ID_MASK;
		return this;
	}

	private long watcherId;
	private static final int _WATCHER_ID_FIELD_NUMBER = 2;
	private static final int _WATCHER_ID_TAG = (_WATCHER_ID_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _WATCHER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(_WATCHER_ID_TAG);
	private static final int _WATCHER_ID_MASK = 1 << (1 % 32);
	public boolean hasWatcherId() {
		return (_bitField0 & _WATCHER_ID_MASK) != 0;
	}
	public long getWatcherId() {
		if (!hasWatcherId()) {
			throw new IllegalStateException("Field 'watcher_id' is not set");
		}
		return watcherId;
	}
	public CommandWatchTopicList setWatcherId(long watcherId) {
		this.watcherId = watcherId;
		_bitField0 |= _WATCHER_ID_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicList clearWatcherId() {
		_bitField0 &= ~_WATCHER_ID_MASK;
		return this;
	}

	private String namespace;
	private int _namespaceBufferIdx = -1;
	private int _namespaceBufferLen = -1;
	private static final int _NAMESPACE_FIELD_NUMBER = 3;
	private static final int _NAMESPACE_TAG = (_NAMESPACE_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _NAMESPACE_TAG_SIZE = LightProtoCodec.computeVarIntSize(_NAMESPACE_TAG);
	private static final int _NAMESPACE_MASK = 1 << (2 % 32);
	public boolean hasNamespace() {
		return (_bitField0 & _NAMESPACE_MASK) != 0;
	}
	public String getNamespace() {
		if (!hasNamespace()) {
			throw new IllegalStateException("Field 'namespace' is not set");
		}
		if (namespace == null) {
			namespace = LightProtoCodec.readString(_parsedBuffer, _namespaceBufferIdx, _namespaceBufferLen);
		}
		return namespace;
	}
	public CommandWatchTopicList setNamespace(String namespace) {
		this.namespace = namespace;
		_bitField0 |= _NAMESPACE_MASK;
		_namespaceBufferIdx = -1;
		_namespaceBufferLen = LightProtoCodec.computeStringUTF8Size(namespace);
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicList clearNamespace() {
		_bitField0 &= ~_NAMESPACE_MASK;
		namespace = null;
		_namespaceBufferIdx = -1;
		_namespaceBufferLen = -1;
		return this;
	}

	private String topicsPattern;
	private int _topicsPatternBufferIdx = -1;
	private int _topicsPatternBufferLen = -1;
	private static final int _TOPICS_PATTERN_FIELD_NUMBER = 4;
	private static final int _TOPICS_PATTERN_TAG = (_TOPICS_PATTERN_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _TOPICS_PATTERN_TAG_SIZE = LightProtoCodec.computeVarIntSize(_TOPICS_PATTERN_TAG);
	private static final int _TOPICS_PATTERN_MASK = 1 << (3 % 32);
	public boolean hasTopicsPattern() {
		return (_bitField0 & _TOPICS_PATTERN_MASK) != 0;
	}
	public String getTopicsPattern() {
		if (!hasTopicsPattern()) {
			throw new IllegalStateException("Field 'topics_pattern' is not set");
		}
		if (topicsPattern == null) {
			topicsPattern = LightProtoCodec.readString(_parsedBuffer, _topicsPatternBufferIdx, _topicsPatternBufferLen);
		}
		return topicsPattern;
	}
	public CommandWatchTopicList setTopicsPattern(String topicsPattern) {
		this.topicsPattern = topicsPattern;
		_bitField0 |= _TOPICS_PATTERN_MASK;
		_topicsPatternBufferIdx = -1;
		_topicsPatternBufferLen = LightProtoCodec.computeStringUTF8Size(topicsPattern);
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicList clearTopicsPattern() {
		_bitField0 &= ~_TOPICS_PATTERN_MASK;
		topicsPattern = null;
		_topicsPatternBufferIdx = -1;
		_topicsPatternBufferLen = -1;
		return this;
	}

	private String topicsHash;
	private int _topicsHashBufferIdx = -1;
	private int _topicsHashBufferLen = -1;
	private static final int _TOPICS_HASH_FIELD_NUMBER = 5;
	private static final int _TOPICS_HASH_TAG = (_TOPICS_HASH_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _TOPICS_HASH_TAG_SIZE = LightProtoCodec.computeVarIntSize(_TOPICS_HASH_TAG);
	private static final int _TOPICS_HASH_MASK = 1 << (4 % 32);
	public boolean hasTopicsHash() {
		return (_bitField0 & _TOPICS_HASH_MASK) != 0;
	}
	public String getTopicsHash() {
		if (!hasTopicsHash()) {
			throw new IllegalStateException("Field 'topics_hash' is not set");
		}
		if (topicsHash == null) {
			topicsHash = LightProtoCodec.readString(_parsedBuffer, _topicsHashBufferIdx, _topicsHashBufferLen);
		}
		return topicsHash;
	}
	public CommandWatchTopicList setTopicsHash(String topicsHash) {
		this.topicsHash = topicsHash;
		_bitField0 |= _TOPICS_HASH_MASK;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = LightProtoCodec.computeStringUTF8Size(topicsHash);
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicList clearTopicsHash() {
		_bitField0 &= ~_TOPICS_HASH_MASK;
		topicsHash = null;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = -1;
		return this;
	}

	private int _bitField0;
	private static final int _REQUIRED_FIELDS_MASK0 = 0 | _REQUEST_ID_MASK | _WATCHER_ID_MASK | _NAMESPACE_MASK
			| _TOPICS_PATTERN_MASK;
	public int writeTo(org.apache.pulsar.shade.io.netty.buffer.ByteBuf _b) {
		checkRequiredFields();
		int _writeIdx = _b.writerIndex();
		LightProtoCodec.writeVarInt(_b, _REQUEST_ID_TAG);
		LightProtoCodec.writeVarInt64(_b, requestId);
		LightProtoCodec.writeVarInt(_b, _WATCHER_ID_TAG);
		LightProtoCodec.writeVarInt64(_b, watcherId);
		LightProtoCodec.writeVarInt(_b, _NAMESPACE_TAG);
		LightProtoCodec.writeVarInt(_b, _namespaceBufferLen);
		if (_namespaceBufferIdx == -1) {
			LightProtoCodec.writeString(_b, namespace, _namespaceBufferLen);
		} else {
			_parsedBuffer.getBytes(_namespaceBufferIdx, _b, _namespaceBufferLen);
		}
		LightProtoCodec.writeVarInt(_b, _TOPICS_PATTERN_TAG);
		LightProtoCodec.writeVarInt(_b, _topicsPatternBufferLen);
		if (_topicsPatternBufferIdx == -1) {
			LightProtoCodec.writeString(_b, topicsPattern, _topicsPatternBufferLen);
		} else {
			_parsedBuffer.getBytes(_topicsPatternBufferIdx, _b, _topicsPatternBufferLen);
		}
		if (hasTopicsHash()) {
			LightProtoCodec.writeVarInt(_b, _TOPICS_HASH_TAG);
			LightProtoCodec.writeVarInt(_b, _topicsHashBufferLen);
			if (_topicsHashBufferIdx == -1) {
				LightProtoCodec.writeString(_b, topicsHash, _topicsHashBufferLen);
			} else {
				_parsedBuffer.getBytes(_topicsHashBufferIdx, _b, _topicsHashBufferLen);
			}
		}
		return (_b.writerIndex() - _writeIdx);
	}
	public int getSerializedSize() {
		if (_cachedSize > -1) {
			return _cachedSize;
		}

		int _size = 0;
		_size += _REQUEST_ID_TAG_SIZE;
		_size += LightProtoCodec.computeVarInt64Size(requestId);
		_size += _WATCHER_ID_TAG_SIZE;
		_size += LightProtoCodec.computeVarInt64Size(watcherId);
		_size += _NAMESPACE_TAG_SIZE;
		_size += LightProtoCodec.computeVarIntSize(_namespaceBufferLen);
		_size += _namespaceBufferLen;
		_size += _TOPICS_PATTERN_TAG_SIZE;
		_size += LightProtoCodec.computeVarIntSize(_topicsPatternBufferLen);
		_size += _topicsPatternBufferLen;
		if (hasTopicsHash()) {
			_size += _TOPICS_HASH_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_topicsHashBufferLen);
			_size += _topicsHashBufferLen;
		}
		_cachedSize = _size;
		return _size;
	}
	public void parseFrom(org.apache.pulsar.shade.io.netty.buffer.ByteBuf _buffer, int _size) {
		clear();
		int _endIdx = _buffer.readerIndex() + _size;
		while (_buffer.readerIndex() < _endIdx) {
			int _tag = LightProtoCodec.readVarInt(_buffer);
			switch (_tag) {
				case _REQUEST_ID_TAG :
					_bitField0 |= _REQUEST_ID_MASK;
					requestId = LightProtoCodec.readVarInt64(_buffer);
					break;
				case _WATCHER_ID_TAG :
					_bitField0 |= _WATCHER_ID_MASK;
					watcherId = LightProtoCodec.readVarInt64(_buffer);
					break;
				case _NAMESPACE_TAG :
					_bitField0 |= _NAMESPACE_MASK;
					_namespaceBufferLen = LightProtoCodec.readVarInt(_buffer);
					_namespaceBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_namespaceBufferLen);
					break;
				case _TOPICS_PATTERN_TAG :
					_bitField0 |= _TOPICS_PATTERN_MASK;
					_topicsPatternBufferLen = LightProtoCodec.readVarInt(_buffer);
					_topicsPatternBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_topicsPatternBufferLen);
					break;
				case _TOPICS_HASH_TAG :
					_bitField0 |= _TOPICS_HASH_MASK;
					_topicsHashBufferLen = LightProtoCodec.readVarInt(_buffer);
					_topicsHashBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_topicsHashBufferLen);
					break;
				default :
					LightProtoCodec.skipUnknownField(_tag, _buffer);
			}
		}
		checkRequiredFields();
		_parsedBuffer = _buffer;
	}
	private void checkRequiredFields() {
		if ((_bitField0 & _REQUIRED_FIELDS_MASK0) != _REQUIRED_FIELDS_MASK0) {
			throw new IllegalStateException("Some required fields are missing");
		}
	}
	public CommandWatchTopicList clear() {
		namespace = null;
		_namespaceBufferIdx = -1;
		_namespaceBufferLen = -1;
		topicsPattern = null;
		_topicsPatternBufferIdx = -1;
		_topicsPatternBufferLen = -1;
		topicsHash = null;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = -1;
		_parsedBuffer = null;
		_cachedSize = -1;
		_bitField0 = 0;
		return this;
	}
	public CommandWatchTopicList copyFrom(CommandWatchTopicList _other) {
		_cachedSize = -1;
		if (_other.hasRequestId()) {
			setRequestId(_other.requestId);
		}
		if (_other.hasWatcherId()) {
			setWatcherId(_other.watcherId);
		}
		if (_other.hasNamespace()) {
			setNamespace(_other.getNamespace());
		}
		if (_other.hasTopicsPattern()) {
			setTopicsPattern(_other.getTopicsPattern());
		}
		if (_other.hasTopicsHash()) {
			setTopicsHash(_other.getTopicsHash());
		}
		return this;
	}
	public byte[] toByteArray() {
		byte[] a = new byte[getSerializedSize()];
		org.apache.pulsar.shade.io.netty.buffer.ByteBuf b = org.apache.pulsar.shade.io.netty.buffer.Unpooled.wrappedBuffer(a).writerIndex(0);
		this.writeTo(b);
		return a;
	}
	public void parseFrom(byte[] a) {
		org.apache.pulsar.shade.io.netty.buffer.ByteBuf b = org.apache.pulsar.shade.io.netty.buffer.Unpooled.wrappedBuffer(a);
		this.parseFrom(b, b.readableBytes());
	}
	private int _cachedSize;

	private org.apache.pulsar.shade.io.netty.buffer.ByteBuf _parsedBuffer;

}
