package org.apache.pulsar.common.api.proto;
public final class CommandWatchTopicUpdate {
	private long watcherId;
	private static final int _WATCHER_ID_FIELD_NUMBER = 1;
	private static final int _WATCHER_ID_TAG = (_WATCHER_ID_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _WATCHER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(_WATCHER_ID_TAG);
	private static final int _WATCHER_ID_MASK = 1 << (0 % 32);
	public boolean hasWatcherId() {
		return (_bitField0 & _WATCHER_ID_MASK) != 0;
	}
	public long getWatcherId() {
		if (!hasWatcherId()) {
			throw new IllegalStateException("Field 'watcher_id' is not set");
		}
		return watcherId;
	}
	public CommandWatchTopicUpdate setWatcherId(long watcherId) {
		this.watcherId = watcherId;
		_bitField0 |= _WATCHER_ID_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicUpdate clearWatcherId() {
		_bitField0 &= ~_WATCHER_ID_MASK;
		return this;
	}

	private java.util.List<LightProtoCodec.StringHolder> newTopics = null;
	private int _newTopicsCount = 0;
	private static final int _NEW_TOPICS_FIELD_NUMBER = 2;
	private static final int _NEW_TOPICS_TAG = (_NEW_TOPICS_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _NEW_TOPICS_TAG_SIZE = LightProtoCodec.computeVarIntSize(_NEW_TOPICS_TAG);
	public int getNewTopicsCount() {
		return _newTopicsCount;
	}
	public String getNewTopicAt(int idx) {
		if (idx < 0 || idx >= _newTopicsCount) {
			throw new IndexOutOfBoundsException(
					"Index " + idx + " is out of the list size (" + _newTopicsCount + ") for field 'new_topics'");
		}
		LightProtoCodec.StringHolder _sh = newTopics.get(idx);
		if (_sh.s == null) {
			_sh.s = LightProtoCodec.readString(_parsedBuffer, _sh.idx, _sh.len);
		}
		return _sh.s;
	}
	public java.util.List<String> getNewTopicsList() {
		if (_newTopicsCount == 0) {
			return java.util.Collections.emptyList();
		} else {
			java.util.List<String> _l = new java.util.ArrayList<>();
			for (int i = 0; i < _newTopicsCount; i++) {
				_l.add(getNewTopicAt(i));
			}
			return _l;
		}
	}
	public void addNewTopic(String newTopic) {
		if (newTopics == null) {
			newTopics = new java.util.ArrayList<LightProtoCodec.StringHolder>();
		}
		LightProtoCodec.StringHolder _sh = _newNewTopicStringHolder();
		_cachedSize = -1;
		_sh.s = newTopic;
		_sh.idx = -1;
		_sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
	}
	public CommandWatchTopicUpdate addAllNewTopics(Iterable<String> newTopics) {
		for (String _s : newTopics) {
			addNewTopic(_s);
		}
		return this;
	}
	private LightProtoCodec.StringHolder _newNewTopicStringHolder() {
		if (newTopics == null) {
			newTopics = new java.util.ArrayList<LightProtoCodec.StringHolder>();
		}
		LightProtoCodec.StringHolder _sh;
		if (newTopics.size() == _newTopicsCount) {
			_sh = new LightProtoCodec.StringHolder();
			newTopics.add(_sh);
		} else {
			_sh = newTopics.get(_newTopicsCount);
		}
		_newTopicsCount++;
		return _sh;
	}
	public CommandWatchTopicUpdate clearNewTopics() {
		for (int i = 0; i < _newTopicsCount; i++) {
			LightProtoCodec.StringHolder _sh = newTopics.get(i);
			_sh.s = null;
			_sh.idx = -1;
			_sh.len = -1;
		}
		_newTopicsCount = 0;
		return this;
	}

	private java.util.List<LightProtoCodec.StringHolder> deletedTopics = null;
	private int _deletedTopicsCount = 0;
	private static final int _DELETED_TOPICS_FIELD_NUMBER = 3;
	private static final int _DELETED_TOPICS_TAG = (_DELETED_TOPICS_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _DELETED_TOPICS_TAG_SIZE = LightProtoCodec.computeVarIntSize(_DELETED_TOPICS_TAG);
	public int getDeletedTopicsCount() {
		return _deletedTopicsCount;
	}
	public String getDeletedTopicAt(int idx) {
		if (idx < 0 || idx >= _deletedTopicsCount) {
			throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + _deletedTopicsCount
					+ ") for field 'deleted_topics'");
		}
		LightProtoCodec.StringHolder _sh = deletedTopics.get(idx);
		if (_sh.s == null) {
			_sh.s = LightProtoCodec.readString(_parsedBuffer, _sh.idx, _sh.len);
		}
		return _sh.s;
	}
	public java.util.List<String> getDeletedTopicsList() {
		if (_deletedTopicsCount == 0) {
			return java.util.Collections.emptyList();
		} else {
			java.util.List<String> _l = new java.util.ArrayList<>();
			for (int i = 0; i < _deletedTopicsCount; i++) {
				_l.add(getDeletedTopicAt(i));
			}
			return _l;
		}
	}
	public void addDeletedTopic(String deletedTopic) {
		if (deletedTopics == null) {
			deletedTopics = new java.util.ArrayList<LightProtoCodec.StringHolder>();
		}
		LightProtoCodec.StringHolder _sh = _newDeletedTopicStringHolder();
		_cachedSize = -1;
		_sh.s = deletedTopic;
		_sh.idx = -1;
		_sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
	}
	public CommandWatchTopicUpdate addAllDeletedTopics(Iterable<String> deletedTopics) {
		for (String _s : deletedTopics) {
			addDeletedTopic(_s);
		}
		return this;
	}
	private LightProtoCodec.StringHolder _newDeletedTopicStringHolder() {
		if (deletedTopics == null) {
			deletedTopics = new java.util.ArrayList<LightProtoCodec.StringHolder>();
		}
		LightProtoCodec.StringHolder _sh;
		if (deletedTopics.size() == _deletedTopicsCount) {
			_sh = new LightProtoCodec.StringHolder();
			deletedTopics.add(_sh);
		} else {
			_sh = deletedTopics.get(_deletedTopicsCount);
		}
		_deletedTopicsCount++;
		return _sh;
	}
	public CommandWatchTopicUpdate clearDeletedTopics() {
		for (int i = 0; i < _deletedTopicsCount; i++) {
			LightProtoCodec.StringHolder _sh = deletedTopics.get(i);
			_sh.s = null;
			_sh.idx = -1;
			_sh.len = -1;
		}
		_deletedTopicsCount = 0;
		return this;
	}

	private String topicsHash;
	private int _topicsHashBufferIdx = -1;
	private int _topicsHashBufferLen = -1;
	private static final int _TOPICS_HASH_FIELD_NUMBER = 4;
	private static final int _TOPICS_HASH_TAG = (_TOPICS_HASH_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _TOPICS_HASH_TAG_SIZE = LightProtoCodec.computeVarIntSize(_TOPICS_HASH_TAG);
	private static final int _TOPICS_HASH_MASK = 1 << (3 % 32);
	public boolean hasTopicsHash() {
		return (_bitField0 & _TOPICS_HASH_MASK) != 0;
	}
	public String getTopicsHash() {
		if (!hasTopicsHash()) {
			throw new IllegalStateException("Field 'topics_hash' is not set");
		}
		if (topicsHash == null) {
			topicsHash = LightProtoCodec.readString(_parsedBuffer, _topicsHashBufferIdx, _topicsHashBufferLen);
		}
		return topicsHash;
	}
	public CommandWatchTopicUpdate setTopicsHash(String topicsHash) {
		this.topicsHash = topicsHash;
		_bitField0 |= _TOPICS_HASH_MASK;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = LightProtoCodec.computeStringUTF8Size(topicsHash);
		_cachedSize = -1;
		return this;
	}
	public CommandWatchTopicUpdate clearTopicsHash() {
		_bitField0 &= ~_TOPICS_HASH_MASK;
		topicsHash = null;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = -1;
		return this;
	}

	private int _bitField0;
	private static final int _REQUIRED_FIELDS_MASK0 = 0 | _WATCHER_ID_MASK | _TOPICS_HASH_MASK;
	public int writeTo(org.apache.pulsar.shade.io.netty.buffer.ByteBuf _b) {
		checkRequiredFields();
		int _writeIdx = _b.writerIndex();
		LightProtoCodec.writeVarInt(_b, _WATCHER_ID_TAG);
		LightProtoCodec.writeVarInt64(_b, watcherId);
		for (int i = 0; i < _newTopicsCount; i++) {
			LightProtoCodec.StringHolder _sh = newTopics.get(i);
			LightProtoCodec.writeVarInt(_b, _NEW_TOPICS_TAG);
			LightProtoCodec.writeVarInt(_b, _sh.len);
			if (_sh.idx == -1) {
				LightProtoCodec.writeString(_b, _sh.s, _sh.len);
			} else {
				_parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
			}
		}
		for (int i = 0; i < _deletedTopicsCount; i++) {
			LightProtoCodec.StringHolder _sh = deletedTopics.get(i);
			LightProtoCodec.writeVarInt(_b, _DELETED_TOPICS_TAG);
			LightProtoCodec.writeVarInt(_b, _sh.len);
			if (_sh.idx == -1) {
				LightProtoCodec.writeString(_b, _sh.s, _sh.len);
			} else {
				_parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
			}
		}
		LightProtoCodec.writeVarInt(_b, _TOPICS_HASH_TAG);
		LightProtoCodec.writeVarInt(_b, _topicsHashBufferLen);
		if (_topicsHashBufferIdx == -1) {
			LightProtoCodec.writeString(_b, topicsHash, _topicsHashBufferLen);
		} else {
			_parsedBuffer.getBytes(_topicsHashBufferIdx, _b, _topicsHashBufferLen);
		}
		return (_b.writerIndex() - _writeIdx);
	}
	public int getSerializedSize() {
		if (_cachedSize > -1) {
			return _cachedSize;
		}

		int _size = 0;
		_size += _WATCHER_ID_TAG_SIZE;
		_size += LightProtoCodec.computeVarInt64Size(watcherId);
		for (int i = 0; i < _newTopicsCount; i++) {
			LightProtoCodec.StringHolder _sh = newTopics.get(i);
			_size += _NEW_TOPICS_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
		}
		for (int i = 0; i < _deletedTopicsCount; i++) {
			LightProtoCodec.StringHolder _sh = deletedTopics.get(i);
			_size += _DELETED_TOPICS_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
		}
		_size += _TOPICS_HASH_TAG_SIZE;
		_size += LightProtoCodec.computeVarIntSize(_topicsHashBufferLen);
		_size += _topicsHashBufferLen;
		_cachedSize = _size;
		return _size;
	}
	public void parseFrom(org.apache.pulsar.shade.io.netty.buffer.ByteBuf _buffer, int _size) {
		clear();
		int _endIdx = _buffer.readerIndex() + _size;
		while (_buffer.readerIndex() < _endIdx) {
			int _tag = LightProtoCodec.readVarInt(_buffer);
			switch (_tag) {
				case _WATCHER_ID_TAG :
					_bitField0 |= _WATCHER_ID_MASK;
					watcherId = LightProtoCodec.readVarInt64(_buffer);
					break;
				case _NEW_TOPICS_TAG :
					LightProtoCodec.StringHolder _newTopicsSh = _newNewTopicStringHolder();
					_newTopicsSh.len = LightProtoCodec.readVarInt(_buffer);
					_newTopicsSh.idx = _buffer.readerIndex();
					_buffer.skipBytes(_newTopicsSh.len);
					break;
				case _DELETED_TOPICS_TAG :
					LightProtoCodec.StringHolder _deletedTopicsSh = _newDeletedTopicStringHolder();
					_deletedTopicsSh.len = LightProtoCodec.readVarInt(_buffer);
					_deletedTopicsSh.idx = _buffer.readerIndex();
					_buffer.skipBytes(_deletedTopicsSh.len);
					break;
				case _TOPICS_HASH_TAG :
					_bitField0 |= _TOPICS_HASH_MASK;
					_topicsHashBufferLen = LightProtoCodec.readVarInt(_buffer);
					_topicsHashBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_topicsHashBufferLen);
					break;
				default :
					LightProtoCodec.skipUnknownField(_tag, _buffer);
			}
		}
		checkRequiredFields();
		_parsedBuffer = _buffer;
	}
	private void checkRequiredFields() {
		if ((_bitField0 & _REQUIRED_FIELDS_MASK0) != _REQUIRED_FIELDS_MASK0) {
			throw new IllegalStateException("Some required fields are missing");
		}
	}
	public CommandWatchTopicUpdate clear() {
		for (int i = 0; i < _newTopicsCount; i++) {
			LightProtoCodec.StringHolder _sh = newTopics.get(i);
			_sh.s = null;
			_sh.idx = -1;
			_sh.len = -1;
		}
		_newTopicsCount = 0;
		for (int i = 0; i < _deletedTopicsCount; i++) {
			LightProtoCodec.StringHolder _sh = deletedTopics.get(i);
			_sh.s = null;
			_sh.idx = -1;
			_sh.len = -1;
		}
		_deletedTopicsCount = 0;
		topicsHash = null;
		_topicsHashBufferIdx = -1;
		_topicsHashBufferLen = -1;
		_parsedBuffer = null;
		_cachedSize = -1;
		_bitField0 = 0;
		return this;
	}
	public CommandWatchTopicUpdate copyFrom(CommandWatchTopicUpdate _other) {
		_cachedSize = -1;
		if (_other.hasWatcherId()) {
			setWatcherId(_other.watcherId);
		}
		for (int i = 0; i < _other.getNewTopicsCount(); i++) {
			addNewTopic(_other.getNewTopicAt(i));
		}
		for (int i = 0; i < _other.getDeletedTopicsCount(); i++) {
			addDeletedTopic(_other.getDeletedTopicAt(i));
		}
		if (_other.hasTopicsHash()) {
			setTopicsHash(_other.getTopicsHash());
		}
		return this;
	}
	public byte[] toByteArray() {
		byte[] a = new byte[getSerializedSize()];
		org.apache.pulsar.shade.io.netty.buffer.ByteBuf b = org.apache.pulsar.shade.io.netty.buffer.Unpooled.wrappedBuffer(a).writerIndex(0);
		this.writeTo(b);
		return a;
	}
	public void parseFrom(byte[] a) {
		org.apache.pulsar.shade.io.netty.buffer.ByteBuf b = org.apache.pulsar.shade.io.netty.buffer.Unpooled.wrappedBuffer(a);
		this.parseFrom(b, b.readableBytes());
	}
	private int _cachedSize;

	private org.apache.pulsar.shade.io.netty.buffer.ByteBuf _parsedBuffer;

}
