/*
 * Copyright (c) 2019, 2024 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.apache.pulsar.shade.org.glassfish.jersey.internal.config;

import java.util.Arrays;
import java.util.List;

class JerseySystemPropertiesConfigurationModel extends SystemPropertiesConfigurationModel {

    static final List<String> PROPERTY_CLASSES = Arrays.asList(
            "org.apache.pulsar.shade.org.glassfish.jersey.CommonProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.ExternalProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.server.ServerProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.client.ClientProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.servlet.ServletProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.message.MessageProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.apache.connector.ApacheClientProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.apache5.connector.Apache5ClientProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.helidon.connector.HelidonClientProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.jdk.connector.JdkConnectorProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.jetty.connector.JettyClientProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.netty.connector.NettyClientProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.MultiPartProperties",
            "org.apache.pulsar.shade.org.glassfish.jersey.server.oauth1.OAuth1ServerProperties");

    JerseySystemPropertiesConfigurationModel() {
        super(PROPERTY_CLASSES);
    }
}