/*
 * (c) the authors Licensed under the Apache License, Version 2.0.
 */
package org.apache.pulsar.shade.org.roaringbitmap.buffer;

import org.apache.pulsar.shade.org.roaringbitmap.BitmapDataProvider;
import org.apache.pulsar.shade.org.roaringbitmap.BitmapDataProviderSupplier;

/**
 * A {@link BitmapDataProviderSupplier} providing {@link MutableRoaringBitmap} as
 * {@link BitmapDataProvider}
 *
 * @author Benoit Lacelle
 *
 */
public class MutableRoaringBitmapSupplier implements BitmapDataProviderSupplier {

  @Override
  public BitmapDataProvider newEmpty() {
    return new MutableRoaringBitmap();
  }

}
