/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.BusState;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFBusImpl
extends AbstractBasicInterceptorProvider
implements Bus {
    protected final Map<Class, Object> extensions;
    private String id;
    private BusState state;
    private Collection<AbstractFeature> features;

    public CXFBusImpl() {
        this(null);
    }

    public CXFBusImpl(Map<Class, Object> extensions) {
        extensions = extensions == null ? new ConcurrentHashMap<Class, Object>() : new ConcurrentHashMap<Class, Object>(extensions);
        this.extensions = extensions;
        this.state = BusState.INITIAL;
        CXFBusFactory.possiblySetDefaultBus(this);
    }

    protected void setState(BusState state) {
        this.state = state;
    }

    public void setId(String i) {
        this.id = i;
    }

    @Override
    public final <T> T getExtension(Class<T> extensionType) {
        Object obj = this.extensions.get(extensionType);
        if (null != obj) {
            return extensionType.cast(obj);
        }
        return null;
    }

    @Override
    public <T> void setExtension(T extension, Class<T> extensionType) {
        this.extensions.put(extensionType, extension);
    }

    @Override
    public String getId() {
        return null == this.id ? "cxf" + Integer.toString(this.hashCode()) : this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CXFBusImpl cXFBusImpl = this;
        synchronized (cXFBusImpl) {
            if (this.state == BusState.RUNNING) {
                return;
            }
            this.state = BusState.RUNNING;
            while (this.state == BusState.RUNNING) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void initialize() {
        this.initializeFeatures();
    }

    private void initializeFeatures() {
        if (this.features != null) {
            for (AbstractFeature f : this.features) {
                f.initialize(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean wait) {
        BusLifeCycleManager lifeCycleManager = this.getExtension(BusLifeCycleManager.class);
        if (null != lifeCycleManager) {
            lifeCycleManager.preShutdown();
        }
        CXFBusImpl cXFBusImpl = this;
        synchronized (cXFBusImpl) {
            this.state = BusState.SHUTDOWN;
            this.notifyAll();
        }
        if (null != lifeCycleManager) {
            lifeCycleManager.postShutdown();
        }
        if (BusFactory.getDefaultBus(false) == this) {
            BusFactory.setDefaultBus(null);
        }
    }

    protected BusState getState() {
        return this.state;
    }

    public Collection<AbstractFeature> getFeatures() {
        return this.features;
    }

    public synchronized void setFeatures(Collection<AbstractFeature> features) {
        this.features = features;
        if (this.state == BusState.RUNNING) {
            this.initializeFeatures();
        }
    }
}

