/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogUtils {
    public static final String KEY = "org.apache.cxf.Logger";
    private static final Object[] NO_PARAMETERS = new Object[0];
    private static Class<?> loggerClass;

    private LogUtils() {
    }

    public static void setLoggerClass(Class<?> cls) {
        loggerClass = cls;
    }

    public static Logger getLogger(Class<?> cls) {
        return LogUtils.createLogger(cls, null, cls.getName());
    }

    public static Logger getLogger(Class<?> cls, String resourcename) {
        return LogUtils.createLogger(cls, resourcename, cls.getName());
    }

    public static Logger getLogger(Class<?> cls, String resourcename, String loggerName) {
        return LogUtils.createLogger(cls, resourcename, loggerName);
    }

    public static Logger getL7dLogger(Class<?> cls) {
        return LogUtils.createLogger(cls, null, cls.getName());
    }

    public static Logger getL7dLogger(Class<?> cls, String resourcename) {
        return LogUtils.createLogger(cls, resourcename, cls.getName());
    }

    public static Logger getL7dLogger(Class<?> cls, String resourcename, String loggerName) {
        return LogUtils.createLogger(cls, resourcename, loggerName);
    }

    protected static Logger createLogger(Class<?> cls, String name, String loggerName) {
        if (loggerClass != null) {
            try {
                Constructor<?> cns = loggerClass.getConstructor(String.class, String.class);
                if (name == null) {
                    try {
                        return (Logger)cns.newInstance(loggerName, BundleUtils.getBundleName(cls));
                    }
                    catch (InvocationTargetException ite) {
                        if (ite.getTargetException() instanceof MissingResourceException) {
                            return (Logger)cns.newInstance(loggerName, null);
                        }
                        throw ite;
                    }
                }
                try {
                    return (Logger)cns.newInstance(loggerName, BundleUtils.getBundleName(cls, name));
                }
                catch (InvocationTargetException ite) {
                    if (ite.getTargetException() instanceof MissingResourceException) {
                        throw (MissingResourceException)ite.getTargetException();
                    }
                    throw ite;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (name == null) {
            try {
                return Logger.getLogger(loggerName, BundleUtils.getBundleName(cls));
            }
            catch (MissingResourceException rex) {
                return Logger.getLogger(loggerName, null);
            }
        }
        return Logger.getLogger(loggerName, BundleUtils.getBundleName(cls, name));
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object parameter) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameter);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object ... parameters) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameters);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message) {
        LogUtils.log(logger, level, message, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable) {
        LogUtils.log(logger, level, message, throwable, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level, String message, Object parameter) {
        LogUtils.log(logger, level, message, new Object[]{parameter});
    }

    public static void log(Logger logger, Level level, String message, Object[] parameters) {
        if (logger.isLoggable(level)) {
            String msg = LogUtils.localize(logger, message);
            try {
                msg = MessageFormat.format(msg, parameters);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            LogUtils.doLog(logger, level, msg, null);
        }
    }

    private static void doLog(Logger log, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(log.getName());
        record.setResourceBundleName(log.getResourceBundleName());
        record.setResourceBundle(log.getResourceBundle());
        if (t != null) {
            record.setThrown(t);
        }
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String cname = LogUtils.class.getName();
        for (int x = 0; x < stack.length; ++x) {
            StackTraceElement frame = stack[x];
            if (frame.getClassName().equals(cname)) continue;
            record.setSourceClassName(frame.getClassName());
            record.setSourceMethodName(frame.getMethodName());
            break;
        }
        log.log(record);
    }

    private static String localize(Logger logger, String message) {
        ResourceBundle bundle = logger.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(message) : message;
        }
        catch (MissingResourceException ex) {
            return message;
        }
    }

    static {
        try {
            String cname = System.getProperty(KEY);
            if (StringUtils.isEmpty(cname)) {
                InputStream ins = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/cxf/org.apache.cxf.Logger");
                if (ins == null) {
                    ins = ClassLoader.getSystemResourceAsStream("META-INF/cxf/org.apache.cxf.Logger");
                }
                if (ins != null) {
                    BufferedReader din = new BufferedReader(new InputStreamReader(ins));
                    cname = din.readLine();
                }
            }
            if (!StringUtils.isEmpty(cname)) {
                loggerClass = Class.forName(cname, true, Thread.currentThread().getContextClassLoader());
                LogUtils.getLogger(LogUtils.class).fine("Using " + loggerClass.getName() + " for logging.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

