/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTwoStageCache<E> {
    private Object mutex;
    private int preallocation;
    private int primaryCacheSize;
    private int secondaryCacheHighWaterMark;
    private Queue<E> primaryCache;
    private Queue<SoftReference<E>> secondaryCache;

    public AbstractTwoStageCache(int pCacheSize, int highWaterMark, int prealloc) {
        this(pCacheSize, highWaterMark, prealloc, null);
    }

    public AbstractTwoStageCache(int pCacheSize, int highWaterMark, int prealloc, Object mutexParam) {
        this.primaryCacheSize = Math.min(pCacheSize, highWaterMark);
        this.secondaryCacheHighWaterMark = highWaterMark - pCacheSize;
        this.preallocation = prealloc > highWaterMark ? highWaterMark : prealloc;
        this.mutex = mutexParam != null ? mutexParam : this;
    }

    public String toString() {
        return "AbstractTwoStageCache";
    }

    protected abstract E create() throws Exception;

    public void populateCache() throws Exception {
        this.primaryCache = new LinkedList();
        this.secondaryCache = new LinkedList<SoftReference<E>>();
        int primaryCachePreallocation = this.preallocation > this.primaryCacheSize ? this.primaryCacheSize : this.preallocation;
        for (int i = 0; i < primaryCachePreallocation; ++i) {
            this.primaryCache.offer(this.create());
        }
        int secondaryCachePreallocation = this.preallocation - primaryCachePreallocation;
        for (int i = 0; i < secondaryCachePreallocation; ++i) {
            this.secondaryCache.offer(new SoftReference<E>(this.create()));
        }
    }

    public E get() throws Exception {
        E ret = this.poll();
        if (ret == null) {
            ret = this.create();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll() {
        E ret = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.primaryCache != null && (ret = (E)this.primaryCache.poll()) == null) {
                SoftReference<E> sr = this.secondaryCache.poll();
                while (ret == null && sr != null) {
                    if (sr != null) {
                        ret = sr.get();
                    }
                    if (ret != null) continue;
                    sr = this.secondaryCache.poll();
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recycle(E oldObject) {
        boolean cached = false;
        Object object = this.mutex;
        synchronized (object) {
            if (this.primaryCache != null) {
                if (this.primaryCache.size() < this.primaryCacheSize) {
                    cached = this.primaryCache.offer(oldObject);
                }
                if (!cached && this.secondaryCache.size() >= this.secondaryCacheHighWaterMark) {
                    Iterator it = this.secondaryCache.iterator();
                    while (it.hasNext()) {
                        SoftReference sr = (SoftReference)it.next();
                        if (sr.get() != null) continue;
                        it.remove();
                    }
                }
                if (!cached && this.secondaryCache.size() < this.secondaryCacheHighWaterMark) {
                    cached = this.secondaryCache.offer(new SoftReference<E>(oldObject));
                }
            }
        }
        return cached;
    }
}

