/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;

public class SimpleMethodDispatcher
implements MethodDispatcher {
    private Map<Method, Map<BindingInfo, BindingOperationInfo>> infoMap = new ConcurrentHashMap<Method, Map<BindingInfo, BindingOperationInfo>>();
    private Map<OperationInfo, Method> opToMethod = new ConcurrentHashMap<OperationInfo, Method>();
    private Map<Method, OperationInfo> methodToOp = new ConcurrentHashMap<Method, OperationInfo>();

    public void bind(OperationInfo o, Method ... methods) {
        Method primary = methods[0];
        for (Method m : methods) {
            this.methodToOp.put(m, o);
            HashMap biToBop = new HashMap();
            this.infoMap.put(m, biToBop);
        }
        this.opToMethod.put(o, primary);
        if (o.isUnwrappedCapable()) {
            this.opToMethod.put(o.getUnwrappedOperation(), primary);
        }
    }

    public BindingOperationInfo getBindingOperation(Method method, Endpoint endpoint) {
        Map<BindingInfo, BindingOperationInfo> bops = this.infoMap.get(method);
        if (bops == null) {
            return null;
        }
        BindingOperationInfo bop = bops.get(endpoint.getEndpointInfo().getBinding());
        if (bop == null) {
            OperationInfo o = this.methodToOp.get(method);
            if (o == null) {
                return null;
            }
            BindingInfo b = endpoint.getEndpointInfo().getBinding();
            for (BindingOperationInfo bop2 : b.getOperations()) {
                if (!bop2.getOperationInfo().equals(o)) continue;
                bop2 = this.getRealOperation(o, bop2);
                bops.put(b, bop2);
                return bop2;
            }
        }
        return bop;
    }

    private BindingOperationInfo getRealOperation(OperationInfo o, BindingOperationInfo bop) {
        BindingOperationInfo unwrappedOp = bop.getUnwrappedOperation();
        if (unwrappedOp != null && unwrappedOp.getOperationInfo().equals(o.getUnwrappedOperation())) {
            bop = unwrappedOp;
        }
        return bop;
    }

    public Method getMethod(BindingOperationInfo op) {
        return this.opToMethod.get(op.getOperationInfo());
    }

    public Method getPrimaryMethod(OperationInfo op) {
        return this.opToMethod.get(op);
    }
}

