/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.dom.ExtendedDocumentBuilder;
import org.apache.cxf.tools.common.toolspec.Tool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ToolSpec {
    private static final Logger LOG = LogUtils.getL7dLogger(ToolSpec.class);
    private final ExtendedDocumentBuilder builder = new ExtendedDocumentBuilder();
    private Document doc;
    private Tool handler;

    public ToolSpec() {
    }

    public ToolSpec(InputStream in) throws ToolException {
        this(in, true);
    }

    public ToolSpec(InputStream in, boolean validate) throws ToolException {
        if (in == null) {
            throw new NullPointerException("Cannot create a ToolSpec object from a null stream");
        }
        try {
            this.builder.setValidating(validate);
            this.doc = this.builder.parse(in);
        }
        catch (Exception ex) {
            Message message = new Message("FAIL_TO_PARSING_TOOLSPCE_STREAM", LOG, new Object[0]);
            throw new ToolException(message, (Throwable)ex);
        }
    }

    public ToolSpec(Document d) {
        if (d == null) {
            throw new NullPointerException("Cannot create a ToolSpec object from a null org.w3c.dom.Document");
        }
        this.doc = d;
    }

    public ExtendedDocumentBuilder getDocumentBuilder() {
        return this.builder;
    }

    public boolean isValidInputStream(String id) {
        Element streams = this.getStreams();
        if (streams == null) {
            return false;
        }
        NodeList nl = streams.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "instream");
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!((Element)nl.item(i)).getAttribute("id").equals(id)) continue;
            return true;
        }
        return false;
    }

    public Element getElementById(String id) {
        Element ele = this.doc.getElementById(id);
        if (ele != null) {
            return ele;
        }
        XPathUtils xpather = new XPathUtils(new HashMap<String, String>());
        NodeList nl = (NodeList)xpather.getValue("//*[@id='" + id + "']", this.doc, XPathConstants.NODESET);
        if (nl != null && nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public boolean hasHandler() {
        return this.doc.getDocumentElement().hasAttribute("handler");
    }

    public Tool getHandler() throws ToolException {
        if (!this.hasHandler()) {
            return null;
        }
        if (this.handler == null) {
            String handlerClz = this.doc.getDocumentElement().getAttribute("handler");
            try {
                this.handler = (Tool)Class.forName(handlerClz).newInstance();
            }
            catch (Exception ex) {
                Message message = new Message("FAIL_TO_INSTANTIATE_HANDLER", LOG, handlerClz);
                throw new ToolException(message, (Throwable)ex);
            }
        }
        return this.handler;
    }

    public Tool getHandler(ClassLoader loader) throws ToolException {
        if (!this.hasHandler()) {
            return null;
        }
        if (this.handler == null) {
            String handlerClz = this.doc.getDocumentElement().getAttribute("handler");
            try {
                this.handler = (Tool)Class.forName(handlerClz, true, loader).newInstance();
            }
            catch (Exception ex) {
                Message message = new Message("FAIL_TO_INSTANTIATE_HANDLER", LOG, handlerClz);
                throw new ToolException(message, (Throwable)ex);
            }
        }
        return this.handler;
    }

    public Element getStreams() {
        NodeList nl = this.doc.getDocumentElement().getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "streams");
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public List getInstreamIds() {
        ArrayList<String> res = new ArrayList<String>();
        Element streams = this.getStreams();
        if (streams != null) {
            NodeList nl = streams.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "instream");
            for (int i = 0; i < nl.getLength(); ++i) {
                res.add(((Element)nl.item(i)).getAttribute("id"));
            }
        }
        return Collections.unmodifiableList(res);
    }

    public List getOutstreamIds() {
        ArrayList<String> res = new ArrayList<String>();
        Element streams = this.getStreams();
        if (streams != null) {
            NodeList nl = streams.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "outstream");
            for (int i = 0; i < nl.getLength(); ++i) {
                res.add(((Element)nl.item(i)).getAttribute("id"));
            }
        }
        return Collections.unmodifiableList(res);
    }

    public Element getUsage() {
        return (Element)this.doc.getDocumentElement().getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "usage").item(0);
    }

    public void transform(InputStream stylesheet, OutputStream out) throws TransformerException {
        Transformer trans = TransformerFactory.newInstance().newTransformer(new StreamSource(stylesheet));
        trans.transform(new DOMSource(this.doc), new StreamResult(out));
    }

    public Element getPipeline() {
        NodeList nl = this.doc.getDocumentElement().getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "pipeline");
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public NodeList getUsageForms() {
        return this.getUsage().getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "form");
    }

    public String getStreamRefName(String streamId) {
        if (this.getUsage() != null) {
            int i;
            NodeList nl = this.getUsage().getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "associatedArgument");
            for (i = 0; i < nl.getLength(); ++i) {
                if (!((Element)nl.item(i)).getAttribute("streamref").equals(streamId)) continue;
                return ((Element)nl.item(i).getParentNode()).getAttribute("id");
            }
            nl = this.getUsage().getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "argument");
            for (i = 0; i < nl.getLength(); ++i) {
                if (!((Element)nl.item(i)).getAttribute("streamref").equals(streamId)) continue;
                return ((Element)nl.item(i)).getAttribute("id");
            }
        }
        return null;
    }

    public String getParameterDefault(String name) {
        Element el = this.getElementById(name);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Element with id " + name + " is " + el);
        }
        if (el != null) {
            Element assArg;
            NodeList assArgs;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("local name is " + el.getLocalName());
            }
            if ("argument".equals(el.getLocalName())) {
                if (el.hasAttribute("default")) {
                    return el.getAttribute("default");
                }
            } else if ("option".equals(el.getLocalName()) && (assArgs = el.getElementsByTagNameNS("http://cxf.apache.org/Xpipe/ToolSpecification", "associatedArgument")).getLength() > 0 && (assArg = (Element)assArgs.item(0)).hasAttribute("default")) {
                return assArg.getAttribute("default");
            }
        }
        return null;
    }

    public String getAnnotation() {
        String result = null;
        Element element = this.doc.getDocumentElement();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1 || !"annotation".equals(list.item(i).getNodeName())) continue;
            result = list.item(i).getFirstChild().getNodeValue();
            break;
        }
        return result;
    }
}

