/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.annotator.WrapperBeanAnnotator;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.annotator.WrapperBeanFieldAnnotator;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
import org.apache.cxf.tools.util.AnnotationUtil;
import org.apache.cxf.tools.util.NameUtil;
import org.apache.cxf.tools.util.URIParserUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wrapper {
    private static final Logger LOG = LogUtils.getL7dLogger(Wrapper.class);
    private QName name;
    private WrapperBeanClass javaClass;
    private Method method;
    private boolean isSamePackage;
    private OperationInfo operationInfo;
    private String className;

    public void setOperationInfo(OperationInfo op) {
        this.operationInfo = op;
        this.setMethod((Method)op.getProperty("operation.method"));
    }

    public void setMethod(Method m) {
        this.method = m;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public void setClassName(String s) {
        this.className = s;
    }

    public String getClassName() {
        return this.className;
    }

    public WrapperBeanClass getWrapperBeanClass(Method m) {
        return new WrapperBeanClass();
    }

    protected WrapperBeanClass getWrapperBeanClass(QName wrapperBeanName) {
        WrapperBeanClass jClass = new WrapperBeanClass();
        if (wrapperBeanName == null) {
            return jClass;
        }
        String ns = wrapperBeanName.getNamespaceURI();
        jClass.setNamespace(ns);
        jClass.setPackageName(URIParserUtil.getPackageName(ns));
        jClass.setName(NameUtil.mangleNameToClassName(wrapperBeanName.getLocalPart()));
        jClass.setElementName(wrapperBeanName);
        return jClass;
    }

    private WrapperBeanClass merge(WrapperBeanClass c1, WrapperBeanClass c2) {
        if (c1.getElementName() == null) {
            c1.setElementName(c2.getElementName());
        }
        if (StringUtils.isEmpty(c1.getNamespace())) {
            c1.setNamespace(c2.getNamespace());
        }
        if (StringUtils.isEmpty(c1.getPackageName())) {
            c1.setPackageName(c2.getPackageName());
        } else {
            this.isSamePackage = c1.getPackageName().equals(c2.getPackageName());
        }
        if (StringUtils.isEmpty(c1.getName())) {
            c1.setName(c2.getName());
        }
        return c1;
    }

    public WrapperBeanClass getJavaClass() {
        if (this.javaClass == null) {
            WrapperBeanClass jClass1 = this.getWrapperBeanClass(this.name);
            WrapperBeanClass jClass2 = this.getWrapperBeanClass(this.method);
            this.javaClass = this.merge(jClass2, jClass1);
        }
        return this.javaClass;
    }

    public WrapperBeanClass buildWrapperBeanClass() {
        WrapperBeanClass jClass = this.getJavaClass();
        List<JavaField> fields = this.buildFields();
        for (JavaField field : fields) {
            field.setOwner(jClass);
            field.annotate(new WrapperBeanFieldAnnotator());
            jClass.addField(field);
            jClass.appendGetter(field);
            jClass.appendSetter(field);
        }
        jClass.annotate(new WrapperBeanAnnotator());
        return jClass;
    }

    protected String getPackageName(Method m) {
        Package pkg = m.getDeclaringClass().getPackage();
        if (pkg == null) {
            return "defaultnamespace";
        }
        return pkg.getName();
    }

    public boolean isWrapperAbsent() {
        return this.isWrapperAbsent(this.method);
    }

    public boolean isWrapperAbsent(Method m) {
        return false;
    }

    public boolean isWrapperBeanClassNotExist() {
        try {
            Message msg = new Message("LOADING_WRAPPER_CLASS", LOG, this.getJavaClass().getFullClassName());
            LOG.log(Level.INFO, msg.toString());
            this.getWrapperClass();
            return false;
        }
        catch (ToolException e) {
            return true;
        }
    }

    public boolean isToDifferentPackage() {
        return !this.isSamePackage;
    }

    public Class getWrapperClass() {
        try {
            return AnnotationUtil.loadClass(this.getJavaClass().getFullClassName(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            Message msg = new Message("LOAD_WRAPPER_CLASS_FAILED", LOG, this.getJavaClass().getFullClassName());
            LOG.log(Level.WARNING, msg.toString());
            throw new ToolException(msg);
        }
    }

    protected boolean isBuiltInTypes(Class<?> clz) {
        if (clz == null || clz.isPrimitive()) {
            return true;
        }
        if (clz.getPackage() == null) {
            return false;
        }
        return "java.lang".equals(clz.getPackage().getName());
    }

    protected List<JavaField> buildFields() {
        return new ArrayList<JavaField>();
    }

    public Method getMethod() {
        return this.method;
    }

    public OperationInfo getOperationInfo() {
        return this.operationInfo;
    }
}

