/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.spring;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.spring.TLSServerParametersConfig;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.http_jetty.spring.JAXBHelper;
import org.apache.cxf.transports.http_jetty.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersType;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHTTPServerEngineFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String HTTP_JETTY_NS = "http://cxf.apache.org/transports/http-jetty/configuration";

    @Override
    public void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        String bus = element.getAttribute("bus");
        try {
            List list;
            List<ThreadingParametersIdentifiedType> threadingParametersIdentifiedTypes = JAXBHelper.parseListElement(element, bean, new QName(HTTP_JETTY_NS, "identifiedThreadingParameters"), ThreadingParametersIdentifiedType.class);
            Map<String, ThreadingParameters> threadingParametersMap = this.toThreadingParameters(threadingParametersIdentifiedTypes);
            List<TLSServerParametersIdentifiedType> tlsServerParameters = JAXBHelper.parseListElement(element, bean, new QName(HTTP_JETTY_NS, "identifiedTLSServerParameters"), TLSServerParametersIdentifiedType.class);
            Map<String, TLSServerParameters> tlsServerParametersMap = this.toTLSServerParamenters(tlsServerParameters);
            bean.addPropertyValue("threadingParametersMap", threadingParametersMap);
            bean.addPropertyValue("tlsServerParametersMap", tlsServerParametersMap);
            if (StringUtils.isEmpty(bus)) {
                if (ctx.getRegistry().containsBeanDefinition("cxf")) {
                    bean.addPropertyReference("bus", "cxf");
                }
            } else {
                bean.addPropertyReference("bus", bus);
            }
            if ((list = this.getRequiredElementsList(element, ctx, new QName(HTTP_JETTY_NS, "engine"), bean)).size() > 0) {
                bean.addPropertyValue("enginesList", (Object)list);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
    }

    private List getRequiredElementsList(Element parent, ParserContext ctx, QName name, BeanDefinitionBuilder bean) {
        NodeList nl = parent.getChildNodes();
        ManagedList list = new ManagedList(nl.getLength());
        list.setSource(ctx.extractSource((Object)parent));
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !name.getLocalPart().equals(n.getLocalName()) || !name.getNamespaceURI().equals(n.getNamespaceURI())) continue;
            list.add(ctx.getDelegate().parsePropertySubElement((Element)n, (BeanDefinition)bean.getBeanDefinition()));
        }
        return list;
    }

    private Map<String, ThreadingParameters> toThreadingParameters(List<ThreadingParametersIdentifiedType> list) {
        TreeMap<String, ThreadingParameters> map = new TreeMap<String, ThreadingParameters>();
        for (ThreadingParametersIdentifiedType t : list) {
            ThreadingParameters parameter = this.toThreadingParameters(t.getThreadingParameters());
            map.put(t.getId(), parameter);
        }
        return map;
    }

    private ThreadingParameters toThreadingParameters(ThreadingParametersType paramtype) {
        ThreadingParameters params = new ThreadingParameters();
        params.setMaxThreads(paramtype.getMaxThreads());
        params.setMinThreads(paramtype.getMinThreads());
        return params;
    }

    private Map<String, TLSServerParameters> toTLSServerParamenters(List<TLSServerParametersIdentifiedType> list) {
        TreeMap<String, TLSServerParameters> map = new TreeMap<String, TLSServerParameters>();
        for (TLSServerParametersIdentifiedType t : list) {
            try {
                TLSServerParametersConfig parameter = new TLSServerParametersConfig(t.getTlsServerParameters());
                map.put(t.getId(), parameter);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not configure TLS for id " + t.getId(), e);
            }
        }
        return map;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    @Override
    protected Class getBeanClass(Element arg0) {
        return JettyHTTPServerEngineFactory.class;
    }
}

