/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.workqueue;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.management.JMException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.AutomaticWorkQueueImpl;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.workqueue.WorkQueueManagerImplMBeanWrapper;

public class WorkQueueManagerImpl
implements WorkQueueManager {
    private static final Logger LOG = LogUtils.getL7dLogger(WorkQueueManagerImpl.class);
    WorkQueueManager.ThreadingModel threadingModel = WorkQueueManager.ThreadingModel.MULTI_THREADED;
    AutomaticWorkQueue autoQueue;
    boolean inShutdown;
    Bus bus;

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension(this, WorkQueueManager.class);
        }
    }

    public synchronized AutomaticWorkQueue getAutomaticWorkQueue() {
        if (this.autoQueue == null) {
            this.autoQueue = this.createAutomaticWorkQueue();
            InstrumentationManager manager = this.bus.getExtension(InstrumentationManager.class);
            if (null != manager) {
                try {
                    manager.register(new WorkQueueManagerImplMBeanWrapper(this));
                }
                catch (JMException jmex) {
                    LOG.log(Level.WARNING, jmex.getMessage(), jmex);
                }
            }
        }
        return this.autoQueue;
    }

    public WorkQueueManager.ThreadingModel getThreadingModel() {
        return this.threadingModel;
    }

    public void setThreadingModel(WorkQueueManager.ThreadingModel model) {
        this.threadingModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean processRemainingTasks) {
        this.inShutdown = true;
        if (this.autoQueue != null) {
            this.autoQueue.shutdown(processRemainingTasks);
        }
        WorkQueueManagerImpl workQueueManagerImpl = this;
        synchronized (workQueueManagerImpl) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        WorkQueueManagerImpl workQueueManagerImpl = this;
        synchronized (workQueueManagerImpl) {
            while (!this.inShutdown) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            while (this.autoQueue != null && !this.autoQueue.isShutdown()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
        }
        for (Handler h : LOG.getHandlers()) {
            h.flush();
        }
    }

    private AutomaticWorkQueue createAutomaticWorkQueue() {
        int initialThreads = 1;
        int lwm = 5;
        int hwm = 25;
        int maxQueueSize = 10 * hwm;
        long dequeueTimeout = 120000L;
        return new AutomaticWorkQueueImpl(maxQueueSize, initialThreads, hwm, lwm, dequeueTimeout);
    }
}

