/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.ClientPolicyInFaultInterceptor;
import org.apache.cxf.ws.policy.ClientPolicyInInterceptor;
import org.apache.cxf.ws.policy.ClientPolicyOutInterceptor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EffectivePolicyImpl;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.PolicyRegistryImpl;
import org.apache.cxf.ws.policy.PolicyVerificationInFaultInterceptor;
import org.apache.cxf.ws.policy.PolicyVerificationInInterceptor;
import org.apache.cxf.ws.policy.PolicyVerificationOutInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyInInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyOutFaultInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyOutInterceptor;
import org.apache.cxf.ws.policy.selector.MinimalAlternativeSelector;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyEngineImpl
implements PolicyEngine,
BusExtension,
ServerLifeCycleListener {
    private Bus bus;
    private PolicyRegistry registry;
    private Collection<PolicyProvider> policyProviders;
    private boolean enabled;
    private boolean ignoreUnknownAssertions;
    private boolean addedBusInterceptors;
    private AlternativeSelector alternativeSelector;
    private Map<BindingOperation, EffectivePolicy> clientRequestInfo;
    private Map<BindingOperation, EffectivePolicy> clientResponseInfo;
    private Map<BindingFault, EffectivePolicy> clientFaultInfo;
    private Map<BindingOperation, EffectivePolicy> serverRequestInfo;
    private Map<BindingOperation, EffectivePolicy> serverResponseInfo;
    private Map<BindingFault, EffectivePolicy> serverFaultInfo;
    private Map<EndpointInfo, EndpointPolicy> serverEndpointInfo;
    private Map<EndpointInfo, EndpointPolicy> clientEndpointInfo;

    public PolicyEngineImpl() {
        this.init();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setPolicyProviders(Collection<PolicyProvider> p) {
        this.policyProviders = p;
    }

    public Collection<PolicyProvider> getPolicyProviders() {
        return this.policyProviders;
    }

    public void setRegistry(PolicyRegistry r) {
        this.registry = r;
    }

    @Override
    public PolicyRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public synchronized void setEnabled(boolean e) {
        this.enabled = e;
        if (!this.addedBusInterceptors) {
            this.addBusInterceptors();
        }
    }

    @Override
    public AlternativeSelector getAlternativeSelector() {
        return this.alternativeSelector;
    }

    @Override
    public void setAlternativeSelector(AlternativeSelector as) {
        this.alternativeSelector = as;
    }

    @Override
    public boolean isIgnoreUnknownAssertions() {
        return this.ignoreUnknownAssertions;
    }

    @Override
    public void setIgnoreUnknownAssertions(boolean ignore) {
        this.ignoreUnknownAssertions = ignore;
    }

    @Override
    public Class<?> getRegistrationType() {
        return PolicyEngine.class;
    }

    @Override
    public EffectivePolicy getEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, Conduit c) {
        BindingOperation bo = new BindingOperation(ei, boi);
        EffectivePolicy effectivePolicy = this.clientRequestInfo.get(bo);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (c instanceof Assertor) {
                assertor = (Assertor)((Object)c);
            }
            epi.initialise(ei, bo.getBindingOperation(), this, assertor, true);
            this.clientRequestInfo.put(bo, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        BindingOperation bo = new BindingOperation(ei, boi);
        this.clientRequestInfo.put(bo, ep);
    }

    @Override
    public EffectivePolicy getEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, Destination d) {
        BindingOperation bo = new BindingOperation(ei, boi);
        EffectivePolicy effectivePolicy = this.serverResponseInfo.get(bo);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (d instanceof Assertor) {
                assertor = (Assertor)((Object)d);
            }
            epi.initialise(ei, bo.getBindingOperation(), this, assertor, false);
            this.serverResponseInfo.put(bo, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        BindingOperation bo = new BindingOperation(ei, boi);
        this.serverResponseInfo.put(bo, ep);
    }

    @Override
    public EffectivePolicy getEffectiveServerFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, Destination d) {
        BindingFault bf = new BindingFault(ei, bfi);
        EffectivePolicy effectivePolicy = this.serverFaultInfo.get(bf);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (d instanceof Assertor) {
                assertor = (Assertor)((Object)d);
            }
            epi.initialise(ei, bfi, this, assertor);
            this.serverFaultInfo.put(bf, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveServerFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        BindingFault bf = new BindingFault(ei, bfi);
        this.serverFaultInfo.put(bf, ep);
    }

    @Override
    public EndpointPolicy getClientEndpointPolicy(EndpointInfo ei, Conduit conduit) {
        Assertor assertor = conduit instanceof Assertor ? (Assertor)((Object)conduit) : null;
        return this.getEndpointPolicy(ei, this.clientEndpointInfo.get(ei), true, assertor);
    }

    @Override
    public EndpointPolicy getServerEndpointPolicy(EndpointInfo ei, Destination destination) {
        Assertor assertor = destination instanceof Assertor ? (Assertor)((Object)destination) : null;
        return this.getEndpointPolicy(ei, this.serverEndpointInfo.get(ei), false, assertor);
    }

    private EndpointPolicy getEndpointPolicy(EndpointInfo ei, EndpointPolicy ep, boolean isRequestor, Assertor assertor) {
        if (null != ep) {
            return ep;
        }
        return this.createEndpointPolicyInfo(ei, isRequestor, assertor);
    }

    @Override
    public void setClientEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        this.clientEndpointInfo.put(ei, ep);
    }

    @Override
    public void setServerEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        this.serverEndpointInfo.put(ei, ep);
    }

    @Override
    public EffectivePolicy getEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi) {
        BindingOperation bo = new BindingOperation(ei, boi);
        EffectivePolicy effectivePolicy = this.serverRequestInfo.get(bo);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialisePolicy(ei, bo.getBindingOperation(), this, false);
            this.serverRequestInfo.put(bo, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        BindingOperation bo = new BindingOperation(ei, boi);
        this.serverRequestInfo.put(bo, ep);
    }

    @Override
    public EffectivePolicy getEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi) {
        BindingOperation bo = new BindingOperation(ei, boi);
        EffectivePolicy effectivePolicy = this.clientResponseInfo.get(bo);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialisePolicy(ei, bo.getBindingOperation(), this, true);
            this.clientResponseInfo.put(bo, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        BindingOperation bo = new BindingOperation(ei, boi);
        this.clientResponseInfo.put(bo, ep);
    }

    @Override
    public EffectivePolicy getEffectiveClientFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi) {
        BindingFault bf = new BindingFault(ei, bfi);
        EffectivePolicy effectivePolicy = this.clientFaultInfo.get(bf);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialisePolicy(ei, bfi, this);
            this.clientFaultInfo.put(bf, epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveClientFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        BindingFault bf = new BindingFault(ei, bfi);
        this.clientFaultInfo.put(bf, ep);
    }

    protected final void init() {
        this.registry = new PolicyRegistryImpl();
        this.clientRequestInfo = new ConcurrentHashMap<BindingOperation, EffectivePolicy>();
        this.clientResponseInfo = new ConcurrentHashMap<BindingOperation, EffectivePolicy>();
        this.clientFaultInfo = new ConcurrentHashMap<BindingFault, EffectivePolicy>();
        this.serverEndpointInfo = new EndpointPolicyMap();
        this.clientEndpointInfo = new EndpointPolicyMap();
        this.serverRequestInfo = new ConcurrentHashMap<BindingOperation, EffectivePolicy>();
        this.serverResponseInfo = new ConcurrentHashMap<BindingOperation, EffectivePolicy>();
        this.serverFaultInfo = new ConcurrentHashMap<BindingFault, EffectivePolicy>();
    }

    @PostConstruct
    public void addBusInterceptors() {
        if (null == this.alternativeSelector) {
            this.alternativeSelector = new MinimalAlternativeSelector();
        }
        if (null == this.bus || !this.enabled) {
            return;
        }
        AssertionBuilderRegistry abr = this.bus.getExtension(AssertionBuilderRegistry.class);
        if (null != abr) {
            abr.setIgnoreUnknownAssertions(this.ignoreUnknownAssertions);
        }
        ClientPolicyOutInterceptor clientOut = new ClientPolicyOutInterceptor();
        clientOut.setBus(this.bus);
        this.bus.getOutInterceptors().add(clientOut);
        ClientPolicyInInterceptor clientIn = new ClientPolicyInInterceptor();
        clientIn.setBus(this.bus);
        this.bus.getInInterceptors().add(clientIn);
        ClientPolicyInFaultInterceptor clientInFault = new ClientPolicyInFaultInterceptor();
        clientInFault.setBus(this.bus);
        this.bus.getInFaultInterceptors().add(clientInFault);
        ServerPolicyInInterceptor serverIn = new ServerPolicyInInterceptor();
        serverIn.setBus(this.bus);
        this.bus.getInInterceptors().add(serverIn);
        ServerPolicyOutInterceptor serverOut = new ServerPolicyOutInterceptor();
        serverOut.setBus(this.bus);
        this.bus.getOutInterceptors().add(serverOut);
        ServerPolicyOutFaultInterceptor serverOutFault = new ServerPolicyOutFaultInterceptor();
        serverOutFault.setBus(this.bus);
        this.bus.getOutFaultInterceptors().add(serverOutFault);
        PolicyVerificationOutInterceptor verifyOut = new PolicyVerificationOutInterceptor();
        verifyOut.setBus(this.bus);
        this.bus.getOutInterceptors().add(verifyOut);
        PolicyVerificationInInterceptor verifyIn = new PolicyVerificationInInterceptor();
        verifyIn.setBus(this.bus);
        this.bus.getInInterceptors().add(verifyIn);
        PolicyVerificationInFaultInterceptor verifyInFault = new PolicyVerificationInFaultInterceptor();
        verifyInFault.setBus(this.bus);
        this.bus.getInFaultInterceptors().add(verifyInFault);
        this.addedBusInterceptors = true;
    }

    @PostConstruct
    public void registerListener() {
        ServerLifeCycleManager slm = this.bus.getExtension(ServerLifeCycleManager.class);
        if (slm != null) {
            slm.registerListener(this);
        }
    }

    Policy getAggregatedServicePolicy(ServiceInfo si) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(si);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedEndpointPolicy(EndpointInfo ei) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(ei);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedOperationPolicy(BindingOperationInfo boi) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(boi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedMessagePolicy(BindingMessageInfo bmi) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bmi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedFaultPolicy(BindingFaultInfo bfi) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bfi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Collection<Assertion> getAssertions(PolicyComponent pc, boolean includeOptional) {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (5 == pc.getType()) {
            Assertion a = (Assertion)pc;
            if (includeOptional || !a.isOptional()) {
                assertions.add(a);
            }
        } else {
            this.addAssertions(pc, includeOptional, assertions);
        }
        return assertions;
    }

    void addAssertions(PolicyComponent pc, boolean includeOptional, Collection<Assertion> assertions) {
        if (5 == pc.getType()) {
            Assertion a = (Assertion)pc;
            if (includeOptional || !a.isOptional()) {
                assertions.add((Assertion)pc);
            }
            return;
        }
        if (4 == pc.getType()) {
            PolicyReference pr = (PolicyReference)pc;
            pc = pr.normalize(this.registry, false);
        }
        PolicyOperator po = (PolicyOperator)pc;
        List<PolicyComponent> pcs = CastUtils.cast(po.getPolicyComponents(), PolicyComponent.class);
        for (PolicyComponent child : pcs) {
            this.addAssertions(child, includeOptional, assertions);
        }
    }

    Set<QName> getVocabulary(PolicyComponent pc, boolean includeOptional) {
        Collection<Assertion> assertions = this.getAssertions(pc, includeOptional);
        HashSet<QName> vocabulary = new HashSet<QName>();
        for (Assertion a : assertions) {
            vocabulary.add(a.getName());
        }
        return vocabulary;
    }

    EndpointPolicyImpl createEndpointPolicyInfo(EndpointInfo ei, boolean isRequestor, Assertor assertor) {
        EndpointPolicyImpl epi = new EndpointPolicyImpl(ei, this, isRequestor, assertor);
        epi.initialize();
        Map<EndpointInfo, EndpointPolicy> map = isRequestor ? this.clientEndpointInfo : this.serverEndpointInfo;
        map.put(ei, epi);
        return epi;
    }

    @Override
    public boolean supportsAlternative(Collection<Assertion> alternative, Assertor assertor) {
        PolicyInterceptorProviderRegistry pipr = this.bus.getExtension(PolicyInterceptorProviderRegistry.class);
        for (Assertion a : alternative) {
            if (a.isOptional() || null != pipr.get(a.getName()) || null != assertor && assertor.canAssert(a.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void startServer(Server server) {
    }

    @Override
    public void stopServer(Server server) {
        EndpointInfo ei = server.getEndpoint().getEndpointInfo();
        this.serverEndpointInfo.remove(ei);
        this.cleanupBindingOperations(ei, this.clientRequestInfo);
        this.cleanupBindingOperations(ei, this.clientResponseInfo);
        this.cleanupBindingOperations(ei, this.serverRequestInfo);
        this.cleanupBindingOperations(ei, this.serverResponseInfo);
        this.cleanupBindingFaults(ei, this.clientFaultInfo);
        this.cleanupBindingFaults(ei, this.serverFaultInfo);
    }

    private void cleanupBindingOperations(EndpointInfo ei, Map<BindingOperation, EffectivePolicy> originalMap) {
        for (BindingOperation bindingOperation : originalMap.keySet()) {
            if (!ei.isSameAs(bindingOperation.getEndpoint())) continue;
            originalMap.remove(bindingOperation);
        }
    }

    private void cleanupBindingFaults(EndpointInfo ei, Map<BindingFault, EffectivePolicy> originalMap) {
        for (BindingFault bindingFault : originalMap.keySet()) {
            if (!ei.isSameAs(bindingFault.getEndpoint())) continue;
            originalMap.remove(bindingFault);
        }
    }

    EffectivePolicyImpl createOutPolicyInfo() {
        return new EffectivePolicyImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EndpointPolicyMap
    extends ConcurrentHashMap<EndpointInfo, EndpointPolicy> {
        private EndpointPolicyMap() {
        }

        @Override
        public EndpointPolicy remove(Object key) {
            EndpointInfo toRemove = (EndpointInfo)key;
            EndpointPolicy pol = null;
            for (EndpointInfo info : this.keySet()) {
                if (!info.isSameAs(toRemove)) continue;
                pol = (EndpointPolicy)super.remove(info);
            }
            return pol;
        }
    }

    class BindingFault {
        private EndpointInfo ei;
        private BindingFaultInfo bfi;

        BindingFault(EndpointInfo e, BindingFaultInfo b) {
            this.ei = e;
            this.bfi = b;
        }

        EndpointInfo getEndpoint() {
            return this.ei;
        }

        BindingFaultInfo getBindingFault() {
            return this.bfi;
        }

        public int hashCode() {
            return this.bfi.hashCode();
        }

        public boolean equals(Object obj) {
            BindingFault other = (BindingFault)obj;
            return this.bfi.equals(other.bfi) && this.ei.equals(other.ei);
        }

        public String toString() {
            return this.ei.getName().toString() + "." + this.bfi.getFaultInfo().toString();
        }
    }

    class BindingOperation {
        private EndpointInfo ei;
        private BindingOperationInfo boi;

        BindingOperation(EndpointInfo e, BindingOperationInfo b) {
            this.ei = e;
            this.boi = b.isUnwrapped() ? b.getWrappedOperation() : b;
        }

        EndpointInfo getEndpoint() {
            return this.ei;
        }

        BindingOperationInfo getBindingOperation() {
            return this.boi;
        }

        public int hashCode() {
            return this.boi.hashCode();
        }

        public boolean equals(Object obj) {
            BindingOperation other = (BindingOperation)obj;
            return this.boi.equals(other.boi) && this.ei.equals(other.ei);
        }

        public String toString() {
            return this.ei.getName().toString() + "." + this.boi.getName().toString();
        }
    }
}

