/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regex) - Splits `str` around occurrences that match `regex`.", extended="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001>\u00111b\u0015;sS:<7\u000b\u001d7ji*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005\u00191\u000f\u001e:\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0003tiJ\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u000fA\fG\u000f^3s]\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0005qCR$XM\u001d8!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0019q\u0006M\u0019\u0011\u0005E\u0001\u0001\"B\u0011-\u0001\u0004\u0019\u0003\"B\u0015-\u0001\u0004\u0019\u0003\"B\u001a\u0001\t\u0003\u0012\u0013\u0001\u00027fMRDQ!\u000e\u0001\u0005B\t\nQA]5hQRDQa\u000e\u0001\u0005Ba\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011AHB\u0001\u0006if\u0004Xm]\u0005\u0003}m\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\u0006\u0001\u0002!\t%Q\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001\"\u0011\u0007\r[\u0015H\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011qID\u0001\u0007yI|w\u000e\u001e \n\u0003iI!AS\r\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\u0004'\u0016\f(B\u0001&\u001a\u0011\u0015y\u0005\u0001\"\u0011Q\u00031qW\u000f\u001c7TC\u001a,WI^1m)\r\tFK\u0016\t\u00031IK!aU\r\u0003\u0007\u0005s\u0017\u0010C\u0003V\u001d\u0002\u0007\u0011+\u0001\u0004tiJLgn\u001a\u0005\u0006/:\u0003\r!U\u0001\u0006e\u0016<W\r\u001f\u0005\u00063\u0002!\tEW\u0001\nI><UM\\\"pI\u0016$2aW1g!\tav,D\u0001^\u0015\tq&!A\u0004d_\u0012,w-\u001a8\n\u0005\u0001l&\u0001C#yaJ\u001cu\u000eZ3\t\u000b\tD\u0006\u0019A2\u0002\u0007\r$\b\u0010\u0005\u0002]I&\u0011Q-\u0018\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u00159\u0007\f1\u0001\\\u0003\t)g\u000fC\u0003j\u0001\u0011\u0005#.\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012a\u001b\t\u0003Y>t!\u0001G7\n\u00059L\u0012A\u0002)sK\u0012,g-\u0003\u0002qc\n11\u000b\u001e:j]\u001eT!A\\\r\t\u000fM\u0004\u0011\u0011!C\u0001i\u0006!1m\u001c9z)\rySO\u001e\u0005\bCI\u0004\n\u00111\u0001$\u0011\u001dI#\u000f%AA\u0002\rBq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u00110\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003iT#aI>,\u0003q\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007I\u0012AC1o]>$\u0018\r^5p]&\u0019\u0011q\u0001@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0005\u0002\f\u0001\t\n\u0011\"\u0001z\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"a\u0004\u0001\u0003\u0003%\t%!\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\t1\fgn\u001a\u0006\u0003\u0003;\tAA[1wC&\u0019\u0001/a\u0006\t\u0013\u0005\r\u0002!!A\u0005\u0002\u0005\u0015\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0014!\rA\u0012\u0011F\u0005\u0004\u0003WI\"aA%oi\"I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0011\u0011G\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\t\u00161\u0007\u0005\u000b\u0003k\ti#!AA\u0002\u0005\u001d\u0012a\u0001=%c!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00131H\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\b\t\u0006\u0003\u007f\t)%U\u0007\u0003\u0003\u0003R1!a\u0011\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\n\tE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tY\u0005AA\u0001\n\u0003\ti%\u0001\u0005dC:,\u0015/^1m)\u0011\ty%!\u0016\u0011\u0007a\t\t&C\u0002\u0002Te\u0011qAQ8pY\u0016\fg\u000eC\u0005\u00026\u0005%\u0013\u0011!a\u0001#\"I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00131L\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\u0013Q\f\u0005\n\u0003k\t9&!AA\u0002EC3\u0002AA1\u0003O\nI'!\u001c\u0002pA\u0019\u0011#a\u0019\n\u0007\u0005\u0015$AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005-\u0014\u0001S0G+:\u001bu\fK:ue2\u0002#/Z4fq&\u0002S\u0006I*qY&$8\u000f\t1tiJ\u0004\u0007%\u0019:pk:$\u0007e\\2dkJ\u0014XM\\2fg\u0002\"\b.\u0019;![\u0006$8\r\u001b\u0011ae\u0016<W\r\u001f1/\u0003!)\u0007\u0010^3oI\u0016$\u0017EAA9\u0003\rT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ8oK\u0006#xo\u001c\"uQJ,WmQ\u0014-A\u001dZ\u0016IQ\"^O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012p]\u0016\u0014CF\t;x_\nb#\u0005\u001e5sK\u0016\u0014CF\t\u0012^\u0015\u0001\u0002s!CA;\u0005\u0005\u0005\t\u0012AA<\u0003-\u0019FO]5oON\u0003H.\u001b;\u0011\u0007E\tIH\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA>'\u0015\tI(! \u001e!\u001d\ty(!\"$G=j!!!!\u000b\u0007\u0005\r\u0015$A\u0004sk:$\u0018.\\3\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\u0017\u0002z\u0011\u0005\u00111\u0012\u000b\u0003\u0003oB!\"a$\u0002z\u0005\u0005IQIAI\u0003!!xn\u0015;sS:<GCAA\n\u0011)\t)*!\u001f\u0002\u0002\u0013\u0005\u0015qS\u0001\u0006CB\u0004H.\u001f\u000b\u0006_\u0005e\u00151\u0014\u0005\u0007C\u0005M\u0005\u0019A\u0012\t\r%\n\u0019\n1\u0001$\u0011)\ty*!\u001f\u0002\u0002\u0013\u0005\u0015\u0011U\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019+a,\u0011\u000ba\t)+!+\n\u0007\u0005\u001d\u0016D\u0001\u0004PaRLwN\u001c\t\u00061\u0005-6eI\u0005\u0004\u0003[K\"A\u0002+va2,'\u0007C\u0005\u00022\u0006u\u0015\u0011!a\u0001_\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005U\u0016\u0011PA\u0001\n\u0013\t9,A\u0006sK\u0006$'+Z:pYZ,GCAA]!\u0011\t)\"a/\n\t\u0005u\u0016q\u0003\u0002\u0007\u001f\nTWm\u0019;")
public class StringSplit
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression str;
    private final Expression pattern;

    public static Function1<Tuple2<Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringSplit>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pattern() {
        return this.pattern;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.pattern();
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object string, Object regex) {
        UTF8String[] strings = ((UTF8String)string).split((UTF8String)regex, -1);
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, arrayClass){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$3;
            private final String arrayClass$1;

            public final String apply(String str, String pattern) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = new ", "(", ".split(", ", -1));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ev$3.value(), this.arrayClass$1, str, pattern}));
            }
            {
                this.ev$3 = ev$3;
                this.arrayClass$1 = arrayClass$1;
            }
        });
    }

    @Override
    public String prettyName() {
        return "split";
    }

    public StringSplit copy(Expression str, Expression pattern) {
        return new StringSplit(str, pattern);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pattern();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.pattern();
                break;
            }
            case 0: {
                expression = this.str();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pattern();
        Expression expression4 = stringSplit.pattern();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression pattern) {
        this.str = str;
        this.pattern = pattern;
        ExpectsInputTypes$class.$init$(this);
    }
}

