/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io.cloud;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.internal.io.cloud.BindingParquetOutputCommitter;
import org.apache.spark.internal.io.cloud.PathOutputCommitProtocol;
import org.apache.spark.internal.io.cloud.PathOutputCommitProtocol$;
import org.apache.spark.internal.io.cloud.StubPathOutputCommitter;
import org.apache.spark.internal.io.cloud.StubPathOutputCommitterFactory$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0004\b\u00017!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003B\u0002\u0018\u0001A\u0003%a\u0005C\u00040\u0001\t\u0007I\u0011B\u0013\t\rA\u0002\u0001\u0015!\u0003'\u0011\u001d\t\u0004A1A\u0005\nIBaa\u000f\u0001!\u0002\u0013\u0019\u0004b\u0002\u001f\u0001\u0005\u0004%I!\u0010\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002 \t\u000f-\u0003!\u0019!C\u0005K!1A\n\u0001Q\u0001\n\u0019BQ!\u0014\u0001\u0005\u00029\u0013QcQ8n[&$H/\u001a:CS:$\u0017N\\4Tk&$XM\u0003\u0002\u0010!\u0005)1\r\\8vI*\u0011\u0011CE\u0001\u0003S>T!a\u0005\u000b\u0002\u0011%tG/\u001a:oC2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001e=5\tA#\u0003\u0002 )\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\b\u0002\u000b)|'-\u00133\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgnZ\u0001\u0007U>\u0014\u0017\n\u001a\u0011\u0002\u0019Q\f7o[!ui\u0016l\u0007\u000f\u001e\u0019\u0002\u001bQ\f7o[!ui\u0016l\u0007\u000f\u001e\u0019!\u00039!\u0018m]6BiR,W\u000e\u001d;JIB*\u0012a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\n\u0011\"\\1qe\u0016$WoY3\u000b\u0005a2\u0012A\u00025bI>|\u0007/\u0003\u0002;k\tiA+Y:l\u0003R$X-\u001c9u\u0013\u0012\u000bq\u0002^1tW\u0006#H/Z7qi&#\u0007\u0007I\u0001\u001ca\u0006$\bnQ8n[&$\bK]8u_\u000e|Gn\u00117bgNt\u0017-\\3\u0016\u0003y\u0002\"a\u0010%\u000f\u0005\u00013\u0005CA!E\u001b\u0005\u0011%BA\"\u001b\u0003\u0019a$o\\8u})\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\u00061\u0001K]3eK\u001aL!!L%\u000b\u0005\u001d#\u0015\u0001\b9bi\"\u001cu.\\7jiB\u0013x\u000e^8d_2\u001cE.Y:t]\u0006lW\rI\u0001\u000egV\u001c7-Z:t\u001b\u0006\u00148.\u001a:\u0002\u001dM,8mY3tg6\u000b'o[3sA\u00051a.Z<K_\n$\"a\u0014*\u0011\u0005Q\u0002\u0016BA)6\u0005\rQuN\u0019\u0005\u0006'2\u0001\r\u0001V\u0001\u0007_V$H)\u001b:\u0011\u0005UCV\"\u0001,\u000b\u0005];\u0014A\u00014t\u0013\tIfK\u0001\u0003QCRD\u0007")
public class CommitterBindingSuite
extends SparkFunSuite {
    private final String jobId;
    private final String taskAttempt0 = new StringBuilder(19).append("attempt_").append(this.jobId()).append("_m_000000_0").toString();
    private final TaskAttemptID taskAttemptId0 = TaskAttemptID.forName((String)this.taskAttempt0());
    private final String pathCommitProtocolClassname = PathOutputCommitProtocol.class.getName();
    private final String successMarker;

    private String jobId() {
        return this.jobId;
    }

    private String taskAttempt0() {
        return this.taskAttempt0;
    }

    private TaskAttemptID taskAttemptId0() {
        return this.taskAttemptId0;
    }

    private String pathCommitProtocolClassname() {
        return this.pathCommitProtocolClassname;
    }

    private String successMarker() {
        return this.successMarker;
    }

    /*
     * WARNING - void declaration
     */
    public Job newJob(Path outDir) {
        void var2_2;
        Job job = Job.getInstance((Configuration)new Configuration());
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", this.taskAttempt0());
        conf.setBoolean(this.successMarker(), true);
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        return var2_2;
    }

    public CommitterBindingSuite() {
        this.jobId = "2007071202143_0101";
        this.successMarker = "mapreduce.fileoutputcommitter.marksuccessfuljobs";
        this.test("BindingParquetOutputCommitter binds to the inner committer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path("http://example/data");
            Job job = this.newJob(path);
            Configuration conf = job.getConfiguration();
            conf.set("mapreduce.task.attempt.id", this.taskAttempt0());
            conf.setInt("mapreduce.job.application.attempt.id", 1);
            StubPathOutputCommitterFactory$.MODULE$.bind(conf, "http");
            TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, this.taskAttemptId0());
            BindingParquetOutputCommitter parquet = new BindingParquetOutputCommitter(path, (TaskAttemptContext)tContext);
            StubPathOutputCommitter inner = (StubPathOutputCommitter)parquet.boundCommitter();
            parquet.setupJob((JobContext)tContext);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(inner.jobSetup(), "inner.jobSetup", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(14).append((Object)inner).append(" job not setup").toString(), Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            parquet.setupTask((TaskAttemptContext)tContext);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(inner.taskSetup(), "inner.taskSetup", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(15).append((Object)inner).append(" task not setup").toString(), Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(parquet.needsTaskCommit((TaskAttemptContext)tContext), "parquet.needsTaskCommit(tContext)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"needsTaskCommit false", Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            inner.needsTaskCommit_$eq(false);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(parquet.needsTaskCommit((TaskAttemptContext)tContext), "parquet.needsTaskCommit(tContext)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"needsTaskCommit true", Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            parquet.commitTask((TaskAttemptContext)tContext);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(inner.taskCommitted(), "inner.taskCommitted", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)new StringBuilder(19).append((Object)inner).append(" task not committed").toString(), Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            parquet.abortTask((TaskAttemptContext)tContext);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(inner.taskAborted(), "inner.taskAborted", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)new StringBuilder(17).append((Object)inner).append(" task not aborted").toString(), Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            parquet.commitJob((JobContext)tContext);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(inner.jobCommitted(), "inner.jobCommitted", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)new StringBuilder(18).append((Object)inner).append(" job not committed").toString(), Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            parquet.abortJob((JobContext)tContext, JobStatus.State.RUNNING);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(inner.jobAborted(), "inner.jobAborted", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)new StringBuilder(16).append((Object)inner).append(" job not aborted").toString(), Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("committer protocol can be serialized and deserialized", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            File tempDir = File.createTempFile("ser", ".bin");
            tempDir.delete();
            PathOutputCommitProtocol committer = new PathOutputCommitProtocol(this.jobId(), tempDir.toURI().toString(), false);
            File serData = File.createTempFile("ser", ".bin");
            ObjectOutputStream out = null;
            ObjectInputStream in = null;
            try {
                out = new ObjectOutputStream(new FileOutputStream(serData));
                out.writeObject(committer);
                out.close();
                in = new ObjectInputStream(new FileInputStream(serData));
                Object result = in.readObject();
                PathOutputCommitProtocol committer2 = (PathOutputCommitProtocol)result;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(committer.destination());
                String $org_scalatest_assert_macro_right = committer2.destination();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"destination mismatch on round trip", Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(committer.destPath());
                Path $org_scalatest_assert_macro_right2 = committer2.destPath();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"destPath mismatch on round trip", Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            }
            catch (Throwable throwable) {
                IOUtils.closeStreams((Closeable[])new Closeable[]{out, in});
                serData.delete();
                throw throwable;
            }
            IOUtils.closeStreams((Closeable[])new Closeable[]{out, in});
            serData.delete();
            return assertion;
        }, new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("local filesystem instantiation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileCommitProtocol instance = FileCommitProtocol$.MODULE$.instantiate(this.pathCommitProtocolClassname(), this.jobId(), "file:///tmp", false);
            PathOutputCommitProtocol protocol = (PathOutputCommitProtocol)instance;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer("file:///tmp");
            String $org_scalatest_assert_macro_right = protocol.destination();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        }, new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("reject dynamic partitioning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Throwable cause = ((InvocationTargetException)this.intercept((Function0 & Serializable & scala.Serializable)() -> FileCommitProtocol$.MODULE$.instantiate(this.pathCommitProtocolClassname(), this.jobId(), "file:///tmp", true), ClassTag$.MODULE$.apply(InvocationTargetException.class), new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134))).getCause();
            if (cause == null || !(cause instanceof IOException) || !cause.getMessage().contains(PathOutputCommitProtocol$.MODULE$.UNSUPPORTED())) {
                throw cause;
            }
            return BoxedUnit.UNIT;
        }, new Position("CommitterBindingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }
}

