/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;

public final class IDFModel$
implements Serializable {
    public static IDFModel$ MODULE$;

    static {
        new IDFModel$();
    }

    public Vector transform(Vector idf, Vector v) {
        DenseVector denseVector;
        Option<double[]> option;
        Vector vector;
        SparseVector sparseVector;
        Option<Tuple3<Object, int[], double[]>> option2;
        Vector vector2 = v;
        if (vector2 instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector2)).isEmpty()) {
            double[] values;
            int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
            int[] indices = (int[])((Tuple3)option2.get())._2();
            Tuple2<int[], double[]> tuple2 = this.transformSparse(idf, indices, values = (double[])((Tuple3)option2.get())._3());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int[] newIndices = (int[])tuple2._1();
            double[] newValues = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newIndices, (Object)newValues);
            Tuple2 tuple23 = tuple22;
            int[] newIndices2 = (int[])tuple23._1();
            double[] newValues2 = (double[])tuple23._2();
            vector = Vectors$.MODULE$.sparse(size, newIndices2, newValues2);
        } else if (vector2 instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector2)).isEmpty()) {
            double[] values = (double[])option.get();
            double[] newValues = this.transformDense(idf, values);
            vector = Vectors$.MODULE$.dense(newValues);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(53).append("Only sparse and dense vectors are supported but got ").append(vector2.getClass()).append(".").toString());
        }
        return vector;
    }

    public double[] transformDense(Vector idf, double[] values) {
        int n = values.length;
        double[] newValues = new double[n];
        for (int j = 0; j < n; ++j) {
            newValues[j] = values[j] * idf.apply(j);
        }
        return newValues;
    }

    public Tuple2<int[], double[]> transformSparse(Vector idf, int[] indices, double[] values) {
        int nnz = indices.length;
        double[] newValues = new double[nnz];
        for (int k = 0; k < nnz; ++k) {
            newValues[k] = values[k] * idf.apply(indices[k]);
        }
        return new Tuple2((Object)indices, (Object)newValues);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private IDFModel$() {
        MODULE$ = this;
    }
}

