/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka;

import java.util.Set;
import kafka.common.TopicAndPartition;
import kafka.message.MessageAndMetadata;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaInputDStream$;
import org.apache.spark.streaming.api.java.JavaPairInputDStream;
import org.apache.spark.streaming.api.java.JavaPairInputDStream$;
import org.apache.spark.streaming.api.java.JavaPairReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaPairReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kafka.Broker;
import org.apache.spark.streaming.kafka.Broker$;
import org.apache.spark.streaming.kafka.DirectKafkaInputDStream;
import org.apache.spark.streaming.kafka.KafkaCluster;
import org.apache.spark.streaming.kafka.KafkaCluster$;
import org.apache.spark.streaming.kafka.KafkaInputDStream;
import org.apache.spark.streaming.kafka.KafkaRDD;
import org.apache.spark.streaming.kafka.KafkaUtils$;
import org.apache.spark.streaming.kafka.KafkaUtils$$anonfun$3$;
import org.apache.spark.streaming.kafka.OffsetRange;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class KafkaUtils$ {
    public static final KafkaUtils$ MODULE$;

    static {
        new KafkaUtils$();
    }

    public ReceiverInputDStream<Tuple2<String, String>> createStream(StreamingContext ssc, String zkQuorum, String groupId, scala.collection.immutable.Map<String, Object> topics, StorageLevel storageLevel) {
        scala.collection.immutable.Map kafkaParams = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"zookeeper.connect"), (Object)zkQuorum), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"group.id"), (Object)groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"zookeeper.connection.timeout.ms"), (Object)"10000")}));
        return this.createStream(ssc, (scala.collection.immutable.Map<String, String>)kafkaParams, topics, storageLevel, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(StringDecoder.class), ClassTag$.MODULE$.apply(StringDecoder.class));
    }

    public <K, V, U extends Decoder<?>, T extends Decoder<?>> ReceiverInputDStream<Tuple2<K, V>> createStream(StreamingContext ssc, scala.collection.immutable.Map<String, String> kafkaParams, scala.collection.immutable.Map<String, Object> topics, StorageLevel storageLevel, ClassTag<K> evidence$1, ClassTag<V> evidence$2, ClassTag<U> evidence$3, ClassTag<T> evidence$4) {
        boolean walEnabled = WriteAheadLogUtils$.MODULE$.enableReceiverLog(ssc.conf());
        return new KafkaInputDStream<K, V, U, T>(ssc, (Map<String, String>)kafkaParams, (Map<String, Object>)topics, walEnabled, storageLevel, evidence$1, evidence$2, evidence$3, evidence$4);
    }

    public JavaPairReceiverInputDStream<String, String> createStream(JavaStreamingContext jssc, String zkQuorum, String groupId, java.util.Map<String, Integer> topics) {
        return JavaPairReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), zkQuorum, groupId, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(topics).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).toSeq())), this.createStream$default$5()), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class));
    }

    public JavaPairReceiverInputDStream<String, String> createStream(JavaStreamingContext jssc, String zkQuorum, String groupId, java.util.Map<String, Integer> topics, StorageLevel storageLevel) {
        return JavaPairReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), zkQuorum, groupId, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(topics).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$2) {
                return x$2;
            }
        }).toSeq())), storageLevel), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class));
    }

    public <K, V, U extends Decoder<?>, T extends Decoder<?>> JavaPairReceiverInputDStream<K, V> createStream(JavaStreamingContext jssc, Class<K> keyTypeClass, Class<V> valueTypeClass, Class<U> keyDecoderClass, Class<T> valueDecoderClass, java.util.Map<String, String> kafkaParams, java.util.Map<String, Integer> topics, StorageLevel storageLevel) {
        ClassTag keyCmt = ClassTag$.MODULE$.apply(keyTypeClass);
        ClassTag valueCmt = ClassTag$.MODULE$.apply(valueTypeClass);
        ClassTag keyCmd = ClassTag$.MODULE$.apply(keyDecoderClass);
        ClassTag valueCmd = ClassTag$.MODULE$.apply(valueDecoderClass);
        return JavaPairReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), (scala.collection.immutable.Map<String, String>)JavaConversions$.MODULE$.mapAsScalaMap(kafkaParams).toMap(Predef$.MODULE$.conforms()), (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(topics).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$3) {
                return x$3;
            }
        }).toSeq())), storageLevel, keyCmt, valueCmt, keyCmd, valueCmd), keyCmt, valueCmt);
    }

    public StorageLevel createStream$default$5() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER_2();
    }

    public scala.collection.immutable.Map<TopicAndPartition, Tuple2<String, Object>> org$apache$spark$streaming$kafka$KafkaUtils$$leadersForRanges(KafkaCluster kc, OffsetRange[] offsetRanges) {
        scala.collection.immutable.Set topics = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])offsetRanges).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(OffsetRange o) {
                return new TopicAndPartition(o.topic(), o.partition());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TopicAndPartition.class)))).toSet();
        Either<ArrayBuffer<Throwable>, scala.collection.immutable.Map<TopicAndPartition, Tuple2<String, Object>>> leaders = kc.findLeaders((scala.collection.immutable.Set<TopicAndPartition>)topics);
        return KafkaCluster$.MODULE$.checkErrors(leaders);
    }

    public void org$apache$spark$streaming$kafka$KafkaUtils$$checkOffsets(KafkaCluster kc, OffsetRange[] offsetRanges) {
        scala.collection.immutable.Set topics = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])offsetRanges).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(OffsetRange x$4) {
                return x$4.topicAndPartition();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TopicAndPartition.class)))).toSet();
        Either result = kc.getEarliestLeaderOffsets((scala.collection.immutable.Set<TopicAndPartition>)topics).right().flatMap((Function1)new Serializable(kc, offsetRanges, topics){
            public static final long serialVersionUID = 0L;
            private final KafkaCluster kc$1;
            public final OffsetRange[] offsetRanges$1;
            private final scala.collection.immutable.Set topics$1;

            public final Serializable apply(scala.collection.immutable.Map<TopicAndPartition, KafkaCluster.LeaderOffset> low) {
                return this.kc$1.getLatestLeaderOffsets((scala.collection.immutable.Set<TopicAndPartition>)this.topics$1).right().map((Function1)new Serializable(this, low){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;
                    public final scala.collection.immutable.Map low$1;

                    public final OffsetRange[] apply(scala.collection.immutable.Map<TopicAndPartition, KafkaCluster.LeaderOffset> high) {
                        return (OffsetRange[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.offsetRanges$1).filterNot((Function1)new Serializable(this, high){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$3$$anonfun$apply$1 $outer;
                            private final scala.collection.immutable.Map high$1;

                            public final boolean apply(OffsetRange o) {
                                return ((KafkaCluster.LeaderOffset)this.$outer.low$1.apply((Object)o.topicAndPartition())).offset() <= o.fromOffset() && o.untilOffset() <= ((KafkaCluster.LeaderOffset)this.high$1.apply((Object)o.topicAndPartition())).offset();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.high$1 = high$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.low$1 = low$1;
                    }
                });
            }
            {
                this.kc$1 = kc$1;
                this.offsetRanges$1 = offsetRanges$1;
                this.topics$1 = topics$1;
            }
        });
        OffsetRange[] badRanges = (OffsetRange[])KafkaCluster$.MODULE$.checkErrors(result);
        if (Predef$.MODULE$.refArrayOps((Object[])badRanges).isEmpty()) {
            return;
        }
        throw new SparkException(new StringBuilder().append((Object)"Offsets not available on leader: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])badRanges).mkString(",")).toString());
    }

    public <K, V, KD extends Decoder<K>, VD extends Decoder<V>> RDD<Tuple2<K, V>> createRDD(SparkContext sc, scala.collection.immutable.Map<String, String> kafkaParams, OffsetRange[] offsetRanges, ClassTag<K> evidence$5, ClassTag<V> evidence$6, ClassTag<KD> evidence$7, ClassTag<VD> evidence$8) {
        return (RDD)sc.withScope((Function0)new Serializable(sc, kafkaParams, offsetRanges, evidence$5, evidence$6, evidence$7, evidence$8){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$1;
            private final scala.collection.immutable.Map kafkaParams$1;
            private final OffsetRange[] offsetRanges$2;
            private final ClassTag evidence$5$1;
            private final ClassTag evidence$6$1;
            private final ClassTag evidence$7$1;
            private final ClassTag evidence$8$1;

            public final KafkaRDD<K, V, KD, VD, Tuple2<K, V>> apply() {
                Serializable messageHandler = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<K, V> apply(MessageAndMetadata<K, V> mmd) {
                        return new Tuple2(mmd.key(), mmd.message());
                    }
                };
                KafkaCluster kc = new KafkaCluster((scala.collection.immutable.Map<String, String>)this.kafkaParams$1);
                scala.collection.immutable.Map<TopicAndPartition, Tuple2<String, Object>> leaders = KafkaUtils$.MODULE$.org$apache$spark$streaming$kafka$KafkaUtils$$leadersForRanges(kc, this.offsetRanges$2);
                KafkaUtils$.MODULE$.org$apache$spark$streaming$kafka$KafkaUtils$$checkOffsets(kc, this.offsetRanges$2);
                return new KafkaRDD<K, V, U, T, R>(this.sc$1, (scala.collection.immutable.Map<String, String>)this.kafkaParams$1, this.offsetRanges$2, leaders, messageHandler, this.evidence$5$1, this.evidence$6$1, this.evidence$7$1, this.evidence$8$1, ClassTag$.MODULE$.apply(Tuple2.class));
            }
            {
                this.sc$1 = sc$1;
                this.kafkaParams$1 = kafkaParams$1;
                this.offsetRanges$2 = offsetRanges$2;
                this.evidence$5$1 = evidence$5$1;
                this.evidence$6$1 = evidence$6$1;
                this.evidence$7$1 = evidence$7$1;
                this.evidence$8$1 = evidence$8$1;
            }
        });
    }

    public <K, V, KD extends Decoder<K>, VD extends Decoder<V>, R> RDD<R> createRDD(SparkContext sc, scala.collection.immutable.Map<String, String> kafkaParams, OffsetRange[] offsetRanges, scala.collection.immutable.Map<TopicAndPartition, Broker> leaders, Function1<MessageAndMetadata<K, V>, R> messageHandler, ClassTag<K> evidence$9, ClassTag<V> evidence$10, ClassTag<KD> evidence$11, ClassTag<VD> evidence$12, ClassTag<R> evidence$13) {
        return (RDD)sc.withScope((Function0)new Serializable(sc, kafkaParams, offsetRanges, leaders, messageHandler, evidence$9, evidence$10, evidence$11, evidence$12, evidence$13){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$2;
            private final scala.collection.immutable.Map kafkaParams$2;
            private final OffsetRange[] offsetRanges$3;
            private final scala.collection.immutable.Map leaders$1;
            private final Function1 messageHandler$1;
            private final ClassTag evidence$9$1;
            private final ClassTag evidence$10$1;
            private final ClassTag evidence$11$1;
            private final ClassTag evidence$12$1;
            private final ClassTag evidence$13$1;

            public final KafkaRDD<K, V, KD, VD, R> apply() {
                KafkaCluster kc = new KafkaCluster((scala.collection.immutable.Map<String, String>)this.kafkaParams$2);
                scala.collection.immutable.Map leaderMap = this.leaders$1.isEmpty() ? KafkaUtils$.MODULE$.org$apache$spark$streaming$kafka$KafkaUtils$$leadersForRanges(kc, this.offsetRanges$3) : ((scala.collection.immutable.Map)this.leaders$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicAndPartition, Tuple2<String, Object>> apply(Tuple2<TopicAndPartition, Broker> x0$1) {
                        Tuple2<TopicAndPartition, Broker> tuple2 = x0$1;
                        if (tuple2 != null) {
                            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                            Broker broker = (Broker)tuple2._2();
                            if (tp != null) {
                                TopicAndPartition topicAndPartition = tp;
                                Option<Tuple2<String, Object>> option = Broker$.MODULE$.unapply(broker);
                                if (!option.isEmpty()) {
                                    String host = (String)((Tuple2)option.get())._1();
                                    int port = ((Tuple2)option.get())._2$mcI$sp();
                                    Tuple2 tuple22 = new Tuple2((Object)topicAndPartition, (Object)new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port)));
                                    return tuple22;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                Function1 cleanedHandler = (Function1)this.sc$2.clean((Object)this.messageHandler$1, this.sc$2.clean$default$2());
                KafkaUtils$.MODULE$.org$apache$spark$streaming$kafka$KafkaUtils$$checkOffsets(kc, this.offsetRanges$3);
                return new KafkaRDD<K, V, U, T, R>(this.sc$2, (scala.collection.immutable.Map<String, String>)this.kafkaParams$2, this.offsetRanges$3, (scala.collection.immutable.Map<TopicAndPartition, Tuple2<String, Object>>)leaderMap, cleanedHandler, this.evidence$9$1, this.evidence$10$1, this.evidence$11$1, this.evidence$12$1, this.evidence$13$1);
            }
            {
                this.sc$2 = sc$2;
                this.kafkaParams$2 = kafkaParams$2;
                this.offsetRanges$3 = offsetRanges$3;
                this.leaders$1 = leaders$1;
                this.messageHandler$1 = messageHandler$1;
                this.evidence$9$1 = evidence$9$1;
                this.evidence$10$1 = evidence$10$1;
                this.evidence$11$1 = evidence$11$1;
                this.evidence$12$1 = evidence$12$1;
                this.evidence$13$1 = evidence$13$1;
            }
        });
    }

    public <K, V, KD extends Decoder<K>, VD extends Decoder<V>> JavaPairRDD<K, V> createRDD(JavaSparkContext jsc, Class<K> keyClass, Class<V> valueClass, Class<KD> keyDecoderClass, Class<VD> valueDecoderClass, java.util.Map<String, String> kafkaParams, OffsetRange[] offsetRanges) {
        return (JavaPairRDD)jsc.sc().withScope((Function0)new Serializable(jsc, keyClass, valueClass, keyDecoderClass, valueDecoderClass, kafkaParams, offsetRanges){
            public static final long serialVersionUID = 0L;
            private final JavaSparkContext jsc$1;
            private final Class keyClass$1;
            private final Class valueClass$1;
            private final Class keyDecoderClass$1;
            private final Class valueDecoderClass$1;
            private final java.util.Map kafkaParams$3;
            private final OffsetRange[] offsetRanges$4;

            public final JavaPairRDD<K, V> apply() {
                ClassTag keyCmt = ClassTag$.MODULE$.apply(this.keyClass$1);
                ClassTag valueCmt = ClassTag$.MODULE$.apply(this.valueClass$1);
                ClassTag keyDecoderCmt = ClassTag$.MODULE$.apply(this.keyDecoderClass$1);
                ClassTag valueDecoderCmt = ClassTag$.MODULE$.apply(this.valueDecoderClass$1);
                return new JavaPairRDD(KafkaUtils$.MODULE$.createRDD(this.jsc$1.sc(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(this.kafkaParams$3).toSeq())), this.offsetRanges$4, keyCmt, valueCmt, keyDecoderCmt, valueDecoderCmt), keyCmt, valueCmt);
            }
            {
                this.jsc$1 = jsc$1;
                this.keyClass$1 = keyClass$1;
                this.valueClass$1 = valueClass$1;
                this.keyDecoderClass$1 = keyDecoderClass$1;
                this.valueDecoderClass$1 = valueDecoderClass$1;
                this.kafkaParams$3 = kafkaParams$3;
                this.offsetRanges$4 = offsetRanges$4;
            }
        });
    }

    public <K, V, KD extends Decoder<K>, VD extends Decoder<V>, R> JavaRDD<R> createRDD(JavaSparkContext jsc, Class<K> keyClass, Class<V> valueClass, Class<KD> keyDecoderClass, Class<VD> valueDecoderClass, Class<R> recordClass, java.util.Map<String, String> kafkaParams, OffsetRange[] offsetRanges, java.util.Map<TopicAndPartition, Broker> leaders, Function<MessageAndMetadata<K, V>, R> messageHandler) {
        return (JavaRDD)jsc.sc().withScope((Function0)new Serializable(jsc, keyClass, valueClass, keyDecoderClass, valueDecoderClass, recordClass, kafkaParams, offsetRanges, leaders, messageHandler){
            public static final long serialVersionUID = 0L;
            private final JavaSparkContext jsc$2;
            private final Class keyClass$2;
            private final Class valueClass$2;
            private final Class keyDecoderClass$2;
            private final Class valueDecoderClass$2;
            private final Class recordClass$1;
            private final java.util.Map kafkaParams$4;
            private final OffsetRange[] offsetRanges$5;
            private final java.util.Map leaders$2;
            public final Function messageHandler$2;

            public final JavaRDD<R> apply() {
                ClassTag keyCmt = ClassTag$.MODULE$.apply(this.keyClass$2);
                ClassTag valueCmt = ClassTag$.MODULE$.apply(this.valueClass$2);
                ClassTag keyDecoderCmt = ClassTag$.MODULE$.apply(this.keyDecoderClass$2);
                ClassTag valueDecoderCmt = ClassTag$.MODULE$.apply(this.valueDecoderClass$2);
                ClassTag recordCmt = ClassTag$.MODULE$.apply(this.recordClass$1);
                scala.collection.immutable.Map leaderMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(this.leaders$2).toSeq());
                return JavaRDD$.MODULE$.fromRDD(KafkaUtils$.MODULE$.createRDD(this.jsc$2.sc(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(this.kafkaParams$4).toSeq())), this.offsetRanges$5, (scala.collection.immutable.Map<TopicAndPartition, Broker>)leaderMap, new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createRDD.4 $outer;

                    public final R apply(MessageAndMetadata<K, V> x$1) {
                        return (R)this.$outer.messageHandler$2.call(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, keyCmt, valueCmt, keyDecoderCmt, valueDecoderCmt, recordCmt), recordCmt);
            }
            {
                this.jsc$2 = jsc$2;
                this.keyClass$2 = keyClass$2;
                this.valueClass$2 = valueClass$2;
                this.keyDecoderClass$2 = keyDecoderClass$2;
                this.valueDecoderClass$2 = valueDecoderClass$2;
                this.recordClass$1 = recordClass$1;
                this.kafkaParams$4 = kafkaParams$4;
                this.offsetRanges$5 = offsetRanges$5;
                this.leaders$2 = leaders$2;
                this.messageHandler$2 = messageHandler$2;
            }
        });
    }

    public <K, V, KD extends Decoder<K>, VD extends Decoder<V>, R> InputDStream<R> createDirectStream(StreamingContext ssc, scala.collection.immutable.Map<String, String> kafkaParams, scala.collection.immutable.Map<TopicAndPartition, Object> fromOffsets, Function1<MessageAndMetadata<K, V>, R> messageHandler, ClassTag<K> evidence$14, ClassTag<V> evidence$15, ClassTag<KD> evidence$16, ClassTag<VD> evidence$17, ClassTag<R> evidence$18) {
        Function1 cleanedHandler = (Function1)ssc.sc().clean(messageHandler, ssc.sc().clean$default$2());
        return new DirectKafkaInputDStream<K, V, KD, VD, R>(ssc, kafkaParams, fromOffsets, cleanedHandler, evidence$14, evidence$15, evidence$16, evidence$17, evidence$18);
    }

    public <K, V, KD extends Decoder<K>, VD extends Decoder<V>> InputDStream<Tuple2<K, V>> createDirectStream(StreamingContext ssc, scala.collection.immutable.Map<String, String> kafkaParams, scala.collection.immutable.Set<String> topics, ClassTag<K> evidence$19, ClassTag<V> evidence$20, ClassTag<KD> evidence$21, ClassTag<VD> evidence$22) {
        Serializable messageHandler = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<K, V> apply(MessageAndMetadata<K, V> mmd) {
                return new Tuple2(mmd.key(), mmd.message());
            }
        };
        KafkaCluster kc = new KafkaCluster(kafkaParams);
        Option reset = kafkaParams.get((Object)"auto.offset.reset").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$5) {
                return x$5.toLowerCase();
            }
        });
        Either result = kc.getPartitions(topics).right().flatMap((Function1)new Serializable(ssc, kafkaParams, evidence$19, evidence$20, evidence$21, evidence$22, (Function1)messageHandler, kc, reset){
            public static final long serialVersionUID = 0L;
            public final StreamingContext ssc$1;
            public final scala.collection.immutable.Map kafkaParams$5;
            public final ClassTag evidence$19$1;
            public final ClassTag evidence$20$1;
            public final ClassTag evidence$21$1;
            public final ClassTag evidence$22$1;
            public final Function1 messageHandler$3;
            private final KafkaCluster kc$2;
            private final Option reset$1;

            public final Serializable apply(scala.collection.immutable.Set<TopicAndPartition> topicPartitions) {
                Option option = this.reset$1;
                Some some = new Some((Object)"smallest");
                return (!(option != null ? !option.equals(some) : some != null) ? this.kc$2.getEarliestLeaderOffsets(topicPartitions) : this.kc$2.getLatestLeaderOffsets(topicPartitions)).right().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.8 $outer;

                    public final DirectKafkaInputDStream<K, V, KD, VD, Tuple2<K, V>> apply(scala.collection.immutable.Map<TopicAndPartition, KafkaCluster.LeaderOffset> leaderOffsets) {
                        scala.collection.immutable.Map fromOffsets = (scala.collection.immutable.Map)leaderOffsets.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, KafkaCluster.LeaderOffset> x0$2) {
                                Tuple2<TopicAndPartition, KafkaCluster.LeaderOffset> tuple2 = x0$2;
                                if (tuple2 != null) {
                                    TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                                    KafkaCluster.LeaderOffset lo = (KafkaCluster.LeaderOffset)tuple2._2();
                                    Tuple2 tuple22 = new Tuple2((Object)tp, (Object)BoxesRunTime.boxToLong((long)lo.offset()));
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Map$.MODULE$.canBuildFrom());
                        return new DirectKafkaInputDStream<K, V, U, T, R>(this.$outer.ssc$1, (scala.collection.immutable.Map<String, String>)this.$outer.kafkaParams$5, (scala.collection.immutable.Map<TopicAndPartition, Object>)fromOffsets, this.$outer.messageHandler$3, this.$outer.evidence$19$1, this.$outer.evidence$20$1, this.$outer.evidence$21$1, this.$outer.evidence$22$1, ClassTag$.MODULE$.apply(Tuple2.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.ssc$1 = ssc$1;
                this.kafkaParams$5 = kafkaParams$5;
                this.evidence$19$1 = evidence$19$1;
                this.evidence$20$1 = evidence$20$1;
                this.evidence$21$1 = evidence$21$1;
                this.evidence$22$1 = evidence$22$1;
                this.messageHandler$3 = messageHandler$3;
                this.kc$2 = kc$2;
                this.reset$1 = reset$1;
            }
        });
        return (InputDStream)KafkaCluster$.MODULE$.checkErrors(result);
    }

    public <K, V, KD extends Decoder<K>, VD extends Decoder<V>, R> JavaInputDStream<R> createDirectStream(JavaStreamingContext jssc, Class<K> keyClass, Class<V> valueClass, Class<KD> keyDecoderClass, Class<VD> valueDecoderClass, Class<R> recordClass, java.util.Map<String, String> kafkaParams, java.util.Map<TopicAndPartition, Long> fromOffsets, Function<MessageAndMetadata<K, V>, R> messageHandler) {
        ClassTag keyCmt = ClassTag$.MODULE$.apply(keyClass);
        ClassTag valueCmt = ClassTag$.MODULE$.apply(valueClass);
        ClassTag keyDecoderCmt = ClassTag$.MODULE$.apply(keyDecoderClass);
        ClassTag valueDecoderCmt = ClassTag$.MODULE$.apply(valueDecoderClass);
        ClassTag recordCmt = ClassTag$.MODULE$.apply(recordClass);
        SparkContext qual$1 = JavaSparkContext$.MODULE$.toSparkContext(jssc.sparkContext());
        Serializable x$8 = new Serializable(messageHandler){
            public static final long serialVersionUID = 0L;
            private final Function messageHandler$4;

            public final R apply(MessageAndMetadata<K, V> x$1) {
                return (R)this.messageHandler$4.call(x$1);
            }
            {
                this.messageHandler$4 = messageHandler$4;
            }
        };
        boolean x$9 = qual$1.clean$default$2();
        Function1 cleanedHandler = (Function1)qual$1.clean((Object)x$8, x$9);
        return JavaInputDStream$.MODULE$.fromInputDStream(this.createDirectStream(jssc.ssc(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(kafkaParams).toSeq())), (scala.collection.immutable.Map<TopicAndPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(fromOffsets).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Long x$6) {
                return x$6;
            }
        }).toSeq())), cleanedHandler, keyCmt, valueCmt, keyDecoderCmt, valueDecoderCmt, recordCmt), recordCmt);
    }

    public <K, V, KD extends Decoder<K>, VD extends Decoder<V>> JavaPairInputDStream<K, V> createDirectStream(JavaStreamingContext jssc, Class<K> keyClass, Class<V> valueClass, Class<KD> keyDecoderClass, Class<VD> valueDecoderClass, java.util.Map<String, String> kafkaParams, Set<String> topics) {
        ClassTag keyCmt = ClassTag$.MODULE$.apply(keyClass);
        ClassTag valueCmt = ClassTag$.MODULE$.apply(valueClass);
        ClassTag keyDecoderCmt = ClassTag$.MODULE$.apply(keyDecoderClass);
        ClassTag valueDecoderCmt = ClassTag$.MODULE$.apply(valueDecoderClass);
        return JavaPairInputDStream$.MODULE$.fromInputDStream(this.createDirectStream(jssc.ssc(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(JavaConversions$.MODULE$.mapAsScalaMap(kafkaParams).toSeq())), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply(JavaConversions$.MODULE$.asScalaSet(topics).toSeq())), keyCmt, valueCmt, keyDecoderCmt, valueDecoderCmt), keyCmt, valueCmt);
    }

    private KafkaUtils$() {
        MODULE$ = this;
    }
}

