/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisDataFetcher;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.RecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.clientlibrary.types.InitializationInput;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class InitializeTask
implements ITask {
    private static final Log LOG = LogFactory.getLog(InitializeTask.class);
    private static final String RECORD_PROCESSOR_INITIALIZE_METRIC = "RecordProcessor.initialize";
    private final ShardInfo shardInfo;
    private final IRecordProcessor recordProcessor;
    private final KinesisDataFetcher dataFetcher;
    private final TaskType taskType = TaskType.INITIALIZE;
    private final ICheckpoint checkpoint;
    private final RecordProcessorCheckpointer recordProcessorCheckpointer;
    private final long backoffTimeMillis;

    InitializeTask(ShardInfo shardInfo, IRecordProcessor recordProcessor, ICheckpoint checkpoint2, RecordProcessorCheckpointer recordProcessorCheckpointer, KinesisDataFetcher dataFetcher, long backoffTimeMillis) {
        this.shardInfo = shardInfo;
        this.recordProcessor = recordProcessor;
        this.checkpoint = checkpoint2;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.dataFetcher = dataFetcher;
        this.backoffTimeMillis = backoffTimeMillis;
    }

    @Override
    public TaskResult call() {
        boolean applicationException = false;
        Exception exception = null;
        try {
            LOG.debug("Initializing ShardId " + this.shardInfo.getShardId());
            ExtendedSequenceNumber initialCheckpoint = this.checkpoint.getCheckpoint(this.shardInfo.getShardId());
            this.dataFetcher.initialize(initialCheckpoint.getSequenceNumber());
            this.recordProcessorCheckpointer.setLargestPermittedCheckpointValue(initialCheckpoint);
            this.recordProcessorCheckpointer.setInitialCheckpointValue(initialCheckpoint);
            LOG.debug("Calling the record processor initialize().");
            InitializationInput initializationInput = new InitializationInput().withShardId(this.shardInfo.getShardId()).withExtendedSequenceNumber(initialCheckpoint);
            long recordProcessorStartTimeMillis = System.currentTimeMillis();
            try {
                this.recordProcessor.initialize(initializationInput);
                LOG.debug("Record processor initialize() completed.");
            }
            catch (Exception e) {
                applicationException = true;
                throw e;
            }
            finally {
                MetricsHelper.addLatency(RECORD_PROCESSOR_INITIALIZE_METRIC, recordProcessorStartTimeMillis, MetricsLevel.SUMMARY);
            }
            return new TaskResult(null);
        }
        catch (Exception e) {
            if (applicationException) {
                LOG.error("Application initialize() threw exception: ", e);
            } else {
                LOG.error("Caught exception: ", e);
            }
            exception = e;
            try {
                Thread.sleep(this.backoffTimeMillis);
            }
            catch (InterruptedException ie) {
                LOG.debug("Interrupted sleep", ie);
            }
            return new TaskResult(exception);
        }
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }
}

