/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ShutdownException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.KinesisClientLibIOException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.LeaseCoordinator;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KinesisClientLibLeaseCoordinator
extends LeaseCoordinator<KinesisClientLease>
implements ICheckpoint {
    private static final Log LOG = LogFactory.getLog(KinesisClientLibLeaseCoordinator.class);
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private final long initialLeaseTableReadCapacity = 10L;
    private final long initialLeaseTableWriteCapacity = 10L;

    public KinesisClientLibLeaseCoordinator(ILeaseManager<KinesisClientLease> leaseManager, String workerIdentifier, long leaseDurationMillis, long epsilonMillis) {
        super(leaseManager, workerIdentifier, leaseDurationMillis, epsilonMillis);
        this.leaseManager = leaseManager;
    }

    public KinesisClientLibLeaseCoordinator(ILeaseManager<KinesisClientLease> leaseManager, String workerIdentifier, long leaseDurationMillis, long epsilonMillis, IMetricsFactory metricsFactory) {
        super(leaseManager, workerIdentifier, leaseDurationMillis, epsilonMillis, metricsFactory);
        this.leaseManager = leaseManager;
    }

    boolean setCheckpoint(String shardId, ExtendedSequenceNumber checkpoint2, UUID concurrencyToken) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        KinesisClientLease lease = (KinesisClientLease)this.getCurrentlyHeldLease(shardId);
        if (lease == null) {
            LOG.info(String.format("Worker %s could not update checkpoint for shard %s because it does not hold the lease", this.getWorkerIdentifier(), shardId));
            return false;
        }
        lease.setCheckpoint(checkpoint2);
        lease.setOwnerSwitchesSinceCheckpoint(0L);
        return this.updateLease(lease, concurrencyToken);
    }

    @Override
    public void setCheckpoint(String shardId, ExtendedSequenceNumber checkpointValue, String concurrencyToken) throws KinesisClientLibException {
        try {
            boolean wasSuccessful = this.setCheckpoint(shardId, checkpointValue, UUID.fromString(concurrencyToken));
            if (!wasSuccessful) {
                throw new ShutdownException("Can't update checkpoint - instance doesn't hold the lease for this shard");
            }
        }
        catch (ProvisionedThroughputException e) {
            throw new ThrottlingException("Got throttled while updating checkpoint.", e);
        }
        catch (InvalidStateException e) {
            String message = "Unable to save checkpoint for shardId " + shardId;
            LOG.error(message, e);
            throw new com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException(message, e);
        }
        catch (DependencyException e) {
            throw new KinesisClientLibDependencyException("Unable to save checkpoint for shardId " + shardId, e);
        }
    }

    @Override
    public ExtendedSequenceNumber getCheckpoint(String shardId) throws KinesisClientLibException {
        try {
            return this.leaseManager.getLease(shardId).getCheckpoint();
        }
        catch (DependencyException | InvalidStateException | ProvisionedThroughputException e) {
            String message = "Unable to fetch checkpoint for shardId " + shardId;
            LOG.error(message, e);
            throw new KinesisClientLibIOException(message, e);
        }
    }

    public List<ShardInfo> getCurrentAssignments() {
        LinkedList<ShardInfo> assignments = new LinkedList<ShardInfo>();
        Collection leases = this.getAssignments();
        if (leases != null && !leases.isEmpty()) {
            for (KinesisClientLease lease : leases) {
                Set<String> parentShardIds = lease.getParentShardIds();
                ShardInfo assignment = new ShardInfo(lease.getLeaseKey(), lease.getConcurrencyToken().toString(), parentShardIds);
                assignments.add(assignment);
            }
        }
        return assignments;
    }

    void initialize() throws ProvisionedThroughputException, DependencyException, IllegalStateException {
        boolean newTableCreated = this.leaseManager.createLeaseTableIfNotExists(10L, 10L);
        if (newTableCreated) {
            LOG.info("Created new lease table for coordinator");
        }
        long secondsBetweenPolls = 10L;
        long timeoutSeconds = 600L;
        boolean isTableActive = this.leaseManager.waitUntilLeaseTableExists(10L, 600L);
        if (!isTableActive) {
            throw new DependencyException(new IllegalStateException("Creating table timeout"));
        }
    }

    void runLeaseTaker() throws DependencyException, InvalidStateException {
        super.runTaker();
    }

    void runLeaseRenewer() throws DependencyException, InvalidStateException {
        super.runRenewer();
    }

    ILeaseManager<KinesisClientLease> getLeaseManager() {
        return this.leaseManager;
    }
}

