/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.checkpoint.SentinelCheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.proxies.MetricsCollectingKinesisProxyDecorator;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KinesisDataFetcher {
    private static final Log LOG = LogFactory.getLog(KinesisDataFetcher.class);
    private String nextIterator;
    private IKinesisProxy kinesisProxy;
    private final String shardId;
    private boolean isShardEndReached;
    private boolean isInitialized;

    public KinesisDataFetcher(IKinesisProxy kinesisProxy, ShardInfo shardInfo) {
        this.shardId = shardInfo.getShardId();
        this.kinesisProxy = new MetricsCollectingKinesisProxyDecorator("KinesisDataFetcher", kinesisProxy, this.shardId);
    }

    public GetRecordsResult getRecords(int maxRecords) {
        if (!this.isInitialized) {
            throw new IllegalArgumentException("KinesisDataFetcher.getRecords called before initialization.");
        }
        GetRecordsResult response = null;
        if (this.nextIterator != null) {
            try {
                response = this.kinesisProxy.get(this.nextIterator, maxRecords);
                this.nextIterator = response.getNextShardIterator();
            }
            catch (ResourceNotFoundException e) {
                LOG.info("Caught ResourceNotFoundException when fetching records for shard " + this.shardId);
                this.nextIterator = null;
            }
            if (this.nextIterator == null) {
                this.isShardEndReached = true;
            }
        } else {
            this.isShardEndReached = true;
        }
        return response;
    }

    public void initialize(String initialCheckpoint) {
        LOG.info("Initializing shard " + this.shardId + " with " + initialCheckpoint);
        this.advanceIteratorTo(initialCheckpoint);
        this.isInitialized = true;
    }

    public void initialize(ExtendedSequenceNumber initialCheckpoint) {
        LOG.info("Initializing shard " + this.shardId + " with " + initialCheckpoint.getSequenceNumber());
        this.advanceIteratorTo(initialCheckpoint.getSequenceNumber());
        this.isInitialized = true;
    }

    void advanceIteratorTo(String sequenceNumber) {
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("SequenceNumber should not be null: shardId " + this.shardId);
        }
        this.nextIterator = sequenceNumber.equals(SentinelCheckpoint.LATEST.toString()) ? this.getIterator(ShardIteratorType.LATEST.toString(), null) : (sequenceNumber.equals(SentinelCheckpoint.TRIM_HORIZON.toString()) ? this.getIterator(ShardIteratorType.TRIM_HORIZON.toString(), null) : (sequenceNumber.equals(SentinelCheckpoint.SHARD_END.toString()) ? null : this.getIterator(ShardIteratorType.AT_SEQUENCE_NUMBER.toString(), sequenceNumber)));
        if (this.nextIterator == null) {
            this.isShardEndReached = true;
        }
    }

    private String getIterator(String iteratorType, String sequenceNumber) {
        String iterator = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Calling getIterator for " + this.shardId + ", iterator type " + iteratorType + " and sequence number " + sequenceNumber);
            }
            iterator = this.kinesisProxy.getIterator(this.shardId, iteratorType, sequenceNumber);
        }
        catch (ResourceNotFoundException e) {
            LOG.info("Caught ResourceNotFoundException when getting an iterator for shard " + this.shardId, e);
        }
        return iterator;
    }

    protected boolean isShardEndReached() {
        return this.isShardEndReached;
    }

    String getNextIterator() {
        return this.nextIterator;
    }
}

