/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.KinesisClientLibIOException;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.services.kinesis.model.Shard;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ShardSyncer {
    private static final Log LOG = LogFactory.getLog(ShardSyncer.class);

    private ShardSyncer() {
    }

    static synchronized void bootstrapShardLeases(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStream initialPositionInStream, boolean cleanupLeasesOfCompletedShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        ShardSyncer.syncShardLeases(kinesisProxy, leaseManager, initialPositionInStream, cleanupLeasesOfCompletedShards);
    }

    static synchronized void checkAndCreateLeasesForNewShards(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStream initialPositionInStream, boolean cleanupLeasesOfCompletedShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        ShardSyncer.syncShardLeases(kinesisProxy, leaseManager, initialPositionInStream, cleanupLeasesOfCompletedShards);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void syncShardLeases(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStream initialPosition, boolean cleanupLeasesOfCompletedShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        List<Shard> shards = ShardSyncer.getShardList(kinesisProxy);
        LOG.debug("Num shards: " + shards.size());
        Map<String, Shard> shardIdToShardMap = ShardSyncer.constructShardIdToShardMap(shards);
        Map<String, Set<String>> shardIdToChildShardIdsMap = ShardSyncer.constructShardIdToChildShardIdsMap(shardIdToShardMap);
        ShardSyncer.assertAllParentShardsAreClosed(shardIdToChildShardIdsMap, shardIdToShardMap);
        List<KinesisClientLease> currentLeases = leaseManager.listLeases();
        List<KinesisClientLease> newLeasesToCreate = ShardSyncer.determineNewLeasesToCreate(shards, currentLeases, initialPosition);
        LOG.debug("Num new leases to create: " + newLeasesToCreate.size());
        for (KinesisClientLease lease : newLeasesToCreate) {
            long startTimeMillis = System.currentTimeMillis();
            boolean success = false;
            try {
                leaseManager.createLeaseIfNotExists(lease);
                success = true;
            }
            finally {
                MetricsHelper.addSuccessAndLatency("CreateLease", startTimeMillis, success, MetricsLevel.DETAILED);
            }
        }
        ArrayList<KinesisClientLease> trackedLeases = new ArrayList<KinesisClientLease>();
        if (currentLeases != null) {
            trackedLeases.addAll(currentLeases);
        }
        trackedLeases.addAll(newLeasesToCreate);
        ShardSyncer.cleanupGarbageLeases(shards, trackedLeases, kinesisProxy, leaseManager);
        if (cleanupLeasesOfCompletedShards) {
            ShardSyncer.cleanupLeasesOfFinishedShards(currentLeases, shardIdToShardMap, shardIdToChildShardIdsMap, trackedLeases, leaseManager);
        }
    }

    private static void assertAllParentShardsAreClosed(Map<String, Set<String>> shardIdToChildShardIdsMap, Map<String, Shard> shardIdToShardMap) throws KinesisClientLibIOException {
        for (String parentShardId : shardIdToChildShardIdsMap.keySet()) {
            Shard parentShard = shardIdToShardMap.get(parentShardId);
            if (parentShardId != null && parentShard.getSequenceNumberRange().getEndingSequenceNumber() != null) continue;
            throw new KinesisClientLibIOException("Parent shardId " + parentShardId + " is not closed. " + "This can happen due to a race condition between describeStream and a reshard operation.");
        }
    }

    static Map<String, KinesisClientLease> constructShardIdToKCLLeaseMap(List<KinesisClientLease> trackedLeaseList) {
        HashMap<String, KinesisClientLease> trackedLeasesMap = new HashMap<String, KinesisClientLease>();
        for (KinesisClientLease lease : trackedLeaseList) {
            trackedLeasesMap.put(lease.getLeaseKey(), lease);
        }
        return trackedLeasesMap;
    }

    static synchronized void assertClosedShardsAreCoveredOrAbsent(Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap, Set<String> shardIdsOfClosedShards) throws KinesisClientLibIOException {
        String exceptionMessageSuffix = "This can happen if we constructed the list of shards  while a reshard operation was in progress.";
        for (String shardId : shardIdsOfClosedShards) {
            Shard shard = shardIdToShardMap.get(shardId);
            if (shard == null) {
                LOG.info("Shard " + shardId + " is not present in Kinesis anymore.");
                continue;
            }
            String endingSequenceNumber = shard.getSequenceNumberRange().getEndingSequenceNumber();
            if (endingSequenceNumber == null) {
                throw new KinesisClientLibIOException("Shard " + shardIdsOfClosedShards + " is not closed. " + exceptionMessageSuffix);
            }
            Set<String> childShardIds = shardIdToChildShardIdsMap.get(shardId);
            if (childShardIds == null) {
                throw new KinesisClientLibIOException("Incomplete shard list: Closed shard " + shardId + " has no children." + exceptionMessageSuffix);
            }
            ShardSyncer.assertHashRangeOfClosedShardIsCovered(shard, shardIdToShardMap, childShardIds);
        }
    }

    private static synchronized void assertHashRangeOfClosedShardIsCovered(Shard closedShard, Map<String, Shard> shardIdToShardMap, Set<String> childShardIds) throws KinesisClientLibIOException {
        BigInteger startingHashKeyOfClosedShard = new BigInteger(closedShard.getHashKeyRange().getStartingHashKey());
        BigInteger endingHashKeyOfClosedShard = new BigInteger(closedShard.getHashKeyRange().getEndingHashKey());
        BigInteger minStartingHashKeyOfChildren = null;
        BigInteger maxEndingHashKeyOfChildren = null;
        for (String childShardId : childShardIds) {
            Shard childShard = shardIdToShardMap.get(childShardId);
            BigInteger startingHashKey = new BigInteger(childShard.getHashKeyRange().getStartingHashKey());
            if (minStartingHashKeyOfChildren == null || startingHashKey.compareTo(minStartingHashKeyOfChildren) < 0) {
                minStartingHashKeyOfChildren = startingHashKey;
            }
            BigInteger endingHashKey = new BigInteger(childShard.getHashKeyRange().getEndingHashKey());
            if (maxEndingHashKeyOfChildren != null && endingHashKey.compareTo(maxEndingHashKeyOfChildren) <= 0) continue;
            maxEndingHashKeyOfChildren = endingHashKey;
        }
        if (minStartingHashKeyOfChildren == null || maxEndingHashKeyOfChildren == null || minStartingHashKeyOfChildren.compareTo(startingHashKeyOfClosedShard) > 0 || maxEndingHashKeyOfChildren.compareTo(endingHashKeyOfClosedShard) < 0) {
            throw new KinesisClientLibIOException("Incomplete shard list: hash key range of shard " + closedShard.getShardId() + " is not covered by its child shards.");
        }
    }

    static Map<String, Set<String>> constructShardIdToChildShardIdsMap(Map<String, Shard> shardIdToShardMap) {
        HashMap<String, Set<String>> shardIdToChildShardIdsMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Shard> entry : shardIdToShardMap.entrySet()) {
            String adjacentParentShardId;
            String shardId = entry.getKey();
            Shard shard = entry.getValue();
            String parentShardId = shard.getParentShardId();
            if (parentShardId != null && shardIdToShardMap.containsKey(parentShardId)) {
                HashSet<String> childShardIds = (HashSet<String>)shardIdToChildShardIdsMap.get(parentShardId);
                if (childShardIds == null) {
                    childShardIds = new HashSet<String>();
                    shardIdToChildShardIdsMap.put(parentShardId, childShardIds);
                }
                childShardIds.add(shardId);
            }
            if ((adjacentParentShardId = shard.getAdjacentParentShardId()) == null || !shardIdToShardMap.containsKey(adjacentParentShardId)) continue;
            HashSet<String> childShardIds = (HashSet<String>)shardIdToChildShardIdsMap.get(adjacentParentShardId);
            if (childShardIds == null) {
                childShardIds = new HashSet<String>();
                shardIdToChildShardIdsMap.put(adjacentParentShardId, childShardIds);
            }
            childShardIds.add(shardId);
        }
        return shardIdToChildShardIdsMap;
    }

    private static List<Shard> getShardList(IKinesisProxy kinesisProxy) throws KinesisClientLibIOException {
        List<Shard> shards = kinesisProxy.getShardList();
        if (shards == null) {
            throw new KinesisClientLibIOException("Stream is not in ACTIVE OR UPDATING state - will retry getting the shard list.");
        }
        return shards;
    }

    static List<KinesisClientLease> determineNewLeasesToCreate(List<Shard> shards, List<KinesisClientLease> currentLeases, InitialPositionInStream initialPosition) {
        HashMap<String, KinesisClientLease> shardIdToNewLeaseMap = new HashMap<String, KinesisClientLease>();
        Map<String, Shard> shardIdToShardMapOfAllKinesisShards = ShardSyncer.constructShardIdToShardMap(shards);
        HashSet<String> shardIdsOfCurrentLeases = new HashSet<String>();
        for (KinesisClientLease lease : currentLeases) {
            shardIdsOfCurrentLeases.add(lease.getLeaseKey());
            LOG.debug("Existing lease: " + lease);
        }
        List<Shard> openShards = ShardSyncer.getOpenShards(shards);
        HashMap<String, Boolean> memoizationContext = new HashMap<String, Boolean>();
        for (Shard shard : openShards) {
            String shardId = shard.getShardId();
            LOG.debug("Evaluating leases for open shard " + shardId + " and its ancestors.");
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                LOG.debug("Lease for shardId " + shardId + " already exists. Not creating a lease");
                continue;
            }
            LOG.debug("Need to create a lease for shardId " + shardId);
            KinesisClientLease newLease = ShardSyncer.newKCLLease(shard);
            boolean isDescendant = ShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(shardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToNewLeaseMap, memoizationContext);
            if (isDescendant) {
                newLease.setCheckpoint(ExtendedSequenceNumber.TRIM_HORIZON);
            } else {
                newLease.setCheckpoint(ShardSyncer.convertToCheckpoint(initialPosition));
            }
            LOG.debug("Set checkpoint of " + newLease.getLeaseKey() + " to " + newLease.getCheckpoint());
            shardIdToNewLeaseMap.put(shardId, newLease);
        }
        ArrayList<KinesisClientLease> newLeasesToCreate = new ArrayList<KinesisClientLease>();
        newLeasesToCreate.addAll(shardIdToNewLeaseMap.values());
        StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMapOfAllKinesisShards);
        Collections.sort(newLeasesToCreate, startingSequenceNumberComparator);
        return newLeasesToCreate;
    }

    static boolean checkIfDescendantAndAddNewLeasesForAncestors(String shardId, InitialPositionInStream initialPosition, Set<String> shardIdsOfCurrentLeases, Map<String, Shard> shardIdToShardMapOfAllKinesisShards, Map<String, KinesisClientLease> shardIdToLeaseMapOfNewShards, Map<String, Boolean> memoizationContext) {
        Boolean previousValue = memoizationContext.get(shardId);
        if (previousValue != null) {
            return previousValue;
        }
        boolean isDescendant = false;
        HashSet<String> descendantParentShardIds = new HashSet<String>();
        if (shardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(shardId)) {
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                isDescendant = true;
            } else {
                Shard shard = shardIdToShardMapOfAllKinesisShards.get(shardId);
                Set<String> parentShardIds = ShardSyncer.getParentShardIds(shard, shardIdToShardMapOfAllKinesisShards);
                for (String parentShardId : parentShardIds) {
                    if (ShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(parentShardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToLeaseMapOfNewShards, memoizationContext)) {
                        isDescendant = true;
                        descendantParentShardIds.add(parentShardId);
                        LOG.debug("Parent shard " + parentShardId + " is a descendant.");
                        continue;
                    }
                    LOG.debug("Parent shard " + parentShardId + " is NOT a descendant.");
                }
                if (isDescendant) {
                    for (String parentShardId : parentShardIds) {
                        if (shardIdsOfCurrentLeases.contains(parentShardId)) continue;
                        LOG.debug("Need to create a lease for shardId " + parentShardId);
                        KinesisClientLease lease = shardIdToLeaseMapOfNewShards.get(parentShardId);
                        if (lease == null) {
                            lease = ShardSyncer.newKCLLease(shardIdToShardMapOfAllKinesisShards.get(parentShardId));
                            shardIdToLeaseMapOfNewShards.put(parentShardId, lease);
                        }
                        if (descendantParentShardIds.contains(parentShardId)) {
                            lease.setCheckpoint(ExtendedSequenceNumber.TRIM_HORIZON);
                            continue;
                        }
                        lease.setCheckpoint(ShardSyncer.convertToCheckpoint(initialPosition));
                    }
                } else if (initialPosition.equals((Object)InitialPositionInStream.TRIM_HORIZON)) {
                    isDescendant = true;
                }
            }
        }
        memoizationContext.put(shardId, isDescendant);
        return isDescendant;
    }

    static Set<String> getParentShardIds(Shard shard, Map<String, Shard> shardIdToShardMapOfAllKinesisShards) {
        String adjacentParentShardId;
        HashSet<String> parentShardIds = new HashSet<String>(2);
        String parentShardId = shard.getParentShardId();
        if (parentShardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(parentShardId)) {
            parentShardIds.add(parentShardId);
        }
        if ((adjacentParentShardId = shard.getAdjacentParentShardId()) != null && shardIdToShardMapOfAllKinesisShards.containsKey(adjacentParentShardId)) {
            parentShardIds.add(adjacentParentShardId);
        }
        return parentShardIds;
    }

    private static void cleanupGarbageLeases(List<Shard> shards, List<KinesisClientLease> trackedLeases, IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager) throws KinesisClientLibIOException, DependencyException, InvalidStateException, ProvisionedThroughputException {
        HashSet<String> kinesisShards = new HashSet<String>();
        for (Shard shard : shards) {
            kinesisShards.add(shard.getShardId());
        }
        ArrayList<KinesisClientLease> garbageLeases = new ArrayList<KinesisClientLease>();
        for (KinesisClientLease lease : trackedLeases) {
            if (!ShardSyncer.isCandidateForCleanup(lease, kinesisShards)) continue;
            garbageLeases.add(lease);
        }
        if (!garbageLeases.isEmpty()) {
            LOG.info("Found " + garbageLeases.size() + " candidate leases for cleanup. Refreshing list of" + " Kinesis shards to pick up recent/latest shards");
            List<Shard> currentShardList = ShardSyncer.getShardList(kinesisProxy);
            HashSet<String> currentKinesisShardIds = new HashSet<String>();
            for (Shard shard : currentShardList) {
                currentKinesisShardIds.add(shard.getShardId());
            }
            for (KinesisClientLease lease : garbageLeases) {
                if (!ShardSyncer.isCandidateForCleanup(lease, currentKinesisShardIds)) continue;
                LOG.info("Deleting lease for shard " + lease.getLeaseKey() + " as it is not present in Kinesis stream.");
                leaseManager.deleteLease(lease);
            }
        }
    }

    static boolean isCandidateForCleanup(KinesisClientLease lease, Set<String> currentKinesisShardIds) throws KinesisClientLibIOException {
        boolean isCandidateForCleanup = true;
        if (currentKinesisShardIds.contains(lease.getLeaseKey())) {
            isCandidateForCleanup = false;
        } else {
            LOG.info("Found lease for non-existent shard: " + lease.getLeaseKey() + ". Checking its parent shards");
            Set<String> parentShardIds = lease.getParentShardIds();
            for (String parentShardId : parentShardIds) {
                if (!currentKinesisShardIds.contains(parentShardId)) continue;
                String message = "Parent shard " + parentShardId + " exists but not the child shard " + lease.getLeaseKey();
                LOG.info(message);
                throw new KinesisClientLibIOException(message);
            }
        }
        return isCandidateForCleanup;
    }

    private static synchronized void cleanupLeasesOfFinishedShards(Collection<KinesisClientLease> currentLeases, Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap, List<KinesisClientLease> trackedLeases, ILeaseManager<KinesisClientLease> leaseManager) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        HashSet<String> shardIdsOfClosedShards = new HashSet<String>();
        ArrayList<KinesisClientLease> leasesOfClosedShards = new ArrayList<KinesisClientLease>();
        for (KinesisClientLease lease : currentLeases) {
            if (!lease.getCheckpoint().equals(ExtendedSequenceNumber.SHARD_END)) continue;
            shardIdsOfClosedShards.add(lease.getLeaseKey());
            leasesOfClosedShards.add(lease);
        }
        if (!leasesOfClosedShards.isEmpty()) {
            ShardSyncer.assertClosedShardsAreCoveredOrAbsent(shardIdToShardMap, shardIdToChildShardIdsMap, shardIdsOfClosedShards);
            StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMap);
            Collections.sort(leasesOfClosedShards, startingSequenceNumberComparator);
            Map<String, KinesisClientLease> trackedLeaseMap = ShardSyncer.constructShardIdToKCLLeaseMap(trackedLeases);
            for (KinesisClientLease leaseOfClosedShard : leasesOfClosedShards) {
                String closedShardId = leaseOfClosedShard.getLeaseKey();
                Set<String> childShardIds = shardIdToChildShardIdsMap.get(closedShardId);
                if (closedShardId == null || childShardIds == null || childShardIds.isEmpty()) continue;
                ShardSyncer.cleanupLeaseForClosedShard(closedShardId, childShardIds, trackedLeaseMap, leaseManager);
            }
        }
    }

    static synchronized void cleanupLeaseForClosedShard(String closedShardId, Set<String> childShardIds, Map<String, KinesisClientLease> trackedLeases, ILeaseManager<KinesisClientLease> leaseManager) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        KinesisClientLease leaseForClosedShard = trackedLeases.get(closedShardId);
        ArrayList<KinesisClientLease> childShardLeases = new ArrayList<KinesisClientLease>();
        for (String childShardId : childShardIds) {
            KinesisClientLease childLease = trackedLeases.get(childShardId);
            if (childLease == null) continue;
            childShardLeases.add(childLease);
        }
        if (leaseForClosedShard != null && leaseForClosedShard.getCheckpoint().equals(ExtendedSequenceNumber.SHARD_END) && childShardLeases.size() == childShardIds.size()) {
            boolean okayToDelete = true;
            for (KinesisClientLease lease : childShardLeases) {
                if (!lease.getCheckpoint().equals(ExtendedSequenceNumber.TRIM_HORIZON)) continue;
                okayToDelete = false;
                break;
            }
            if (okayToDelete) {
                LOG.info("Deleting lease for shard " + leaseForClosedShard.getLeaseKey() + " as it has been completely processed and processing of child shards has begun.");
                leaseManager.deleteLease(leaseForClosedShard);
            }
        }
    }

    static KinesisClientLease newKCLLease(Shard shard) {
        KinesisClientLease newLease = new KinesisClientLease();
        newLease.setLeaseKey(shard.getShardId());
        ArrayList<String> parentShardIds = new ArrayList<String>(2);
        if (shard.getParentShardId() != null) {
            parentShardIds.add(shard.getParentShardId());
        }
        if (shard.getAdjacentParentShardId() != null) {
            parentShardIds.add(shard.getAdjacentParentShardId());
        }
        newLease.setParentShardIds(parentShardIds);
        newLease.setOwnerSwitchesSinceCheckpoint(0L);
        return newLease;
    }

    static Map<String, Shard> constructShardIdToShardMap(List<Shard> shards) {
        HashMap<String, Shard> shardIdToShardMap = new HashMap<String, Shard>();
        for (Shard shard : shards) {
            shardIdToShardMap.put(shard.getShardId(), shard);
        }
        return shardIdToShardMap;
    }

    static List<Shard> getOpenShards(List<Shard> allShards) {
        ArrayList<Shard> openShards = new ArrayList<Shard>();
        for (Shard shard : allShards) {
            String endingSequenceNumber = shard.getSequenceNumberRange().getEndingSequenceNumber();
            if (endingSequenceNumber != null) continue;
            openShards.add(shard);
            LOG.debug("Found open shard: " + shard.getShardId());
        }
        return openShards;
    }

    private static ExtendedSequenceNumber convertToCheckpoint(InitialPositionInStream position) {
        ExtendedSequenceNumber checkpoint2 = null;
        if (position.equals((Object)InitialPositionInStream.TRIM_HORIZON)) {
            checkpoint2 = ExtendedSequenceNumber.TRIM_HORIZON;
        } else if (position.equals((Object)InitialPositionInStream.LATEST)) {
            checkpoint2 = ExtendedSequenceNumber.LATEST;
        }
        return checkpoint2;
    }

    private static class StartingSequenceNumberAndShardIdBasedComparator
    implements Comparator<KinesisClientLease>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Shard> shardIdToShardMap;

        public StartingSequenceNumberAndShardIdBasedComparator(Map<String, Shard> shardIdToShardMapOfAllKinesisShards) {
            this.shardIdToShardMap = shardIdToShardMapOfAllKinesisShards;
        }

        @Override
        public int compare(KinesisClientLease lease1, KinesisClientLease lease2) {
            int result = 0;
            String shardId1 = lease1.getLeaseKey();
            String shardId2 = lease2.getLeaseKey();
            Shard shard1 = this.shardIdToShardMap.get(shardId1);
            Shard shard2 = this.shardIdToShardMap.get(shardId2);
            if (shard1 != null && shard2 != null) {
                BigInteger sequenceNumber1 = new BigInteger(shard1.getSequenceNumberRange().getStartingSequenceNumber());
                BigInteger sequenceNumber2 = new BigInteger(shard2.getSequenceNumberRange().getStartingSequenceNumber());
                result = sequenceNumber1.compareTo(sequenceNumber2);
            }
            if (result == 0) {
                result = shardId1.compareTo(shardId2);
            }
            return result;
        }
    }
}

