/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.types;

import com.amazonaws.services.kinesis.clientlibrary.types.Messages;
import com.amazonaws.services.kinesis.model.Record;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import kinesis.protobuf.InvalidProtocolBufferException;
import kinesis.protobuf.ProtocolStringList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserRecord
extends Record {
    private static final Log LOG = LogFactory.getLog(UserRecord.class);
    private static final byte[] AGGREGATED_RECORD_MAGIC = new byte[]{-13, -119, -102, -62};
    private static final int DIGEST_SIZE = 16;
    private static final BigInteger SMALLEST_HASH_KEY = new BigInteger("0");
    private static final BigInteger LARGEST_HASH_KEY = new BigInteger(StringUtils.repeat((String)"FF", (int)16), 16);
    private final long subSequenceNumber;
    private final String explicitHashKey;
    private final boolean aggregated;

    public UserRecord(Record record) {
        this(false, record, 0L, null);
    }

    protected UserRecord(boolean aggregated, Record record, long subSequenceNumber, String explicitHashKey) {
        if (subSequenceNumber < 0L) {
            throw new IllegalArgumentException("Cannot have an invalid, negative subsequence number");
        }
        this.aggregated = aggregated;
        this.subSequenceNumber = subSequenceNumber;
        this.explicitHashKey = explicitHashKey;
        this.setSequenceNumber(record.getSequenceNumber());
        this.setData(record.getData());
        this.setPartitionKey(record.getPartitionKey());
        this.setApproximateArrivalTimestamp(record.getApproximateArrivalTimestamp());
    }

    public long getSubSequenceNumber() {
        return this.subSequenceNumber;
    }

    public String getExplicitHashKey() {
        return this.explicitHashKey;
    }

    public boolean isAggregated() {
        return this.aggregated;
    }

    @Override
    public String toString() {
        return "UserRecord [subSequenceNumber=" + this.subSequenceNumber + ", explicitHashKey=" + this.explicitHashKey + ", aggregated=" + this.aggregated + ", getSequenceNumber()=" + this.getSequenceNumber() + ", getData()=" + this.getData() + ", getPartitionKey()=" + this.getPartitionKey() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aggregated ? 1231 : 1237);
        result = 31 * result + (this.explicitHashKey == null ? 0 : this.explicitHashKey.hashCode());
        result = 31 * result + (int)(this.subSequenceNumber ^ this.subSequenceNumber >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserRecord other = (UserRecord)obj;
        if (this.aggregated != other.aggregated) {
            return false;
        }
        if (this.explicitHashKey == null ? other.explicitHashKey != null : !this.explicitHashKey.equals(other.explicitHashKey)) {
            return false;
        }
        return this.subSequenceNumber == other.subSequenceNumber;
    }

    private static byte[] md5(byte[] data) {
        try {
            MessageDigest d = MessageDigest.getInstance("MD5");
            return d.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<UserRecord> deaggregate(List<Record> records) {
        return UserRecord.deaggregate(records, SMALLEST_HASH_KEY, LARGEST_HASH_KEY);
    }

    public static List<UserRecord> deaggregate(List<Record> records, BigInteger startingHashKey, BigInteger endingHashKey) {
        ArrayList<UserRecord> result = new ArrayList<UserRecord>();
        byte[] magic = new byte[AGGREGATED_RECORD_MAGIC.length];
        byte[] digest = new byte[16];
        for (Record r : records) {
            boolean isAggregated = true;
            long subSeqNum = 0L;
            ByteBuffer bb = r.getData();
            if (bb.remaining() >= magic.length) {
                bb.get(magic);
            } else {
                isAggregated = false;
            }
            if (!Arrays.equals(AGGREGATED_RECORD_MAGIC, magic) || bb.remaining() <= 16) {
                isAggregated = false;
            }
            if (isAggregated) {
                int oldLimit = bb.limit();
                bb.limit(oldLimit - 16);
                byte[] messageData = new byte[bb.remaining()];
                bb.get(messageData);
                bb.limit(oldLimit);
                bb.get(digest);
                byte[] calculatedDigest = UserRecord.md5(messageData);
                if (!Arrays.equals(digest, calculatedDigest)) {
                    isAggregated = false;
                } else {
                    try {
                        Messages.AggregatedRecord ar = Messages.AggregatedRecord.parseFrom(messageData);
                        ProtocolStringList pks = ar.getPartitionKeyTableList();
                        ProtocolStringList ehks = ar.getExplicitHashKeyTableList();
                        long aat = r.getApproximateArrivalTimestamp() == null ? -1L : r.getApproximateArrivalTimestamp().getTime();
                        try {
                            int recordsInCurrRecord = 0;
                            for (Messages.Record mr : ar.getRecordsList()) {
                                BigInteger effectiveHashKey;
                                String explicitHashKey = null;
                                String partitionKey = (String)pks.get((int)mr.getPartitionKeyIndex());
                                if (mr.hasExplicitHashKeyIndex()) {
                                    explicitHashKey = (String)ehks.get((int)mr.getExplicitHashKeyIndex());
                                }
                                BigInteger bigInteger = effectiveHashKey = explicitHashKey != null ? new BigInteger(explicitHashKey) : new BigInteger(1, UserRecord.md5(partitionKey.getBytes("UTF-8")));
                                if (effectiveHashKey.compareTo(startingHashKey) < 0 || effectiveHashKey.compareTo(endingHashKey) > 0) {
                                    for (int toRemove = 0; toRemove < recordsInCurrRecord; ++toRemove) {
                                        result.remove(result.size() - 1);
                                    }
                                    break;
                                }
                                ++recordsInCurrRecord;
                                Record record = new Record().withData(ByteBuffer.wrap(mr.getData().toByteArray())).withPartitionKey(partitionKey).withSequenceNumber(r.getSequenceNumber()).withApproximateArrivalTimestamp(aat < 0L ? null : new Date(aat));
                                result.add(new UserRecord(true, record, subSeqNum++, explicitHashKey));
                            }
                        }
                        catch (Exception e) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Unexpected exception during deaggregation, record was:\n");
                            sb.append("PKS:\n");
                            for (String s : pks) {
                                sb.append(s).append("\n");
                            }
                            sb.append("EHKS: \n");
                            for (String s : ehks) {
                                sb.append(s).append("\n");
                            }
                            for (Messages.Record mr : ar.getRecordsList()) {
                                sb.append("Record: [hasEhk=").append(mr.hasExplicitHashKeyIndex()).append(", ").append("ehkIdx=").append(mr.getExplicitHashKeyIndex()).append(", ").append("pkIdx=").append(mr.getPartitionKeyIndex()).append(", ").append("dataLen=").append(mr.getData().toByteArray().length).append("]\n");
                            }
                            sb.append("Sequence number: ").append(r.getSequenceNumber()).append("\n").append("Raw data: ").append(DatatypeConverter.printBase64Binary((byte[])messageData)).append("\n");
                            LOG.error(sb.toString(), e);
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        isAggregated = false;
                    }
                }
            }
            if (isAggregated) continue;
            bb.rewind();
            result.add(new UserRecord(r));
        }
        return result;
    }
}

