/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.metrics.impl;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.kinesis.metrics.impl.NullMetricsScope;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetricsHelper {
    private static final Log LOG = LogFactory.getLog(MetricsHelper.class);
    private static final NullMetricsScope NULL_METRICS_SCOPE = new NullMetricsScope();
    private static final ThreadLocal<IMetricsScope> currentScope = new ThreadLocal();
    private static final ThreadLocal<Integer> referenceCount = new ThreadLocal();
    public static final String OPERATION_DIMENSION_NAME = "Operation";
    public static final String SHARD_ID_DIMENSION_NAME = "ShardId";
    public static final String TIME = "Time";
    public static final String SUCCESS = "Success";
    private static final String SEP = ".";

    public static IMetricsScope startScope(IMetricsFactory factory) {
        return MetricsHelper.startScope(factory, null);
    }

    public static IMetricsScope startScope(IMetricsFactory factory, String operation) {
        IMetricsScope result = currentScope.get();
        if (result == null) {
            result = factory.createMetrics();
            if (operation != null) {
                result.addDimension(OPERATION_DIMENSION_NAME, operation);
            }
            currentScope.set(result);
            referenceCount.set(1);
        } else {
            referenceCount.set(referenceCount.get() + 1);
        }
        return result;
    }

    public static IMetricsScope getMetricsScope() {
        IMetricsScope result = currentScope.get();
        if (result == null) {
            LOG.warn(String.format("No metrics scope set in thread %s, getMetricsScope returning NullMetricsScope.", Thread.currentThread().getName()));
            return NULL_METRICS_SCOPE;
        }
        return result;
    }

    public static void addSuccessAndLatency(long startTimeMillis, boolean success, MetricsLevel level) {
        MetricsHelper.addSuccessAndLatency(null, startTimeMillis, success, level);
    }

    public static void addSuccessAndLatency(String prefix, long startTimeMillis, boolean success, MetricsLevel level) {
        MetricsHelper.addSuccessAndLatencyPerShard(null, prefix, startTimeMillis, success, level);
    }

    public static void addSuccessAndLatencyPerShard(String shardId, String prefix, long startTimeMillis, boolean success, MetricsLevel level) {
        MetricsHelper.addSuccessAndLatency(shardId, prefix, startTimeMillis, success, level, true, true);
    }

    public static void addLatency(long startTimeMillis, MetricsLevel level) {
        MetricsHelper.addLatency(null, startTimeMillis, level);
    }

    public static void addLatency(String prefix, long startTimeMillis, MetricsLevel level) {
        MetricsHelper.addLatencyPerShard(null, prefix, startTimeMillis, level);
    }

    public static void addLatencyPerShard(String shardId, String prefix, long startTimeMillis, MetricsLevel level) {
        MetricsHelper.addSuccessAndLatency(shardId, prefix, startTimeMillis, false, level, false, true);
    }

    private static void addSuccessAndLatency(String shardId, String prefix, long startTimeMillis, boolean success, MetricsLevel level, boolean includeSuccess, boolean includeLatency) {
        String realPrefix;
        IMetricsScope scope = MetricsHelper.getMetricsScope();
        String string = realPrefix = prefix == null ? "" : prefix + SEP;
        if (shardId != null) {
            scope.addDimension(SHARD_ID_DIMENSION_NAME, shardId);
        }
        if (includeSuccess) {
            scope.addData(realPrefix + SUCCESS, success ? 1.0 : 0.0, StandardUnit.Count, level);
        }
        if (includeLatency) {
            scope.addData(realPrefix + TIME, System.currentTimeMillis() - startTimeMillis, StandardUnit.Milliseconds, level);
        }
    }

    public static void endScope() {
        IMetricsScope scope = MetricsHelper.getMetricsScope();
        if (scope != null) {
            referenceCount.set(referenceCount.get() - 1);
            if (referenceCount.get() == 0) {
                scope.end();
                currentScope.remove();
            }
        }
    }
}

