/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutRecordsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<PutRecordsRequestEntry> records;
    private String streamName;

    public List<PutRecordsRequestEntry> getRecords() {
        if (this.records == null) {
            this.records = new ListWithAutoConstructFlag();
            this.records.setAutoConstruct(true);
        }
        return this.records;
    }

    public void setRecords(Collection<PutRecordsRequestEntry> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        ListWithAutoConstructFlag recordsCopy = new ListWithAutoConstructFlag(records.size());
        recordsCopy.addAll(records);
        this.records = recordsCopy;
    }

    public PutRecordsRequest withRecords(PutRecordsRequestEntry ... records) {
        if (this.getRecords() == null) {
            this.setRecords(new ArrayList<PutRecordsRequestEntry>(records.length));
        }
        for (PutRecordsRequestEntry value : records) {
            this.getRecords().add(value);
        }
        return this;
    }

    public PutRecordsRequest withRecords(Collection<PutRecordsRequestEntry> records) {
        if (records == null) {
            this.records = null;
        } else {
            ListWithAutoConstructFlag recordsCopy = new ListWithAutoConstructFlag(records.size());
            recordsCopy.addAll(records);
            this.records = recordsCopy;
        }
        return this;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName2) {
        this.streamName = streamName2;
    }

    public PutRecordsRequest withStreamName(String streamName2) {
        this.streamName = streamName2;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecords() != null) {
            sb.append("Records: " + this.getRecords() + ",");
        }
        if (this.getStreamName() != null) {
            sb.append("StreamName: " + this.getStreamName());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsRequest)) {
            return false;
        }
        PutRecordsRequest other = (PutRecordsRequest)obj;
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        if (other.getRecords() != null && !other.getRecords().equals(this.getRecords())) {
            return false;
        }
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        return other.getStreamName() == null || other.getStreamName().equals(this.getStreamName());
    }

    @Override
    public PutRecordsRequest clone() {
        return (PutRecordsRequest)super.clone();
    }
}

