/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class YarnUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Log LOG = LogFactory.getLog(YarnUncaughtExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (ShutdownHookManager.get().isShutdownInProgress()) {
            LOG.error("Thread " + t + " threw an Throwable, but we are shutting " + "down, so ignoring this", e);
        } else if (e instanceof Error) {
            try {
                LOG.fatal("Thread " + t + " threw an Error.  Shutting down now...", e);
            }
            catch (Throwable err) {
                // empty catch block
            }
            if (e instanceof OutOfMemoryError) {
                try {
                    System.err.println("Halting due to Out Of Memory Error...");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ExitUtil.halt((int)-1);
            } else {
                ExitUtil.terminate((int)-1);
            }
        } else {
            LOG.error("Thread " + t + " threw an Exception.", e);
        }
    }
}

