/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;

public class ClientRMProxy<T>
extends RMProxy<T> {
    private static final Log LOG = LogFactory.getLog(ClientRMProxy.class);

    public static <T> T createRMProxy(Configuration conf, Class<T> protocol) throws IOException {
        InetSocketAddress rmAddress = ClientRMProxy.getRMAddress(conf, protocol);
        return ClientRMProxy.createRMProxy(conf, protocol, rmAddress);
    }

    private static void setupTokens(InetSocketAddress resourceManagerAddress) throws IOException {
        for (Token token : UserGroupInformation.getCurrentUser().getTokens()) {
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)resourceManagerAddress);
        }
    }

    private static InetSocketAddress getRMAddress(Configuration conf, Class<?> protocol) throws IOException {
        if (protocol == ApplicationClientProtocol.class) {
            return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        }
        if (protocol == ResourceManagerAdministrationProtocol.class) {
            return conf.getSocketAddr("yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033);
        }
        if (protocol == ApplicationMasterProtocol.class) {
            InetSocketAddress serviceAddr = conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
            ClientRMProxy.setupTokens(serviceAddr);
            return serviceAddr;
        }
        String message = "Unsupported protocol found when creating the proxy connection to ResourceManager: " + (protocol != null ? protocol.getClass().getName() : "null");
        LOG.error(message);
        throw new IllegalStateException(message);
    }
}

