/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AsyncDispatcher
extends AbstractService
implements Dispatcher {
    private static final Log LOG = LogFactory.getLog(AsyncDispatcher.class);
    private final BlockingQueue<Event> eventQueue;
    private volatile boolean stopped = false;
    private Thread eventHandlingThread;
    protected final Map<Class<? extends Enum>, EventHandler> eventDispatchers;
    private boolean exitOnDispatchException;

    public AsyncDispatcher() {
        this(new LinkedBlockingQueue<Event>());
    }

    public AsyncDispatcher(BlockingQueue<Event> eventQueue) {
        super("Dispatcher");
        this.eventQueue = eventQueue;
        this.eventDispatchers = new HashMap<Class<? extends Enum>, EventHandler>();
    }

    Runnable createThread() {
        return new Runnable(){

            @Override
            public void run() {
                while (!AsyncDispatcher.this.stopped && !Thread.currentThread().isInterrupted()) {
                    Event event;
                    try {
                        event = (Event)AsyncDispatcher.this.eventQueue.take();
                    }
                    catch (InterruptedException ie) {
                        if (!AsyncDispatcher.this.stopped) {
                            LOG.warn("AsyncDispatcher thread interrupted", ie);
                        }
                        return;
                    }
                    if (event == null) continue;
                    AsyncDispatcher.this.dispatch(event);
                }
            }
        };
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.exitOnDispatchException = conf.getBoolean("yarn.dispatcher.exit-on-error", false);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.eventHandlingThread = new Thread(this.createThread());
        this.eventHandlingThread.setName("AsyncDispatcher event handler");
        this.eventHandlingThread.start();
    }

    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
            try {
                this.eventHandlingThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted Exception while stopping", ie);
            }
        }
        super.serviceStop();
    }

    protected void dispatch(Event event) {
        block4: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatching the event " + event.getClass().getName() + "." + ((Object)event).toString());
            }
            Class type = ((Enum)event.getType()).getDeclaringClass();
            try {
                EventHandler handler = this.eventDispatchers.get(type);
                if (handler == null) {
                    throw new Exception("No handler for registered for " + type);
                }
                handler.handle(event);
            }
            catch (Throwable t) {
                LOG.fatal("Error in dispatcher thread", t);
                if (!this.exitOnDispatchException || ShutdownHookManager.get().isShutdownInProgress()) break block4;
                LOG.info("Exiting, bbye..");
                System.exit(-1);
            }
        }
    }

    @Override
    public void register(Class<? extends Enum> eventType, EventHandler handler) {
        EventHandler registeredHandler = this.eventDispatchers.get(eventType);
        LOG.info("Registering " + eventType + " for " + handler.getClass());
        if (registeredHandler == null) {
            this.eventDispatchers.put(eventType, handler);
        } else if (!(registeredHandler instanceof MultiListenerHandler)) {
            MultiListenerHandler multiHandler = new MultiListenerHandler();
            multiHandler.addHandler(registeredHandler);
            multiHandler.addHandler(handler);
            this.eventDispatchers.put(eventType, multiHandler);
        } else {
            MultiListenerHandler multiHandler = (MultiListenerHandler)registeredHandler;
            multiHandler.addHandler(handler);
        }
    }

    @Override
    public EventHandler getEventHandler() {
        return new GenericEventHandler();
    }

    static class MultiListenerHandler
    implements EventHandler<Event> {
        List<EventHandler<Event>> listofHandlers = new ArrayList<EventHandler<Event>>();

        @Override
        public void handle(Event event) {
            for (EventHandler<Event> handler : this.listofHandlers) {
                handler.handle(event);
            }
        }

        void addHandler(EventHandler<Event> handler) {
            this.listofHandlers.add(handler);
        }
    }

    class GenericEventHandler
    implements EventHandler<Event> {
        GenericEventHandler() {
        }

        @Override
        public void handle(Event event) {
            int remCapacity;
            int qSize = AsyncDispatcher.this.eventQueue.size();
            if (qSize != 0 && qSize % 1000 == 0) {
                LOG.info("Size of event-queue is " + qSize);
            }
            if ((remCapacity = AsyncDispatcher.this.eventQueue.remainingCapacity()) < 1000) {
                LOG.warn("Very low remaining capacity in the event-queue: " + remCapacity);
            }
            try {
                AsyncDispatcher.this.eventQueue.put(event);
            }
            catch (InterruptedException e) {
                if (!AsyncDispatcher.this.stopped) {
                    LOG.warn("AsyncDispatcher thread interrupted", e);
                }
                throw new YarnRuntimeException(e);
            }
        }
    }
}

