/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.KinesisUtils;
import scala.Tuple2;

public final class JavaKinesisWordCountASL {
    private static final Pattern WORD_SEPARATOR = Pattern.compile(" ");

    public static void main(String[] args) throws Exception {
        Duration batchInterval;
        int numShards;
        if (args.length != 3) {
            System.err.println("Usage: JavaKinesisWordCountASL <stream-name> <endpoint-url>\n\n    <app-name> is the name of the app, used to track the read data in DynamoDB\n    <stream-name> is the name of the Kinesis stream\n    <endpoint-url> is the endpoint of the Kinesis service\n                   (e.g. https://kinesis.us-east-1.amazonaws.com)\nGenerate data for the Kinesis stream using the example KinesisWordProducerASL.\nSee http://spark.apache.org/docs/latest/streaming-kinesis-integration.html for more\ndetails.\n");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        String kinesisAppName = args[0];
        String streamName2 = args[1];
        String endpointUrl = args[2];
        AmazonKinesisClient kinesisClient = new AmazonKinesisClient(new DefaultAWSCredentialsProviderChain());
        kinesisClient.setEndpoint(endpointUrl);
        int numStreams = numShards = kinesisClient.describeStream(streamName2).getStreamDescription().getShards().size();
        Duration kinesisCheckpointInterval = batchInterval = new Duration(2000L);
        String regionName = RegionUtils.getRegionByEndpoint(endpointUrl).getName();
        SparkConf sparkConfig = new SparkConf().setAppName("JavaKinesisWordCountASL");
        JavaStreamingContext jssc = new JavaStreamingContext(sparkConfig, batchInterval);
        ArrayList<JavaReceiverInputDStream<byte[]>> streamsList = new ArrayList<JavaReceiverInputDStream<byte[]>>(numStreams);
        for (int i = 0; i < numStreams; ++i) {
            streamsList.add(KinesisUtils.createStream(jssc, kinesisAppName, streamName2, endpointUrl, regionName, InitialPositionInStream.LATEST, kinesisCheckpointInterval, StorageLevel.MEMORY_AND_DISK_2()));
        }
        JavaDStream unionStreams = streamsList.size() > 1 ? jssc.union((JavaDStream)streamsList.get(0), streamsList.subList(1, streamsList.size())) : (JavaDStream)streamsList.get(0);
        JavaDStream words = unionStreams.flatMap((FlatMapFunction)new FlatMapFunction<byte[], String>(){

            public Iterator<String> call(byte[] line) {
                String s = new String(line, StandardCharsets.UTF_8);
                return Arrays.asList(WORD_SEPARATOR.split(s)).iterator();
            }
        });
        JavaPairDStream wordCounts = words.mapToPair((PairFunction)new PairFunction<String, String, Integer>(){

            public Tuple2<String, Integer> call(String s) {
                return new Tuple2((Object)s, (Object)1);
            }
        }).reduceByKey((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        });
        wordCounts.print();
        jssc.start();
        jssc.awaitTermination();
    }
}

