/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import org.apache.spark.SparkConf;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.KinesisUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class KinesisWordCountASL$
implements Logging {
    public static final KinesisWordCountASL$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KinesisWordCountASL$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public void main(String[] args) {
        if (args.length != 3) {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("\n          |Usage: KinesisWordCountASL <app-name> <stream-name> <endpoint-url> <region-name>\n          |\n          |    <app-name> is the name of the consumer app, used to track the read data in DynamoDB\n          |    <stream-name> is the name of the Kinesis stream\n          |    <endpoint-url> is the endpoint of the Kinesis service\n          |                   (e.g. https://kinesis.us-east-1.amazonaws.com)\n          |\n          |Generate input data for Kinesis stream using the example KinesisWordProducerASL.\n          |See http://spark.apache.org/docs/latest/streaming-kinesis-integration.html for more\n          |details.\n        ")).stripMargin());
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
            Duration batchInterval;
            int numShards;
            Tuple3 tuple3;
            String appName = (String)((SeqLike)option.get()).apply(0);
            String streamName2 = (String)((SeqLike)option.get()).apply(1);
            String endpointUrl = (String)((SeqLike)option.get()).apply(2);
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)appName, (Object)streamName2, (Object)endpointUrl);
            String appName2 = (String)tuple32._1();
            String streamName3 = (String)tuple32._2();
            String endpointUrl2 = (String)tuple32._3();
            AWSCredentials credentials = new DefaultAWSCredentialsProviderChain().getCredentials();
            Predef$.MODULE$.require(credentials != null, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No AWS credentials found. Please specify credentials using one of the methods specified in http://docs.aws.amazon.com/AWSSdkDocsJava/latest/DeveloperGuide/credentials.html";
                }
            });
            AmazonKinesisClient kinesisClient = new AmazonKinesisClient(credentials);
            kinesisClient.setEndpoint(endpointUrl2);
            int numStreams = numShards = kinesisClient.describeStream(streamName3).getStreamDescription().getShards().size();
            Duration kinesisCheckpointInterval = batchInterval = Milliseconds$.MODULE$.apply(2000L);
            String regionName = RegionUtils.getRegionByEndpoint(endpointUrl2).getName();
            SparkConf sparkConfig = new SparkConf().setAppName("KinesisWordCountASL");
            StreamingContext ssc = new StreamingContext(sparkConfig, batchInterval);
            IndexedSeq kinesisStreams = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numStreams).map((Function1)new Serializable(appName2, streamName3, endpointUrl2, kinesisCheckpointInterval, regionName, ssc){
                public static final long serialVersionUID = 0L;
                private final String appName$1;
                private final String streamName$1;
                private final String endpointUrl$1;
                private final Duration kinesisCheckpointInterval$1;
                private final String regionName$1;
                private final StreamingContext ssc$1;

                public final ReceiverInputDStream<byte[]> apply(int i) {
                    return KinesisUtils$.MODULE$.createStream(this.ssc$1, this.appName$1, this.streamName$1, this.endpointUrl$1, this.regionName$1, InitialPositionInStream.LATEST, this.kinesisCheckpointInterval$1, StorageLevel$.MODULE$.MEMORY_AND_DISK_2());
                }
                {
                    this.appName$1 = appName$1;
                    this.streamName$1 = streamName$1;
                    this.endpointUrl$1 = endpointUrl$1;
                    this.kinesisCheckpointInterval$1 = kinesisCheckpointInterval$1;
                    this.regionName$1 = regionName$1;
                    this.ssc$1 = ssc$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            DStream unionStreams = ssc.union((Seq)kinesisStreams, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            DStream words = unionStreams.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<String> apply(byte[] byteArray) {
                    return Predef$.MODULE$.refArrayOps((Object[])new String(byteArray).split(" "));
                }
            }, ClassTag$.MODULE$.apply(String.class));
            DStream wordCounts = DStream$.MODULE$.toPairDStreamFunctions(words.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(String word) {
                    return new Tuple2((Object)word, (Object)BoxesRunTime.boxToInteger((int)1));
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$2, int x$3) {
                    return this.apply$mcIII$sp(x$2, x$3);
                }

                public int apply$mcIII$sp(int x$2, int x$3) {
                    return x$2 + x$3;
                }
            });
            wordCounts.print();
            ssc.start();
            ssc.awaitTermination();
            return;
        }
        throw new MatchError((Object)stringArray);
    }

    private KinesisWordCountASL$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

